/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.SentryDate;
import io.sentry.SentryDateProvider;
import io.sentry.SentryLevel;
import io.sentry.transport.ReusableCountLatch;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class QueuedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final int maxQueueSize;
    private SentryDate lastRejectTimestamp;
    private final ILogger logger;
    private final SentryDateProvider dateProvider;
    private final ReusableCountLatch unfinishedTasksCount;
    private static final long RECENT_THRESHOLD = DateUtils.millisToNanos(2000L);

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPoolExecutor(int corePoolSize, int maxQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler, ILogger logger, SentryDateProvider dateProvider) {
        void var2_2;
        void var3_3;
        void var1_1;
        void v0 = var1_1;
        super((int)v0, (int)v0, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)var3_3, rejectedExecutionHandler);
        this.lastRejectTimestamp = null;
        this.unfinishedTasksCount = new ReusableCountLatch();
        this.maxQueueSize = var2_2;
        this.logger = logger;
        this.dateProvider = dateProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable task) {
        if (this.isSchedulingAllowed()) {
            void var1_1;
            this.unfinishedTasksCount.increment();
            return super.submit((Runnable)var1_1);
        }
        this.lastRejectTimestamp = this.dateProvider.now();
        this.logger.log(SentryLevel.WARNING, "Submit cancelled", new Object[0]);
        return new CancelledFuture();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void afterExecute(Runnable r, Throwable t) {
        try {
            void var2_3;
            void var1_1;
            super.afterExecute((Runnable)var1_1, (Throwable)var2_3);
            return;
        }
        finally {
            this.unfinishedTasksCount.decrement();
        }
    }

    /*
     * WARNING - void declaration
     */
    final void waitTillIdle(long timeoutMillis) {
        try {
            this.unfinishedTasksCount.waitTillZero(timeoutMillis, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException e) {
            void var1_2;
            this.logger.log(SentryLevel.ERROR, "Failed to wait till idle", (Throwable)var1_2);
            Thread.currentThread().interrupt();
            return;
        }
    }

    public final boolean isSchedulingAllowed() {
        return this.unfinishedTasksCount.getCount() < this.maxQueueSize;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean didRejectRecently() {
        void var1_1;
        SentryDate lastReject = this.lastRejectTimestamp;
        if (lastReject == null) {
            return false;
        }
        long l = this.dateProvider.now().diff((SentryDate)var1_1);
        return l < RECENT_THRESHOLD;
    }

    static final class CancelledFuture<T>
    implements Future<T> {
        CancelledFuture() {
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public final boolean isCancelled() {
            return true;
        }

        @Override
        public final boolean isDone() {
            return true;
        }

        @Override
        public final T get() {
            throw new CancellationException();
        }

        @Override
        public final T get(long timeout, TimeUnit unit) {
            throw new CancellationException();
        }
    }
}

