/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.RequestDetails;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.transport.AuthenticatorWrapper;
import io.sentry.transport.ProxyAuthenticator;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.TransportResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

final class HttpConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Proxy proxy;
    private final RequestDetails requestDetails;
    private final SentryOptions options;
    private final RateLimiter rateLimiter;

    /*
     * WARNING - void declaration
     */
    public HttpConnection(SentryOptions options, RequestDetails requestDetails, RateLimiter rateLimiter) {
        this((SentryOptions)var1_1, (RequestDetails)var2_2, AuthenticatorWrapper.getInstance(), (RateLimiter)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    HttpConnection(SentryOptions options, RequestDetails requestDetails, AuthenticatorWrapper authenticatorWrapper, RateLimiter rateLimiter) {
        this.requestDetails = requestDetails;
        this.options = options;
        this.rateLimiter = rateLimiter;
        this.proxy = this.resolveProxy(options.getProxy());
        if (this.proxy != null && options.getProxy() != null) {
            String proxyUser = options.getProxy().getUser();
            String proxyPassword = options.getProxy().getPass();
            if (proxyUser != null && proxyPassword != null) {
                void var1_1;
                void var2_2;
                void var3_3;
                var3_3.setDefault(new ProxyAuthenticator((String)var2_2, (String)var1_1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Proxy resolveProxy(SentryOptions.Proxy optionsProxy) {
        void var2_2;
        Proxy proxy = null;
        if (optionsProxy != null) {
            String port = optionsProxy.getPort();
            String host = optionsProxy.getHost();
            if (port != null && host != null) {
                try {
                    void var3_3;
                    Proxy.Type type = optionsProxy.getType() != null ? optionsProxy.getType() : Proxy.Type.HTTP;
                    InetSocketAddress proxyAddr = new InetSocketAddress(host, Integer.parseInt(port));
                    proxy = new Proxy(type, (SocketAddress)var3_3);
                }
                catch (NumberFormatException e) {
                    void var1_1;
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to parse Sentry Proxy port: " + var1_1.getPort() + ". Proxy is ignored", new Object[0]);
                }
            }
        }
        return var2_2;
    }

    final HttpURLConnection open() throws IOException {
        return (HttpURLConnection)(this.proxy == null ? this.requestDetails.getUrl().openConnection() : this.requestDetails.getUrl().openConnection(this.proxy));
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection createConnection() throws IOException {
        void var1_1;
        HttpURLConnection connection = this.open();
        Iterator<Map.Entry<String, String>> iterator = this.requestDetails.getHeaders().entrySet().iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Map.Entry<String, String> header = iterator.next();
            connection.setRequestProperty(header.getKey(), (String)var3_3.getValue());
        }
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "gzip");
        connection.setRequestProperty("Content-Type", "application/x-sentry-envelope");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Connection", "close");
        connection.setConnectTimeout(this.options.getConnectionTimeoutMillis());
        connection.setReadTimeout(this.options.getReadTimeoutMillis());
        SSLSocketFactory sslSocketFactory = this.options.getSslSocketFactory();
        if (connection instanceof HttpsURLConnection && sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory((SSLSocketFactory)((Object)iterator));
        }
        connection.connect();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final TransportResult send(SentryEnvelope envelope) throws IOException {
        void var1_1;
        TransportResult result2;
        HttpURLConnection connection = this.createConnection();
        try {
            try (OutputStream outputStream = connection.getOutputStream();
                 GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                this.options.getSerializer().serialize(envelope, gzip);
            }
            result2 = this.readAndLog(connection);
        }
        catch (Throwable e) {
            try {
                void var3_7;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_7, "An exception occurred while submitting the envelope to the Sentry server.", new Object[0]);
                result2 = this.readAndLog(connection);
            }
            catch (Throwable result2) {
                void var2_5;
                this.readAndLog((HttpURLConnection)var2_5);
                throw result2;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TransportResult readAndLog(HttpURLConnection connection) {
        block6: {
            TransportResult transportResult;
            int responseCode = connection.getResponseCode();
            this.updateRetryAfterLimits(connection, responseCode);
            if (this.isSuccessfulResponseCode(responseCode)) break block6;
            this.options.getLogger().log(SentryLevel.ERROR, "Request failed, API returned %s", responseCode);
            if (this.options.isDebug()) {
                String errorMessage = this.getErrorMessageFromStream(connection);
                this.options.getLogger().log(SentryLevel.ERROR, "%s", transportResult);
            }
            transportResult = TransportResult.error(responseCode);
            this.closeAndDisconnect(connection);
            return transportResult;
        }
        try {
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope sent successfully.", new Object[0]);
            TransportResult transportResult = TransportResult.success();
            this.closeAndDisconnect(connection);
            return transportResult;
        }
        catch (IOException e) {
            try {
                void var2_3;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var2_3, "Error reading and logging the response stream", new Object[0]);
                this.closeAndDisconnect(connection);
            }
            catch (Throwable throwable) {
                void var1_1;
                this.closeAndDisconnect((HttpURLConnection)var1_1);
                throw throwable;
            }
        }
        return TransportResult.error();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRetryAfterLimits(HttpURLConnection connection, int responseCode) {
        void var2_2;
        void var3_3;
        void var1_1;
        String retryAfterHeader = connection.getHeaderField("Retry-After");
        String sentryRateLimitHeader = connection.getHeaderField("X-Sentry-Rate-Limits");
        this.rateLimiter.updateRetryAfterLimits((String)var1_1, (String)var3_3, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void closeAndDisconnect(HttpURLConnection connection) {
        try {
            connection.getInputStream().close();
            connection.disconnect();
            return;
        }
        catch (IOException iOException) {
            connection.disconnect();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.disconnect();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private String getErrorMessageFromStream(HttpURLConnection connection) {
        String string;
        InputStream errorStream;
        block15: {
            String line;
            errorStream = connection.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
            string = ((StringBuilder)((Object)string)).toString();
            reader.close();
            if (errorStream == null) break block15;
            errorStream.close();
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            void var2_2;
                            var2_2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (errorStream != null) {
                            try {
                                void var1_1;
                                var1_1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    return "Failed to obtain error message while analyzing send failure.";
                }
            }
        }
    }

    private boolean isSuccessfulResponseCode(int responseCode) {
        return responseCode == 200;
    }
}

