/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.RequestDetails;
import io.sentry.SentryDate;
import io.sentry.SentryDateProvider;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.Cached;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.Enqueable;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.HttpConnection;
import io.sentry.transport.ITransport;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.QueuedThreadPoolExecutor;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.TransportResult;
import io.sentry.util.HintUtils;
import io.sentry.util.LogUtils;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class AsyncHttpTransport
implements ITransport {
    private final QueuedThreadPoolExecutor executor;
    private final IEnvelopeCache envelopeCache;
    private final SentryOptions options;
    private final RateLimiter rateLimiter;
    private final ITransportGate transportGate;
    private final HttpConnection connection;
    private volatile Runnable currentRunnable = null;

    /*
     * WARNING - void declaration
     */
    public AsyncHttpTransport(SentryOptions options, RateLimiter rateLimiter, ITransportGate transportGate, RequestDetails requestDetails) {
        this(AsyncHttpTransport.initExecutor(options.getMaxQueueSize(), options.getEnvelopeDiskCache(), options.getLogger(), options.getDateProvider()), options, rateLimiter, (ITransportGate)var3_3, new HttpConnection((SentryOptions)var1_1, requestDetails, (RateLimiter)var2_2));
        void var2_2;
        void var1_1;
        void var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AsyncHttpTransport(QueuedThreadPoolExecutor executor, SentryOptions options, RateLimiter rateLimiter, ITransportGate transportGate, HttpConnection httpConnection) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.executor = (QueuedThreadPoolExecutor)Objects.requireNonNull(var1_1, "executor is required");
        this.envelopeCache = Objects.requireNonNull(options.getEnvelopeDiskCache(), "envelopeCache is required");
        this.options = (SentryOptions)Objects.requireNonNull(var2_2, "options is required");
        this.rateLimiter = (RateLimiter)Objects.requireNonNull(var3_3, "rateLimiter is required");
        this.transportGate = Objects.requireNonNull(transportGate, "transportGate is required");
        this.connection = Objects.requireNonNull(httpConnection, "httpConnection is required");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void send(SentryEnvelope envelope, Hint hint) throws IOException {
        SentryEnvelope filteredEnvelope;
        IEnvelopeCache currentEnvelopeCache = this.envelopeCache;
        boolean cached = false;
        if (HintUtils.hasType(hint, Cached.class)) {
            currentEnvelopeCache = NoOpEnvelopeCache.getInstance();
            cached = true;
            this.options.getLogger().log(SentryLevel.DEBUG, "Captured Envelope is already cached", new Object[0]);
        }
        if ((filteredEnvelope = this.rateLimiter.filter(envelope, hint)) == null) {
            if (cached) {
                this.envelopeCache.discard(envelope);
                return;
            }
        } else {
            void var2_2;
            void var3_3;
            SentryEnvelope envelopeThatMayIncludeClientReport = HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class) ? this.options.getClientReportRecorder().attachReportToEnvelope(filteredEnvelope) : filteredEnvelope;
            Future<?> future = this.executor.submit(new EnvelopeSender(envelopeThatMayIncludeClientReport, hint, currentEnvelopeCache));
            if (future != null && var3_3.isCancelled()) {
                void var1_1;
                this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.QUEUE_OVERFLOW, (SentryEnvelope)var1_1);
                return;
            }
            HintUtils.runIfHasType((Hint)var2_2, Enqueable.class, enqueable -> {
                enqueable.markEnqueued();
                this.options.getLogger().log(SentryLevel.DEBUG, "Envelope enqueued", new Object[0]);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        void var1_1;
        this.executor.waitTillIdle((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static QueuedThreadPoolExecutor initExecutor(int maxQueueSize, IEnvelopeCache envelopeCache, ILogger logger, SentryDateProvider dateProvider) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        RejectedExecutionHandler storeEvents = (r, executor) -> {
            if (r instanceof EnvelopeSender) {
                void var1_1;
                void var2_2;
                EnvelopeSender envelopeSender = (EnvelopeSender)r;
                if (!HintUtils.hasType(envelopeSender.hint, Cached.class)) {
                    IEnvelopeCache iEnvelopeCache;
                    iEnvelopeCache.store(envelopeSender.envelope, envelopeSender.hint);
                }
                AsyncHttpTransport.markHintWhenSendingFailed(((EnvelopeSender)var2_2).hint, true);
                var1_1.log(SentryLevel.WARNING, "Envelope rejected", new Object[0]);
            }
        };
        return new QueuedThreadPoolExecutor(1, n, new AsyncConnectionThreadFactory(), (RejectedExecutionHandler)var1_1, (ILogger)var2_2, (SentryDateProvider)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isHealthy() {
        void var2_2;
        void var1_1;
        boolean anyRateLimitActive = this.rateLimiter.isAnyRateLimitActive();
        boolean didRejectRecently = this.executor.didRejectRecently();
        return var1_1 == false && var2_2 == false;
    }

    @Override
    public final void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(boolean isRestarting) throws IOException {
        this.rateLimiter.close();
        this.executor.shutdown();
        this.options.getLogger().log(SentryLevel.DEBUG, "Shutting down", new Object[0]);
        try {
            void var1_1;
            long timeout;
            long l = timeout = var1_1 != false ? 0L : this.options.getFlushTimeoutMillis();
            if (!this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                void var2_2;
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to shutdown the async connection async sender  within " + (long)var2_2 + " ms. Trying to force it now.", new Object[0]);
                this.executor.shutdownNow();
                if (this.currentRunnable != null) {
                    this.executor.getRejectedExecutionHandler().rejectedExecution(this.currentRunnable, this.executor);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void markHintWhenSendingFailed(Hint hint, boolean retry) {
        void var1_1;
        Hint hint2;
        HintUtils.runIfHasType(hint, SubmissionResult.class, result -> result.setResult(false));
        HintUtils.runIfHasType(hint2, Retryable.class, arg_0 -> AsyncHttpTransport.lambda$markHintWhenSendingFailed$3((boolean)var1_1, arg_0));
    }

    private static /* synthetic */ void lambda$markHintWhenSendingFailed$3(boolean retry, Retryable retryable) {
        boolean bl;
        retryable.setRetry(bl);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Runnable access$102(AsyncHttpTransport x0, Runnable x1) {
        void var1_1;
        x0.currentRunnable = var1_1;
        return x0.currentRunnable;
    }

    private final class EnvelopeSender
    implements Runnable {
        private final SentryEnvelope envelope;
        private final Hint hint;
        private final IEnvelopeCache envelopeCache;
        private final TransportResult failedResult = TransportResult.error();

        /*
         * WARNING - void declaration
         */
        EnvelopeSender(SentryEnvelope envelope, Hint hint, IEnvelopeCache envelopeCache) {
            void var3_3;
            void var2_2;
            this.envelope = (SentryEnvelope)Objects.requireNonNull(var2_2, "Envelope is required.");
            this.hint = var3_3;
            this.envelopeCache = Objects.requireNonNull(envelopeCache, "EnvelopeCache is required.");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            TransportResult finalResult;
            AsyncHttpTransport.access$102(AsyncHttpTransport.this, this);
            TransportResult result = this.failedResult;
            try {
                result = this.flush();
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Envelope flushed", new Object[0]);
                finalResult = result;
            }
            catch (Throwable e) {
                try {
                    void var2_3;
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, e, "Envelope submission failed", new Object[0]);
                    throw var2_3;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    HintUtils.runIfHasType(this.hint, SubmissionResult.class, arg_0 -> this.lambda$run$0((TransportResult)var1_1, arg_0));
                    AsyncHttpTransport.access$102(AsyncHttpTransport.this, null);
                    throw throwable;
                }
            }
            HintUtils.runIfHasType(this.hint, SubmissionResult.class, submissionResult -> {
                void var1_1;
                void var2_2;
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Marking envelope submission result: %s", finalResult.isSuccess());
                var2_2.setResult(var1_1.isSuccess());
            });
            AsyncHttpTransport.access$102(AsyncHttpTransport.this, null);
            return;
        }

        /*
         * WARNING - void declaration
         */
        private TransportResult flush() {
            void var1_1;
            TransportResult result = this.failedResult;
            this.envelope.getHeader().setSentAt(null);
            this.envelopeCache.store(this.envelope, this.hint);
            HintUtils.runIfHasType(this.hint, DiskFlushNotification.class, diskFlushNotification -> {
                if (diskFlushNotification.isFlushable(this.envelope.getHeader().getEventId())) {
                    void var1_1;
                    var1_1.markFlushed();
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Disk flush envelope fired", new Object[0]);
                    return;
                }
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Not firing envelope flush as there's an ongoing transaction", new Object[0]);
            });
            if (AsyncHttpTransport.this.transportGate.isConnected()) {
                SentryEnvelope envelopeWithClientReport = AsyncHttpTransport.this.options.getClientReportRecorder().attachReportToEnvelope(this.envelope);
                try {
                    Object now = AsyncHttpTransport.this.options.getDateProvider().now();
                    envelopeWithClientReport.getHeader().setSentAt(DateUtils.nanosToDate(((SentryDate)now).nanoTimestamp()));
                    now = AsyncHttpTransport.this.connection.send(envelopeWithClientReport);
                    if (!((TransportResult)now).isSuccess()) {
                        void var3_4;
                        String message = "The transport failed to send the envelope with response code " + ((TransportResult)now).getResponseCode();
                        AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, message, new Object[0]);
                        if (((TransportResult)now).getResponseCode() >= 400 && ((TransportResult)now).getResponseCode() != 429) {
                            HintUtils.runIfDoesNotHaveType(this.hint, Retryable.class, hint -> {
                                void var1_1;
                                AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, (SentryEnvelope)var1_1);
                            });
                        }
                        throw new IllegalStateException((String)var3_4);
                    }
                    this.envelopeCache.discard(this.envelope);
                }
                catch (IOException e) {
                    void var1_2;
                    void var2_3;
                    HintUtils.runIfHasType(this.hint, Retryable.class, retryable -> retryable.setRetry(true), (arg_0, arg_1) -> this.lambda$flush$4((SentryEnvelope)var2_3, arg_0, arg_1));
                    throw new IllegalStateException("Sending the event failed.", (Throwable)var1_2);
                }
            } else {
                HintUtils.runIfHasType(this.hint, Retryable.class, retryable -> retryable.setRetry(true), (hint, clazz) -> {
                    void var1_1;
                    LogUtils.logNotInstanceOf(clazz, var1_1, AsyncHttpTransport.this.options.getLogger());
                    AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, this.envelope);
                });
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$flush$4(SentryEnvelope envelopeWithClientReport, Object hint, Class clazz) {
            void var1_1;
            void var2_2;
            LogUtils.logNotInstanceOf(clazz, var2_2, AsyncHttpTransport.this.options.getLogger());
            AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, (SentryEnvelope)var1_1);
        }
    }

    private static final class AsyncConnectionThreadFactory
    implements ThreadFactory {
        private int cnt;

        private AsyncConnectionThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(Runnable r) {
            void var1_1;
            Thread ret = new Thread(r, "SentryAsyncConnection-" + this.cnt++);
            ret.setDaemon(true);
            return var1_1;
        }
    }
}

