/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.rrweb;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebEventType;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RRWebVideoEvent
extends RRWebEvent
implements JsonSerializable {
    private String tag = "video";
    private int segmentId;
    private long size;
    private long durationMs;
    private String encoding = "h264";
    private String container = "mp4";
    private int height;
    private int width;
    private int frameCount;
    private String frameRateType = "constant";
    private int frameRate;
    private int left;
    private int top;
    private Map<String, Object> unknown;
    private Map<String, Object> payloadUnknown;
    private Map<String, Object> dataUnknown;

    public RRWebVideoEvent() {
        super(RRWebEventType.Custom);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPayloadUnknown(Map<String, Object> payloadUnknown) {
        void var1_1;
        this.payloadUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataUnknown(Map<String, Object> dataUnknown) {
        void var1_1;
        this.dataUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RRWebVideoEvent that = (RRWebVideoEvent)o;
        return this.segmentId == that.segmentId && this.size == that.size && this.durationMs == that.durationMs && this.height == that.height && this.width == that.width && this.frameCount == that.frameCount && this.frameRate == that.frameRate && this.left == that.left && this.top == that.top && Objects.equals(this.tag, that.tag) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.container, that.container) && Objects.equals(this.frameRateType, var1_1.frameRateType);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.tag, this.segmentId, this.size, this.durationMs, this.encoding, this.container, this.height, this.width, this.frameCount, this.frameRateType, this.frameRate, this.left, this.top);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer, logger);
        writer.name("data");
        this.serializeData(writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeData(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("tag").value(this.tag);
        writer.name("payload");
        this.serializePayload(writer, logger);
        if (this.dataUnknown != null) {
            for (String key : this.dataUnknown.keySet()) {
                Object value = this.dataUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializePayload(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("segmentId").value(this.segmentId);
        writer.name("size").value(this.size);
        writer.name("duration").value(this.durationMs);
        writer.name("encoding").value(this.encoding);
        writer.name("container").value(this.container);
        writer.name("height").value(this.height);
        writer.name("width").value(this.width);
        writer.name("frameCount").value(this.frameCount);
        writer.name("frameRate").value(this.frameRate);
        writer.name("frameRateType").value(this.frameRateType);
        writer.name("left").value(this.left);
        writer.name("top").value(this.top);
        if (this.payloadUnknown != null) {
            for (String key : this.payloadUnknown.keySet()) {
                Object value = this.payloadUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(RRWebVideoEvent x0, String x1) {
        void var1_1;
        x0.tag = var1_1;
        return x0.tag;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$102(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.segmentId = var1_1;
        return x0.segmentId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$202(RRWebVideoEvent x0, long x1) {
        void var1_1;
        x0.size = var1_1;
        return x0.size;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$302(RRWebVideoEvent x0, long x1) {
        void var1_1;
        x0.durationMs = var1_1;
        return x0.durationMs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(RRWebVideoEvent x0, String x1) {
        void var1_1;
        x0.container = var1_1;
        return x0.container;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(RRWebVideoEvent x0, String x1) {
        void var1_1;
        x0.encoding = var1_1;
        return x0.encoding;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$602(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.height = var1_1;
        return x0.height;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$702(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.width = var1_1;
        return x0.width;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$802(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.frameCount = var1_1;
        return x0.frameCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$902(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.frameRate = var1_1;
        return x0.frameRate;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1002(RRWebVideoEvent x0, String x1) {
        void var1_1;
        x0.frameRateType = var1_1;
        return x0.frameRateType;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1102(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.left = var1_1;
        return x0.left;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1202(RRWebVideoEvent x0, int x1) {
        void var1_1;
        x0.top = var1_1;
        return x0.top;
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebVideoEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final RRWebVideoEvent deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            HashMap<String, Object> unknown = null;
            RRWebVideoEvent event = new RRWebVideoEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "data": {
                        this.deserializeData(event, reader, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event, nextName, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            event.setUnknown((Map<String, Object>)var3_3);
            var1_1.endObject();
            return event;
        }

        /*
         * WARNING - void declaration
         */
        private void deserializeData(RRWebVideoEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> dataUnknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "tag": {
                        String tag = reader.nextStringOrNull();
                        RRWebVideoEvent.access$002(event, tag == null ? "" : tag);
                        continue block8;
                    }
                    case "payload": {
                        this.deserializePayload(event, reader, logger);
                        continue block8;
                    }
                }
                if (dataUnknown == null) {
                    dataUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, dataUnknown, (String)var5_5);
            }
            var1_1.setDataUnknown(dataUnknown);
            var2_2.endObject();
        }

        /*
         * WARNING - void declaration
         */
        private void deserializePayload(RRWebVideoEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> payloadUnknown = null;
            reader.beginObject();
            block28: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "segmentId": {
                        RRWebVideoEvent.access$102(event, reader.nextInt());
                        continue block28;
                    }
                    case "size": {
                        Long size = reader.nextLongOrNull();
                        RRWebVideoEvent.access$202(event, size == null ? 0L : size);
                        continue block28;
                    }
                    case "duration": {
                        RRWebVideoEvent.access$302(event, reader.nextLong());
                        continue block28;
                    }
                    case "container": {
                        String container = reader.nextStringOrNull();
                        RRWebVideoEvent.access$402(event, container == null ? "" : container);
                        continue block28;
                    }
                    case "encoding": {
                        String encoding = reader.nextStringOrNull();
                        RRWebVideoEvent.access$502(event, encoding == null ? "" : encoding);
                        continue block28;
                    }
                    case "height": {
                        Integer height = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$602(event, height == null ? 0 : height);
                        continue block28;
                    }
                    case "width": {
                        Integer width = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$702(event, width == null ? 0 : width);
                        continue block28;
                    }
                    case "frameCount": {
                        Integer frameCount = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$802(event, frameCount == null ? 0 : frameCount);
                        continue block28;
                    }
                    case "frameRate": {
                        Integer frameRate = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$902(event, frameRate == null ? 0 : frameRate);
                        continue block28;
                    }
                    case "frameRateType": {
                        String frameRateType = reader.nextStringOrNull();
                        RRWebVideoEvent.access$1002(event, frameRateType == null ? "" : frameRateType);
                        continue block28;
                    }
                    case "left": {
                        Integer left = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$1102(event, left == null ? 0 : left);
                        continue block28;
                    }
                    case "top": {
                        Integer top = reader.nextIntegerOrNull();
                        RRWebVideoEvent.access$1202(event, top == null ? 0 : top);
                        continue block28;
                    }
                }
                if (payloadUnknown == null) {
                    payloadUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, payloadUnknown, (String)var5_5);
            }
            var1_1.setPayloadUnknown(payloadUnknown);
            var2_2.endObject();
        }
    }
}

