/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.rrweb;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebEventType;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RRWebSpanEvent
extends RRWebEvent
implements JsonSerializable {
    private String tag = "performanceSpan";
    private String op;
    private String description;
    private double startTimestamp;
    private double endTimestamp;
    private Map<String, Object> data;
    private Map<String, Object> unknown;
    private Map<String, Object> payloadUnknown;
    private Map<String, Object> dataUnknown;

    public RRWebSpanEvent() {
        super(RRWebEventType.Custom);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPayloadUnknown(Map<String, Object> payloadUnknown) {
        void var1_1;
        this.payloadUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataUnknown(Map<String, Object> dataUnknown) {
        void var1_1;
        this.dataUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer, logger);
        writer.name("data");
        this.serializeData(writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeData(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("tag").value(this.tag);
        writer.name("payload");
        this.serializePayload(writer, logger);
        if (this.dataUnknown != null) {
            for (String key : this.dataUnknown.keySet()) {
                Object value = this.dataUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializePayload(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.op != null) {
            writer.name("op").value(this.op);
        }
        if (this.description != null) {
            writer.name("description").value(this.description);
        }
        writer.name("startTimestamp").value(logger, BigDecimal.valueOf(this.startTimestamp));
        writer.name("endTimestamp").value(logger, BigDecimal.valueOf(this.endTimestamp));
        if (this.data != null) {
            writer.name("data").value(logger, this.data);
        }
        if (this.payloadUnknown != null) {
            for (String key : this.payloadUnknown.keySet()) {
                Object value = this.payloadUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(RRWebSpanEvent x0, String x1) {
        void var1_1;
        x0.tag = var1_1;
        return x0.tag;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(RRWebSpanEvent x0, String x1) {
        void var1_1;
        x0.op = var1_1;
        return x0.op;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(RRWebSpanEvent x0, String x1) {
        void var1_1;
        x0.description = var1_1;
        return x0.description;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$302(RRWebSpanEvent x0, double x1) {
        void var1_1;
        x0.startTimestamp = var1_1;
        return x0.startTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$402(RRWebSpanEvent x0, double x1) {
        void var1_1;
        x0.endTimestamp = var1_1;
        return x0.endTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$502(RRWebSpanEvent x0, Map x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebSpanEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final RRWebSpanEvent deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            HashMap<String, Object> unknown = null;
            RRWebSpanEvent event = new RRWebSpanEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "data": {
                        this.deserializeData(event, reader, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event, nextName, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            event.setUnknown((Map<String, Object>)var3_3);
            var1_1.endObject();
            return event;
        }

        /*
         * WARNING - void declaration
         */
        private void deserializeData(RRWebSpanEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> dataUnknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "tag": {
                        String tag = reader.nextStringOrNull();
                        RRWebSpanEvent.access$002(event, tag == null ? "" : tag);
                        continue block8;
                    }
                    case "payload": {
                        this.deserializePayload(event, reader, logger);
                        continue block8;
                    }
                }
                if (dataUnknown == null) {
                    dataUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, dataUnknown, (String)var5_5);
            }
            var1_1.setDataUnknown(dataUnknown);
            var2_2.endObject();
        }

        /*
         * WARNING - void declaration
         */
        private void deserializePayload(RRWebSpanEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> payloadUnknown = null;
            reader.beginObject();
            block14: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "op": {
                        RRWebSpanEvent.access$102(event, reader.nextStringOrNull());
                        continue block14;
                    }
                    case "description": {
                        RRWebSpanEvent.access$202(event, reader.nextStringOrNull());
                        continue block14;
                    }
                    case "startTimestamp": {
                        RRWebSpanEvent.access$302(event, reader.nextDouble());
                        continue block14;
                    }
                    case "endTimestamp": {
                        RRWebSpanEvent.access$402(event, reader.nextDouble());
                        continue block14;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        if (deserializedData == null) continue block14;
                        RRWebSpanEvent.access$502(event, deserializedData);
                        continue block14;
                    }
                }
                if (payloadUnknown == null) {
                    payloadUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, payloadUnknown, (String)var5_5);
            }
            var1_1.setPayloadUnknown(payloadUnknown);
            var2_2.endObject();
        }
    }
}

