/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.rrweb;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebEventType;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RRWebBreadcrumbEvent
extends RRWebEvent
implements JsonSerializable {
    private String tag = "breadcrumb";
    private double breadcrumbTimestamp;
    private String breadcrumbType;
    private String category;
    private String message;
    private SentryLevel level;
    private Map<String, Object> data;
    private Map<String, Object> unknown;
    private Map<String, Object> payloadUnknown;
    private Map<String, Object> dataUnknown;

    public RRWebBreadcrumbEvent() {
        super(RRWebEventType.Custom);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPayloadUnknown(Map<String, Object> payloadUnknown) {
        void var1_1;
        this.payloadUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataUnknown(Map<String, Object> dataUnknown) {
        void var1_1;
        this.dataUnknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer, logger);
        writer.name("data");
        this.serializeData(writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeData(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("tag").value(this.tag);
        writer.name("payload");
        this.serializePayload(writer, logger);
        if (this.dataUnknown != null) {
            for (String key : this.dataUnknown.keySet()) {
                Object value = this.dataUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void serializePayload(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.breadcrumbType != null) {
            writer.name("type").value(this.breadcrumbType);
        }
        writer.name("timestamp").value(logger, BigDecimal.valueOf(this.breadcrumbTimestamp));
        if (this.category != null) {
            writer.name("category").value(this.category);
        }
        if (this.message != null) {
            writer.name("message").value(this.message);
        }
        if (this.level != null) {
            writer.name("level").value(logger, this.level);
        }
        if (this.data != null) {
            writer.name("data").value(logger, this.data);
        }
        if (this.payloadUnknown != null) {
            for (String key : this.payloadUnknown.keySet()) {
                Object value = this.payloadUnknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(RRWebBreadcrumbEvent x0, String x1) {
        void var1_1;
        x0.tag = var1_1;
        return x0.tag;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(RRWebBreadcrumbEvent x0, String x1) {
        void var1_1;
        x0.breadcrumbType = var1_1;
        return x0.breadcrumbType;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$202(RRWebBreadcrumbEvent x0, double x1) {
        void var1_1;
        x0.breadcrumbTimestamp = var1_1;
        return x0.breadcrumbTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(RRWebBreadcrumbEvent x0, String x1) {
        void var1_1;
        x0.category = var1_1;
        return x0.category;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(RRWebBreadcrumbEvent x0, String x1) {
        void var1_1;
        x0.message = var1_1;
        return x0.message;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryLevel access$502(RRWebBreadcrumbEvent x0, SentryLevel x1) {
        void var1_1;
        x0.level = var1_1;
        return x0.level;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$602(RRWebBreadcrumbEvent x0, Map x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebBreadcrumbEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final RRWebBreadcrumbEvent deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            HashMap<String, Object> unknown = null;
            RRWebBreadcrumbEvent event = new RRWebBreadcrumbEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "data": {
                        this.deserializeData(event, reader, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event, nextName, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            event.setUnknown((Map<String, Object>)var3_3);
            var1_1.endObject();
            return event;
        }

        /*
         * WARNING - void declaration
         */
        private void deserializeData(RRWebBreadcrumbEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> dataUnknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "tag": {
                        String tag = reader.nextStringOrNull();
                        RRWebBreadcrumbEvent.access$002(event, tag == null ? "" : tag);
                        continue block8;
                    }
                    case "payload": {
                        this.deserializePayload(event, reader, logger);
                        continue block8;
                    }
                }
                if (dataUnknown == null) {
                    dataUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, dataUnknown, (String)var5_5);
            }
            var1_1.setDataUnknown(dataUnknown);
            var2_2.endObject();
        }

        /*
         * WARNING - void declaration
         */
        private void deserializePayload(RRWebBreadcrumbEvent event, ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            void var1_1;
            ConcurrentHashMap<String, Object> payloadUnknown = null;
            reader.beginObject();
            block18: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "type": {
                        RRWebBreadcrumbEvent.access$102(event, reader.nextStringOrNull());
                        continue block18;
                    }
                    case "timestamp": {
                        RRWebBreadcrumbEvent.access$202(event, reader.nextDouble());
                        continue block18;
                    }
                    case "category": {
                        RRWebBreadcrumbEvent.access$302(event, reader.nextStringOrNull());
                        continue block18;
                    }
                    case "message": {
                        RRWebBreadcrumbEvent.access$402(event, reader.nextStringOrNull());
                        continue block18;
                    }
                    case "level": {
                        try {
                            RRWebBreadcrumbEvent.access$502(event, new SentryLevel.Deserializer().deserialize(reader, logger));
                        }
                        catch (Exception exception) {
                            logger.log(SentryLevel.DEBUG, exception, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block18;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        if (deserializedData == null) continue block18;
                        RRWebBreadcrumbEvent.access$602(event, deserializedData);
                        continue block18;
                    }
                }
                if (payloadUnknown == null) {
                    payloadUnknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, payloadUnknown, (String)var5_5);
            }
            var1_1.setPayloadUnknown(payloadUnknown);
            var2_2.endObject();
        }
    }
}

