/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.TransactionInfo;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentryTransaction
extends SentryBaseEvent
implements JsonSerializable {
    private String transaction;
    private Double startTimestamp;
    private Double timestamp;
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    private final String type = "transaction";
    private final Map<String, MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
    private TransactionInfo transactionInfo;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentryTransaction(String transaction, Double startTimestamp, Double timestamp, List<SentrySpan> spans, Map<String, MeasurementValue> measurements, TransactionInfo transactionInfo) {
        void var3_3;
        Iterator<SentrySpan> iterator;
        this.transaction = iterator;
        this.startTimestamp = startTimestamp;
        this.timestamp = var3_3;
        this.spans.addAll(spans);
        this.measurements.putAll(measurements);
        for (SentrySpan span : spans) {
            void var2_2;
            this.measurements.putAll(var2_2.getMeasurements());
        }
        this.transactionInfo = transactionInfo;
    }

    public final List<SentrySpan> getSpans() {
        return this.spans;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        SentryTransaction sentryTransaction = this;
        writer.name("start_timestamp").value(logger, sentryTransaction.doubleToBigDecimal(sentryTransaction.startTimestamp));
        if (this.timestamp != null) {
            SentryTransaction sentryTransaction2 = this;
            writer.name("timestamp").value(logger, sentryTransaction2.doubleToBigDecimal(sentryTransaction2.timestamp));
        }
        if (!this.spans.isEmpty()) {
            writer.name("spans").value(logger, this.spans);
        }
        writer.name("type").value("transaction");
        if (!this.measurements.isEmpty()) {
            writer.name("measurements").value(logger, this.measurements);
        }
        writer.name("transaction_info").value(logger, this.transactionInfo);
        new SentryBaseEvent.Serializer().serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    private BigDecimal doubleToBigDecimal(Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(SentryTransaction x0, String x1) {
        void var1_1;
        x0.transaction = var1_1;
        return x0.transaction;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$102(SentryTransaction x0, Double x1) {
        void var1_1;
        x0.startTimestamp = var1_1;
        return x0.startTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$202(SentryTransaction x0, Double x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TransactionInfo access$502(SentryTransaction x0, TransactionInfo x1) {
        void var1_1;
        x0.transactionInfo = var1_1;
        return x0.transactionInfo;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryTransaction> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryTransaction deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            SentryTransaction transaction = new SentryTransaction("", 0.0, null, new ArrayList<SentrySpan>(), new HashMap<String, MeasurementValue>(), new TransactionInfo(TransactionNameSource.CUSTOM.apiName()));
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block22: while (reader.peek() == JsonToken.NAME) {
                void var6_6;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "transaction": {
                        SentryTransaction.access$002(transaction, reader.nextStringOrNull());
                        continue block22;
                    }
                    case "start_timestamp": {
                        Date date;
                        try {
                            Double deserializedStartTimestamp = reader.nextDoubleOrNull();
                            if (deserializedStartTimestamp == null) continue block22;
                            SentryTransaction.access$102(transaction, deserializedStartTimestamp);
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            SentryTransaction.access$102(transaction, DateUtils.dateToSeconds(date));
                        }
                        continue block22;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            Double deserializedTimestamp = reader.nextDoubleOrNull();
                            if (deserializedTimestamp == null) continue block22;
                            SentryTransaction.access$202(transaction, deserializedTimestamp);
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            SentryTransaction.access$202(transaction, DateUtils.dateToSeconds(date));
                        }
                        continue block22;
                    }
                    case "spans": {
                        List<SentrySpan> deserializedSpans = reader.nextListOrNull(logger, new SentrySpan.Deserializer());
                        if (deserializedSpans == null) continue block22;
                        transaction.spans.addAll(deserializedSpans);
                        continue block22;
                    }
                    case "type": {
                        reader.nextString();
                        continue block22;
                    }
                    case "measurements": {
                        Map<String, MeasurementValue> deserializedMeasurements = reader.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        if (deserializedMeasurements == null) continue block22;
                        transaction.measurements.putAll(deserializedMeasurements);
                        continue block22;
                    }
                    case "transaction_info": {
                        SentryTransaction.access$502(transaction, new TransactionInfo.Deserializer().deserialize(reader, logger));
                        continue block22;
                    }
                }
                if (baseEventDeserializer.deserializeValue(transaction, (String)var6_6, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var6_6);
            }
            transaction.setUnknown(unknown);
            var1_1.endObject();
            return var3_3;
        }
    }
}

