/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class SentryPackage
implements JsonSerializable {
    private String name;
    private String version;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentryPackage(String name, String version) {
        void var2_2;
        void var1_1;
        this.name = (String)io.sentry.util.Objects.requireNonNull(var1_1, "name is required.");
        this.version = (String)io.sentry.util.Objects.requireNonNull(var2_2, "version is required.");
    }

    public final String getName() {
        return this.name;
    }

    public final String getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryPackage that = (SentryPackage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, var1_1.version);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("name").value(this.name);
        writer.name("version").value(this.version);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryPackage> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryPackage deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            IllegalStateException exception;
            String message;
            void var1_1;
            String name = null;
            String version = null;
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block8;
                    }
                    case "version": {
                        version = reader.nextString();
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            var1_1.endObject();
            if (name == null) {
                message = "Missing required field \"name\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (version == null) {
                void var2_2;
                message = "Missing required field \"version\"";
                exception = new IllegalStateException(message);
                var2_2.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            SentryPackage sentryPackage = new SentryPackage((String)var3_3, version);
            sentryPackage.setUnknown(unknown);
            return sentryPackage;
        }
    }
}

