/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryUUID;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.StringUtils;
import io.sentry.util.UUIDStringUtils;
import java.io.IOException;
import java.util.UUID;

public final class SentryId
implements JsonSerializable {
    public static final SentryId EMPTY_ID = new SentryId("00000000-0000-0000-0000-000000000000".replace("-", ""));
    private final LazyEvaluator<String> lazyStringValue;

    public SentryId() {
        this((UUID)null);
    }

    /*
     * WARNING - void declaration
     */
    public SentryId(UUID uuid) {
        if (uuid != null) {
            void var1_1;
            this.lazyStringValue = new LazyEvaluator<String>(() -> this.lambda$new$0((UUID)var1_1));
            return;
        }
        this.lazyStringValue = new LazyEvaluator<String>(SentryUUID::generateSentryId);
    }

    /*
     * WARNING - void declaration
     */
    public SentryId(String sentryIdString) {
        void var2_2;
        String normalized = StringUtils.normalizeUUID(sentryIdString);
        if (normalized.length() != 32 && normalized.length() != 36) {
            void var1_1;
            throw new IllegalArgumentException("String representation of SentryId has either 32 (UUID no dashes) or 36 characters long (completed UUID). Received: " + (String)var1_1);
        }
        if (normalized.length() == 36) {
            this.lazyStringValue = new LazyEvaluator<String>(() -> {
                void var1_1;
                return this.normalize((String)var1_1);
            });
            return;
        }
        this.lazyStringValue = new LazyEvaluator<String>(() -> SentryId.lambda$new$2((String)var2_2));
    }

    public final String toString() {
        return this.lazyStringValue.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryId sentryId = (SentryId)o;
        return this.lazyStringValue.getValue().equals(var1_1.lazyStringValue.getValue());
    }

    public final int hashCode() {
        return this.lazyStringValue.getValue().hashCode();
    }

    private String normalize(String uuidString) {
        return StringUtils.normalizeUUID(uuidString).replace("-", "");
    }

    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        writer.value(this.toString());
    }

    private static /* synthetic */ String lambda$new$2(String normalized) {
        return normalized;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String lambda$new$0(UUID uuid) {
        void var1_1;
        return this.normalize(UUIDStringUtils.toSentryIdString((UUID)var1_1));
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryId> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryId deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            return new SentryId(var1_1.nextString());
        }
    }
}

