/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MeasurementValue
implements JsonSerializable {
    private final Number value;
    private final String unit;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public MeasurementValue(Number value, String unit) {
        void var2_2;
        void var1_1;
        this.value = var1_1;
        this.unit = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("value").value(this.value);
        if (this.unit != null) {
            writer.name("unit").value(this.unit);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<MeasurementValue> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final MeasurementValue deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            String unit = null;
            Number value = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block8: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "value": {
                        value = (Number)reader.nextObjectOrNull();
                        continue block8;
                    }
                    case "unit": {
                        unit = reader.nextStringOrNull();
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            var1_1.endObject();
            if (value == null) {
                void var2_2;
                IllegalStateException ex = new IllegalStateException("Missing required field \"value\"");
                var2_2.log(SentryLevel.ERROR, "Missing required field \"value\"", ex);
                throw ex;
            }
            MeasurementValue measurement = new MeasurementValue(value, (String)var3_3);
            measurement.setUnknown(unknown);
            return measurement;
        }
    }
}

