/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.ProfileContext;
import io.sentry.SpanContext;
import io.sentry.protocol.App;
import io.sentry.protocol.Browser;
import io.sentry.protocol.Device;
import io.sentry.protocol.Gpu;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.Response;
import io.sentry.protocol.SentryRuntime;
import io.sentry.protocol.Spring;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Contexts
implements JsonSerializable {
    private final ConcurrentHashMap<String, Object> internalStorage = new ConcurrentHashMap();
    protected final AutoClosableReentrantLock responseLock = new AutoClosableReentrantLock();

    public Contexts() {
    }

    /*
     * WARNING - void declaration
     */
    public Contexts(Contexts contexts) {
        Iterator<Map.Entry<String, Object>> iterator;
        for (Map.Entry<String, Object> entry : ((Contexts)((Object)iterator)).entrySet()) {
            void var3_3;
            void var2_2;
            if (entry == null) continue;
            Object value = entry.getValue();
            if ("app".equals(entry.getKey()) && value instanceof App) {
                this.setApp(new App((App)value));
                continue;
            }
            if ("browser".equals(entry.getKey()) && value instanceof Browser) {
                this.setBrowser(new Browser((Browser)value));
                continue;
            }
            if ("device".equals(entry.getKey()) && value instanceof Device) {
                this.setDevice(new Device((Device)value));
                continue;
            }
            if ("os".equals(entry.getKey()) && value instanceof OperatingSystem) {
                this.setOperatingSystem(new OperatingSystem((OperatingSystem)value));
                continue;
            }
            if ("runtime".equals(entry.getKey()) && value instanceof SentryRuntime) {
                this.setRuntime(new SentryRuntime((SentryRuntime)value));
                continue;
            }
            if ("gpu".equals(entry.getKey()) && value instanceof Gpu) {
                this.setGpu(new Gpu((Gpu)value));
                continue;
            }
            if ("trace".equals(entry.getKey()) && value instanceof SpanContext) {
                this.setTrace(new SpanContext((SpanContext)value));
                continue;
            }
            if ("profile".equals(entry.getKey()) && value instanceof ProfileContext) {
                this.setProfile(new ProfileContext((ProfileContext)value));
                continue;
            }
            if ("response".equals(entry.getKey()) && value instanceof Response) {
                this.setResponse(new Response((Response)value));
                continue;
            }
            if ("spring".equals(entry.getKey()) && value instanceof Spring) {
                this.setSpring(new Spring((Spring)value));
                continue;
            }
            this.put((String)var2_2.getKey(), var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T toContextType(String key, Class<T> clazz) {
        Object item = this.get(key);
        if (clazz.isInstance(item)) {
            void var1_1;
            void var2_2;
            return var2_2.cast(var1_1);
        }
        return null;
    }

    public SpanContext getTrace() {
        return this.toContextType("trace", SpanContext.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setTrace(SpanContext traceContext) {
        void var1_1;
        Objects.requireNonNull(traceContext, "traceContext is required");
        this.put("trace", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setProfile(ProfileContext profileContext) {
        void var1_1;
        Objects.requireNonNull(profileContext, "profileContext is required");
        this.put("profile", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setApp(App app) {
        void var1_1;
        this.put("app", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setBrowser(Browser browser) {
        void var1_1;
        this.put("browser", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDevice(Device device) {
        void var1_1;
        this.put("device", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        void var1_1;
        this.put("os", var1_1);
    }

    public SentryRuntime getRuntime() {
        return this.toContextType("runtime", SentryRuntime.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setRuntime(SentryRuntime runtime) {
        void var1_1;
        this.put("runtime", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setGpu(Gpu gpu) {
        void var1_1;
        this.put("gpu", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setResponse(Response response) {
        ISentryLifecycleToken ignored = this.responseLock.acquire();
        try {
            void var1_1;
            this.put("response", var1_1);
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSpring(Spring spring) {
        void var1_1;
        this.put("spring", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(Object key) {
        void var1_1;
        if (key == null) {
            return false;
        }
        return this.internalStorage.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object get(Object key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.internalStorage.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object put(String key, Object value) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        if (value == null) {
            return this.internalStorage.remove(key);
        }
        return this.internalStorage.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(Object key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.internalStorage.remove(var1_1);
    }

    public Enumeration<String> keys() {
        return this.internalStorage.keys();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalStorage.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(Contexts contexts) {
        void var1_1;
        if (contexts == null) {
            return;
        }
        this.internalStorage.putAll(var1_1.internalStorage);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Contexts) {
            void var1_1;
            Contexts otherContexts = (Contexts)obj;
            return this.internalStorage.equals(var1_1.internalStorage);
        }
        return false;
    }

    public int hashCode() {
        return this.internalStorage.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        Iterator iterator;
        writer.beginObject();
        ArrayList<String> sortedKeys = Collections.list(this.keys());
        Collections.sort(sortedKeys);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = this.get(key);
            if (value == null) continue;
            writer.name(key).value(logger, value);
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<Contexts> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final Contexts deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            Contexts contexts = new Contexts();
            reader.beginObject();
            block24: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "app": {
                        contexts.setApp(new App.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "browser": {
                        contexts.setBrowser(new Browser.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "device": {
                        contexts.setDevice(new Device.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "gpu": {
                        contexts.setGpu(new Gpu.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "os": {
                        contexts.setOperatingSystem(new OperatingSystem.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "runtime": {
                        contexts.setRuntime(new SentryRuntime.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "trace": {
                        contexts.setTrace(new SpanContext.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "profile": {
                        contexts.setProfile(new ProfileContext.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "response": {
                        contexts.setResponse(new Response.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                    case "spring": {
                        contexts.setSpring(new Spring.Deserializer().deserialize(reader, logger));
                        continue block24;
                    }
                }
                Object object = reader.nextObjectOrNull();
                if (object == null) continue;
                contexts.put(nextName, object);
            }
            var1_1.endObject();
            return var3_3;
        }
    }
}

