/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.profilemeasurements;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryDate;
import io.sentry.SentryNanotimeDate;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ProfileMeasurementValue
implements JsonSerializable {
    private Map<String, Object> unknown;
    private Double timestamp;
    private String relativeStartNs;
    private double value;

    public ProfileMeasurementValue() {
        this(0L, 0, new SentryNanotimeDate(new Date(0L), 0L));
    }

    /*
     * WARNING - void declaration
     */
    public ProfileMeasurementValue(Long relativeStartNs, Number value, SentryDate timestamp) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.relativeStartNs = var1_1.toString();
        this.value = var2_2.doubleValue();
        this.timestamp = DateUtils.nanosToSeconds(var3_3.nanoTimestamp());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileMeasurementValue that = (ProfileMeasurementValue)o;
        return Objects.equals(this.unknown, that.unknown) && this.relativeStartNs.equals(that.relativeStartNs) && this.value == that.value && Objects.equals(this.timestamp, var1_1.timestamp);
    }

    public final int hashCode() {
        return Objects.hash(this.unknown, this.relativeStartNs, this.value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("value").value(logger, this.value);
        writer.name("elapsed_since_start_ns").value(logger, this.relativeStartNs);
        if (this.timestamp != null) {
            ProfileMeasurementValue profileMeasurementValue = this;
            writer.name("timestamp").value(logger, profileMeasurementValue.doubleToBigDecimal(profileMeasurementValue.timestamp));
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    private BigDecimal doubleToBigDecimal(Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$002(ProfileMeasurementValue x0, double x1) {
        void var1_1;
        x0.value = var1_1;
        return x0.value;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(ProfileMeasurementValue x0, String x1) {
        void var1_1;
        x0.relativeStartNs = var1_1;
        return x0.relativeStartNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$202(ProfileMeasurementValue x0, Double x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileMeasurementValue> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final ProfileMeasurementValue deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            ProfileMeasurementValue data = new ProfileMeasurementValue();
            ConcurrentHashMap<String, Object> unknown = null;
            block12: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "value": {
                        Double value = reader.nextDoubleOrNull();
                        if (value == null) continue block12;
                        ProfileMeasurementValue.access$002(data, value);
                        continue block12;
                    }
                    case "elapsed_since_start_ns": {
                        String startNs = reader.nextStringOrNull();
                        if (startNs == null) continue block12;
                        ProfileMeasurementValue.access$102(data, startNs);
                        continue block12;
                    }
                    case "timestamp": {
                        Double timestamp;
                        try {
                            timestamp = reader.nextDoubleOrNull();
                        }
                        catch (NumberFormatException numberFormatException) {
                            Date date = reader.nextDateOrNull(logger);
                            Double d = timestamp = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        if (timestamp == null) continue block12;
                        ProfileMeasurementValue.access$202(data, timestamp);
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var5_5);
            }
            data.setUnknown(unknown);
            var1_1.endObject();
            return var3_3;
        }
    }
}

