/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.sentry.NoOpLogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOpenTelemetryMode;
import io.sentry.SentryOptions;
import io.sentry.util.LoadClass;
import io.sentry.util.Platform;
import io.sentry.util.SpanUtils;
import java.util.Collections;
import java.util.List;

public final class OpenTelemetryUtil {
    /*
     * WARNING - void declaration
     */
    public static void applyIgnoredSpanOrigins(SentryOptions options) {
        if (Platform.isJvm()) {
            Object object = OpenTelemetryUtil.ignoredSpanOrigins(options);
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                String origin = (String)object.next();
                options.addIgnoredSpanOrigin((String)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateOpenTelemetryModeIfAuto(SentryOptions options, LoadClass loadClass) {
        void var2_2;
        if (!Platform.isJvm()) {
            return;
        }
        SentryOpenTelemetryMode openTelemetryMode = options.getOpenTelemetryMode();
        if (SentryOpenTelemetryMode.AUTO.equals(var2_2)) {
            void var1_1;
            if (loadClass.isClassAvailable("io.sentry.opentelemetry.agent.AgentMarker", NoOpLogger.getInstance())) {
                options.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENT", new Object[0]);
                options.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENT);
                return;
            }
            if (loadClass.isClassAvailable("io.sentry.opentelemetry.agent.AgentlessMarker", NoOpLogger.getInstance())) {
                options.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENTLESS", new Object[0]);
                options.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENTLESS);
                return;
            }
            if (var1_1.isClassAvailable("io.sentry.opentelemetry.agent.AgentlessSpringMarker", NoOpLogger.getInstance())) {
                SentryOptions sentryOptions;
                options.getLogger().log(SentryLevel.DEBUG, "openTelemetryMode has been inferred from AUTO to AGENTLESS_SPRING", new Object[0]);
                sentryOptions.setOpenTelemetryMode(SentryOpenTelemetryMode.AGENTLESS_SPRING);
                return;
            }
        }
    }

    private static List<String> ignoredSpanOrigins(SentryOptions options) {
        Object object;
        Object openTelemetryMode = options.getOpenTelemetryMode();
        if (SentryOpenTelemetryMode.OFF.equals(openTelemetryMode)) {
            return Collections.emptyList();
        }
        return SpanUtils.ignoredSpanOriginsForOpenTelemetry((SentryOpenTelemetryMode)((Object)object));
    }
}

