/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal.modules;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.internal.modules.ModulesLoader;
import io.sentry.util.ClassLoaderUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ManifestModulesLoader
extends ModulesLoader {
    private final Pattern URL_LIB_PATTERN = Pattern.compile(".*/(.+)!/META-INF/MANIFEST.MF");
    private final Pattern NAME_AND_VERSION = Pattern.compile("(.*?)-(\\d+\\.\\d+.*).jar");
    private final ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    public ManifestModulesLoader(ILogger logger) {
        this(ManifestModulesLoader.class.getClassLoader(), (ILogger)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ManifestModulesLoader(ClassLoader classLoader, ILogger logger) {
        super((ILogger)var2_2);
        void var1_1;
        void var2_2;
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault((ClassLoader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Map<String, String> loadModules() {
        void var1_1;
        HashMap<String, String> modules = new HashMap<String, String>();
        Object object = this.detectModulesViaManifestFiles();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Module module = (Module)object.next();
            modules.put(module.name, ((Module)var3_3).version);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Module> detectModulesViaManifestFiles() {
        void var1_1;
        ArrayList<void> modules = new ArrayList<void>();
        try {
            Enumeration<URL> manifestUrls = this.classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                void var3_4;
                URL manifestUrl = manifestUrls.nextElement();
                String originalName = this.extractDependencyNameFromUrl(manifestUrl);
                Module module = this.convertOriginalNameToModule(originalName);
                if (module == null) continue;
                modules.add(var3_4);
            }
        }
        catch (Throwable e) {
            void var2_3;
            this.logger.log(SentryLevel.ERROR, "Unable to detect modules via manifest files.", (Throwable)var2_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Module convertOriginalNameToModule(String originalName) {
        if (originalName == null) {
            return null;
        }
        Matcher matcher = this.NAME_AND_VERSION.matcher(originalName);
        if (matcher.matches() && matcher.groupCount() == 2) {
            void var1_1;
            void var2_2;
            String moduleName = matcher.group(1);
            String moduleVersion = matcher.group(2);
            return new Module((String)var2_2, (String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String extractDependencyNameFromUrl(URL url) {
        String urlString = url.toString();
        Matcher matcher = this.URL_LIB_PATTERN.matcher(urlString);
        if (matcher.matches() && matcher.groupCount() == 1) {
            void var1_1;
            return var1_1.group(1);
        }
        return null;
    }

    private static final class Module {
        private final String name;
        private final String version;

        /*
         * WARNING - void declaration
         */
        public Module(String name, String version) {
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.version = var2_2;
        }
    }
}

