/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal;

import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.protocol.SentryPackage;
import io.sentry.util.AutoClosableReentrantLock;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ManifestVersionReader {
    private static volatile ManifestVersionReader INSTANCE;
    private static final AutoClosableReentrantLock staticLock;
    private volatile boolean hasManifestBeenRead = false;
    private volatile VersionInfoHolder versionInfo = null;
    private AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public static ManifestVersionReader getInstance() {
        if (INSTANCE == null) {
            ISentryLifecycleToken ignored = staticLock.acquire();
            try {
                if (INSTANCE == null) {
                    INSTANCE = new ManifestVersionReader();
                }
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var0;
                        var0.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return INSTANCE;
    }

    private ManifestVersionReader() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readManifestFiles() {
        VersionInfoHolder infoHolder;
        block17: {
            ISentryLifecycleToken ignored;
            if (this.hasManifestBeenRead) {
                return;
            }
            infoHolder = null;
            try {
                ignored = this.lock.acquire();
                try {
                    if (this.hasManifestBeenRead) {
                        if (ignored != null) {
                            ignored.close();
                        }
                        this.hasManifestBeenRead = true;
                        this.versionInfo = null;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (ignored == null) throw throwable;
                    try {
                        void var2_2;
                        var2_2.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.hasManifestBeenRead = true;
                this.versionInfo = infoHolder;
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                this.hasManifestBeenRead = true;
                this.versionInfo = var1_1;
                throw throwable;
            }
            {
                Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    try {
                        Manifest manifest = new Manifest(resources.nextElement().openStream());
                        Attributes mainAttributes = manifest.getMainAttributes();
                        if (mainAttributes == null) continue;
                        String name = mainAttributes.getValue("Sentry-Opentelemetry-SDK-Name");
                        String version = mainAttributes.getValue("Implementation-Version");
                        String sdkName = mainAttributes.getValue("Sentry-SDK-Name");
                        String packageName = mainAttributes.getValue("Sentry-SDK-Package-Name");
                        if (name != null && version != null) {
                            String otelJavaagentVersion;
                            infoHolder = new VersionInfoHolder();
                            VersionInfoHolder.access$002(infoHolder, name);
                            VersionInfoHolder.access$102(infoHolder, version);
                            infoHolder.packages.add(new SentryPackage("maven:io.sentry:sentry-opentelemetry-agent", version));
                            String otelVersion = mainAttributes.getValue("Sentry-Opentelemetry-Version-Name");
                            if (otelVersion != null) {
                                infoHolder.packages.add(new SentryPackage("maven:io.opentelemetry:opentelemetry-sdk", otelVersion));
                                infoHolder.integrations.add("OpenTelemetry");
                            }
                            if ((otelJavaagentVersion = mainAttributes.getValue("Sentry-Opentelemetry-Javaagent-Version-Name")) == null) break;
                            infoHolder.packages.add(new SentryPackage("maven:io.opentelemetry.javaagent:opentelemetry-javaagent", otelJavaagentVersion));
                            infoHolder.integrations.add("OpenTelemetry-Agent");
                            break;
                        }
                        if (sdkName == null || version == null || packageName == null || !sdkName.startsWith("sentry.java")) continue;
                        SentryIntegrationPackageStorage.getInstance().addPackage(packageName, version);
                    }
                    catch (Exception exception) {}
                }
                if (ignored == null) break block17;
                ignored.close();
            }
        }
        this.hasManifestBeenRead = true;
        this.versionInfo = infoHolder;
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }

    public static final class VersionInfoHolder {
        private String sdkName;
        private String sdkVersion;
        private List<SentryPackage> packages = new ArrayList<SentryPackage>();
        private List<String> integrations = new ArrayList<String>();

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$002(VersionInfoHolder x0, String x1) {
            void var1_1;
            x0.sdkName = var1_1;
            return x0.sdkName;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$102(VersionInfoHolder x0, String x1) {
            void var1_1;
            x0.sdkVersion = var1_1;
            return x0.sdkVersion;
        }
    }
}

