/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.clientreport;

import io.sentry.DataCategory;
import io.sentry.DateUtils;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.AtomicClientReportStorage;
import io.sentry.clientreport.ClientReport;
import io.sentry.clientreport.ClientReportKey;
import io.sentry.clientreport.DiscardReason;
import io.sentry.clientreport.DiscardedEvent;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.IClientReportStorage;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryTransaction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class ClientReportRecorder
implements IClientReportRecorder {
    private final IClientReportStorage storage;
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public ClientReportRecorder(SentryOptions options) {
        void var1_1;
        this.options = var1_1;
        this.storage = new AtomicClientReportStorage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEnvelope attachReportToEnvelope(SentryEnvelope envelope) {
        ClientReport clientReport = this.resetCountsAndGenerateClientReport();
        if (clientReport == null) {
            return envelope;
        }
        try {
            void var2_2;
            this.options.getLogger().log(SentryLevel.DEBUG, "Attaching client report to envelope.", new Object[0]);
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                items.add(item);
            }
            items.add(SentryEnvelopeItem.fromClientReport(this.options.getSerializer(), (ClientReport)var2_2));
            return new SentryEnvelope(envelope.getHeader(), items);
        }
        catch (Throwable e) {
            void var1_1;
            void var3_4;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_4, "Unable to attach client report to envelope.", new Object[0]);
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEnvelope(DiscardReason reason, SentryEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        try {
            for (SentryEnvelopeItem item : ((SentryEnvelope)envelope).getItems()) {
                void var3_4;
                this.recordLostEnvelopeItem(reason, (SentryEnvelopeItem)var3_4);
            }
            return;
        }
        catch (Throwable e) {
            void var2_3;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var2_3, "Unable to record lost envelope.", new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEnvelopeItem(DiscardReason reason, SentryEnvelopeItem envelopeItem) {
        block7: {
            if (envelopeItem == null) {
                return;
            }
            try {
                void var1_1;
                SentryTransaction transaction;
                ClientReport clientReport;
                SentryItemType itemType = envelopeItem.getHeader().getType();
                if (SentryItemType.ClientReport.equals(itemType)) {
                    try {
                        clientReport = envelopeItem.getClientReport(this.options.getSerializer());
                        this.restoreCountsFromClientReport(clientReport);
                    }
                    catch (Exception exception) {
                        this.options.getLogger().log(SentryLevel.ERROR, "Unable to restore counts from previous client report.", new Object[0]);
                    }
                    break block7;
                }
                DataCategory itemCategory = this.categoryFromItemType((SentryItemType)((Object)clientReport));
                if (itemCategory.equals((Object)DataCategory.Transaction) && (transaction = envelopeItem.getTransaction(this.options.getSerializer())) != null) {
                    void var2_2;
                    List<SentrySpan> spans = transaction.getSpans();
                    this.recordLostEventInternal(reason.getReason(), DataCategory.Span.getCategory(), (long)var2_2.size() + 1L);
                }
                this.recordLostEventInternal(var1_1.getReason(), itemCategory.getCategory(), 1L);
                return;
            }
            catch (Throwable e) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_4, "Unable to record lost envelope item.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEvent(DiscardReason reason, DataCategory category) {
        void var2_2;
        void var1_1;
        this.recordLostEvent((DiscardReason)var1_1, (DataCategory)var2_2, 1L);
    }

    /*
     * WARNING - void declaration
     */
    public final void recordLostEvent(DiscardReason reason, DataCategory category, long count) {
        try {
            void var3_4;
            void var2_3;
            this.recordLostEventInternal(reason.getReason(), var2_3.getCategory(), (long)var3_4);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var1_2, "Unable to record lost event.", new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void recordLostEventInternal(String reason, String category, Long countToAdd) {
        void var3_3;
        void var1_1;
        void var2_2;
        ClientReportKey key = new ClientReportKey(reason, (String)var2_2);
        this.storage.addCount((ClientReportKey)var1_1, (Long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final ClientReport resetCountsAndGenerateClientReport() {
        void var2_2;
        void var1_1;
        Date currentDate = DateUtils.getCurrentDateTime();
        List<DiscardedEvent> discardedEvents = this.storage.resetCountsAndGet();
        if (discardedEvents.isEmpty()) {
            return null;
        }
        return new ClientReport((Date)var1_1, (List<DiscardedEvent>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void restoreCountsFromClientReport(ClientReport clientReport) {
        Iterator<DiscardedEvent> iterator;
        if (clientReport == null) {
            return;
        }
        for (DiscardedEvent discardedEvent : ((ClientReport)((Object)iterator)).getDiscardedEvents()) {
            void var2_2;
            this.recordLostEventInternal(discardedEvent.getReason(), discardedEvent.getCategory(), var2_2.getQuantity());
        }
    }

    /*
     * WARNING - void declaration
     */
    private DataCategory categoryFromItemType(SentryItemType itemType) {
        void var1_1;
        if (SentryItemType.Event.equals(itemType)) {
            return DataCategory.Error;
        }
        if (SentryItemType.Session.equals(itemType)) {
            return DataCategory.Session;
        }
        if (SentryItemType.Transaction.equals(itemType)) {
            return DataCategory.Transaction;
        }
        if (SentryItemType.UserFeedback.equals(itemType)) {
            return DataCategory.UserReport;
        }
        if (SentryItemType.Profile.equals(itemType)) {
            return DataCategory.Profile;
        }
        if (SentryItemType.ProfileChunk.equals(itemType)) {
            return DataCategory.ProfileChunk;
        }
        if (SentryItemType.Attachment.equals(itemType)) {
            return DataCategory.Attachment;
        }
        if (SentryItemType.CheckIn.equals(itemType)) {
            return DataCategory.Monitor;
        }
        if (SentryItemType.ReplayVideo.equals(var1_1)) {
            return DataCategory.Replay;
        }
        return DataCategory.Default;
    }
}

