/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.clientreport;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.clientreport.DiscardedEvent;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ClientReport
implements JsonSerializable {
    private final Date timestamp;
    private final List<DiscardedEvent> discardedEvents;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public ClientReport(Date timestamp, List<DiscardedEvent> discardedEvents) {
        void var2_2;
        void var1_1;
        this.timestamp = var1_1;
        this.discardedEvents = var2_2;
    }

    public final List<DiscardedEvent> getDiscardedEvents() {
        return this.discardedEvents;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("timestamp").value(DateUtils.getTimestamp(this.timestamp));
        writer.name("discarded_events").value(logger, this.discardedEvents);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<ClientReport> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final ClientReport deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            Date timestamp = null;
            ArrayList<DiscardedEvent> discardedEvents = new ArrayList<DiscardedEvent>();
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block8: while (reader.peek() == JsonToken.NAME) {
                List<DiscardedEvent> deserializedDiscardedEvents;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "timestamp": {
                        timestamp = reader.nextDateOrNull(logger);
                        continue block8;
                    }
                    case "discarded_events": {
                        deserializedDiscardedEvents = reader.nextListOrNull(logger, new DiscardedEvent.Deserializer());
                        discardedEvents.addAll(deserializedDiscardedEvents);
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)((Object)deserializedDiscardedEvents));
            }
            var1_1.endObject();
            if (timestamp == null) {
                throw this.missingRequiredFieldException("timestamp", logger);
            }
            if (discardedEvents.isEmpty()) {
                void var2_2;
                throw this.missingRequiredFieldException("discarded_events", (ILogger)var2_2);
            }
            ClientReport clientReport = new ClientReport((Date)var3_3, discardedEvents);
            clientReport.setUnknown(unknown);
            return clientReport;
        }

        /*
         * WARNING - void declaration
         */
        private Exception missingRequiredFieldException(String field, ILogger logger) {
            void var3_3;
            void var1_1;
            void var2_2;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var2_2.log(SentryLevel.ERROR, (String)var1_1, exception);
            return var3_3;
        }
    }
}

