/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.Breadcrumb;
import io.sentry.IScope;
import io.sentry.ScopeObserverAdapter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanContext;
import io.sentry.cache.CacheUtils;
import io.sentry.cache.tape.ObjectQueue;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.User;
import io.sentry.util.LazyEvaluator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;

public final class PersistingScopeObserver
extends ScopeObserverAdapter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private SentryOptions options;
    private final LazyEvaluator<ObjectQueue<Breadcrumb>> breadcrumbsQueue;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setUser(User user) {
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$setUser$1((User)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addBreadcrumb(Breadcrumb crumb) {
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$addBreadcrumb$2((Breadcrumb)var1_1));
    }

    @Override
    public final void setBreadcrumbs(Collection<Breadcrumb> breadcrumbs) {
        if (breadcrumbs.isEmpty()) {
            PersistingScopeObserver persistingScopeObserver = this;
            persistingScopeObserver.serializeToDisk(() -> {
                try {
                    this.breadcrumbsQueue.getValue().clear();
                    return;
                }
                catch (IOException e) {
                    void var1_1;
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to clear breadcrumbs from file queue", (Throwable)var1_1);
                    return;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLevel(SentryLevel level) {
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$setLevel$8((SentryLevel)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTransaction(String transaction) {
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$setTransaction$9((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTrace(SpanContext spanContext, IScope scope) {
        void var2_2;
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$setTrace$10((SpanContext)var1_1, (IScope)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setContexts(Contexts contexts) {
        void var1_1;
        PersistingScopeObserver persistingScopeObserver = this;
        persistingScopeObserver.serializeToDisk(() -> persistingScopeObserver.lambda$setContexts$11((Contexts)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void serializeToDisk(Runnable task) {
        if (!this.options.isEnableScopePersistence()) {
            return;
        }
        if (Thread.currentThread().getName().contains("SentryExecutor")) {
            try {
                task.run();
                return;
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Serialization task failed", e);
                return;
            }
        }
        try {
            void e;
            this.options.getExecutorService().submit(() -> this.lambda$serializeToDisk$13((Runnable)e));
            return;
        }
        catch (Throwable e) {
            void var1_3;
            this.options.getLogger().log(SentryLevel.ERROR, "Serialization task could not be scheduled", (Throwable)var1_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void store(T entity, String fileName) {
        void var2_2;
        void var1_1;
        PersistingScopeObserver.store(this.options, var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void delete(String fileName) {
        void var1_1;
        CacheUtils.delete(this.options, ".scope-cache", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void store(SentryOptions options, T entity, String fileName) {
        void var2_2;
        void var1_1;
        CacheUtils.store(options, var1_1, ".scope-cache", (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void resetCache() {
        try {
            this.breadcrumbsQueue.getValue().clear();
        }
        catch (IOException e) {
            void var1_1;
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to clear breadcrumbs from file queue", (Throwable)var1_1);
        }
        this.delete("user.json");
        this.delete("level.json");
        this.delete("request.json");
        this.delete("fingerprint.json");
        this.delete("contexts.json");
        this.delete("extras.json");
        this.delete("tags.json");
        this.delete("trace.json");
        this.delete("transaction.json");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$serializeToDisk$13(Runnable task) {
        try {
            task.run();
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Serialization task failed", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setContexts$11(Contexts contexts) {
        void var1_1;
        this.store(var1_1, "contexts.json");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setTrace$10(SpanContext spanContext, IScope scope) {
        void var1_1;
        if (spanContext == null) {
            void var2_2;
            this.store(var2_2.getPropagationContext().toSpanContext(), "trace.json");
            return;
        }
        this.store(var1_1, "trace.json");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setTransaction$9(String transaction) {
        void var1_1;
        if (transaction == null) {
            this.delete("transaction.json");
            return;
        }
        this.store(var1_1, "transaction.json");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setLevel$8(SentryLevel level) {
        void var1_1;
        if (level == null) {
            this.delete("level.json");
            return;
        }
        this.store(var1_1, "level.json");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$addBreadcrumb$2(Breadcrumb crumb) {
        try {
            this.breadcrumbsQueue.getValue().add(crumb);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to add breadcrumb to file queue", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setUser$1(User user) {
        void var1_1;
        if (user == null) {
            this.delete("user.json");
            return;
        }
        this.store(var1_1, "user.json");
    }
}

