/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryCrashLastRunState;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryUUID;
import io.sentry.Session;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.CacheStrategy;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.SessionEnd;
import io.sentry.hints.SessionStart;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EnvelopeCache
extends CacheStrategy
implements IEnvelopeCache {
    private final CountDownLatch previousSessionLatch;
    private final Map<SentryEnvelope, String> fileNameMap = new WeakHashMap<SentryEnvelope, String>();
    protected final AutoClosableReentrantLock cacheLock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public static IEnvelopeCache create(SentryOptions options) {
        void var2_2;
        void var1_1;
        SentryOptions sentryOptions;
        String cacheDirPath = options.getCacheDirPath();
        int maxCacheItems = options.getMaxCacheItems();
        if (cacheDirPath == null) {
            options.getLogger().log(SentryLevel.WARNING, "cacheDirPath is null, returning NoOpEnvelopeCache", new Object[0]);
            return NoOpEnvelopeCache.getInstance();
        }
        return new EnvelopeCache(sentryOptions, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public EnvelopeCache(SentryOptions options, String cacheDirPath, int maxCacheItems) {
        super((SentryOptions)var1_1, (String)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.previousSessionLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void store(SentryEnvelope envelope, Hint hint) {
        void var2_2;
        void var1_1;
        File envelopeFile;
        Objects.requireNonNull(envelope, "Envelope is required.");
        EnvelopeCache envelopeCache = this;
        envelopeCache.rotateCacheIfNeeded(envelopeCache.allEnvelopeFiles());
        File currentSessionFile = EnvelopeCache.getCurrentSessionFile(this.directory.getAbsolutePath());
        File previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
        if (HintUtils.hasType(hint, SessionEnd.class) && !currentSessionFile.delete()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Current envelope doesn't exist.", new Object[0]);
        }
        if (HintUtils.hasType(hint, AbnormalExit.class)) {
            this.tryEndPreviousSession(hint);
        }
        if (HintUtils.hasType(hint, SessionStart.class)) {
            File javaCrashMarkerFile;
            void var3_3;
            if (currentSessionFile.exists()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Current session is not ended, we'd need to end it.", new Object[0]);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentSessionFile), UTF_8));){
                    Session session = this.serializer.getValue().deserialize(reader, Session.class);
                    if (session != null) {
                        this.writeSessionToDisk(previousSessionFile, session);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error processing session.", e);
                }
            }
            this.updateCurrentSession((File)var3_3, envelope);
            boolean crashedLastRun = false;
            File file = new File(this.options.getCacheDirPath(), ".sentry-native/last_crash");
            if (file.exists()) {
                crashedLastRun = true;
            }
            if (!crashedLastRun && (javaCrashMarkerFile = new File(this.options.getCacheDirPath(), "last_crash")).exists()) {
                this.options.getLogger().log(SentryLevel.INFO, "Crash marker file exists, crashedLastRun will return true.", new Object[0]);
                crashedLastRun = true;
                if (!javaCrashMarkerFile.delete()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete the crash marker file. %s.", javaCrashMarkerFile.getAbsolutePath());
                }
            }
            SentryCrashLastRunState.getInstance().setCrashedLastRun(crashedLastRun);
            this.flushPreviousSession();
        }
        if ((envelopeFile = this.getEnvelopeFile(envelope)).exists()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Not adding Envelope to offline storage because it already exists: %s", envelopeFile.getAbsolutePath());
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Adding Envelope to offline storage: %s", envelopeFile.getAbsolutePath());
        this.writeEnvelopeToDisk(envelopeFile, (SentryEnvelope)var1_1);
        if (HintUtils.hasType((Hint)var2_2, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
            this.writeCrashMarkerFile();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryEndPreviousSession(Hint hint) {
        Object sdkHint = HintUtils.getSentrySdkHint(hint);
        if (!(sdkHint instanceof AbnormalExit)) return;
        File previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
        if (previousSessionFile.exists()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Previous session is not ended, we'd need to end it.", new Object[0]);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(previousSessionFile), UTF_8));){
                void var2_3;
                void var1_1;
                Session session = this.serializer.getValue().deserialize(reader, Session.class);
                if (session == null) return;
                AbnormalExit abnormalHint = (AbnormalExit)sdkHint;
                Long abnormalExitTimestamp = abnormalHint.timestamp();
                Date timestamp = null;
                if (abnormalExitTimestamp != null) {
                    timestamp = DateUtils.getDateTime(abnormalExitTimestamp);
                    Date sessionStart = session.getStarted();
                    if (sessionStart == null || timestamp.before(sessionStart)) {
                        this.options.getLogger().log(SentryLevel.WARNING, "Abnormal exit happened before previous session start, not ending the session.", new Object[0]);
                        return;
                    }
                }
                String abnormalMechanism = var1_1.mechanism();
                session.update(Session.State.Abnormal, null, true, abnormalMechanism);
                session.end(timestamp);
                this.writeSessionToDisk((File)var2_3, session);
                return;
            }
            catch (Throwable e) {
                void var3_5;
                this.options.getLogger().log(SentryLevel.ERROR, "Error processing previous session.", (Throwable)var3_5);
                return;
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "No previous session file to end.", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeCrashMarkerFile() {
        File crashMarkerFile = new File(this.options.getCacheDirPath(), "last_crash");
        try (FileOutputStream outputStream = new FileOutputStream(crashMarkerFile);){
            void var2_4;
            String timestamp = DateUtils.getTimestamp(DateUtils.getCurrentDateTime());
            ((OutputStream)outputStream).write(var2_4.getBytes(UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            void var1_3;
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the crash marker file to the disk", (Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentSession(File currentSessionFile, SentryEnvelope envelope) {
        block12: {
            void var1_1;
            Iterable<SentryEnvelopeItem> items = envelope.getItems();
            if (items.iterator().hasNext()) {
                block11: {
                    void var2_3;
                    SentryEnvelopeItem item = items.iterator().next();
                    if (SentryItemType.Session.equals(item.getHeader().getType())) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));){
                            Session session = this.serializer.getValue().deserialize(reader, Session.class);
                            if (session == null) {
                                this.options.getLogger().log(SentryLevel.ERROR, "Item of type %s returned null by the parser.", item.getHeader().getType());
                            } else {
                                this.writeSessionToDisk(currentSessionFile, session);
                            }
                            break block11;
                        }
                        catch (Throwable e) {
                            void var3_5;
                            this.options.getLogger().log(SentryLevel.ERROR, "Item failed to process.", (Throwable)var3_5);
                            break block12;
                        }
                    }
                    this.options.getLogger().log(SentryLevel.INFO, "Current envelope has a different envelope type %s", var2_3.getHeader().getType());
                }
                return;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Current envelope %s is empty", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeEnvelopeToDisk(File file, SentryEnvelope envelope) {
        if (file.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting envelope to offline storage: %s", file.getAbsolutePath());
            if (!file.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            void var2_2;
            this.serializer.getValue().serialize((SentryEnvelope)var2_2, outputStream);
        }
        catch (Throwable e) {
            void var1_1;
            void var3_6;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_6, "Error writing Envelope %s to offline storage", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSessionToDisk(File file, Session session) {
        if (file.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting session to offline storage: %s", session.getSessionId());
            if (!file.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));
            try {
                this.serializer.getValue().serialize(session, writer);
            }
            catch (Throwable throwable) {
                try {
                    void var3_4;
                    var3_4.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((Writer)writer).close();
        }
        catch (Throwable e) {
            void var2_3;
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var1_2, "Error writing Session to offline storage: %s", var2_3.getSessionId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void discard(SentryEnvelope envelope) {
        Objects.requireNonNull(envelope, "Envelope is required.");
        File envelopeFile = this.getEnvelopeFile(envelope);
        if (envelopeFile.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Discarding envelope from cache: %s", envelopeFile.getAbsolutePath());
            if (!envelopeFile.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete envelope: %s", envelopeFile.getAbsolutePath());
                return;
            }
        } else {
            void var1_1;
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope was not cached: %s", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private File getEnvelopeFile(SentryEnvelope envelope) {
        ISentryLifecycleToken ignored = this.cacheLock.acquire();
        try {
            void var3_4;
            File file;
            String fileName;
            if (this.fileNameMap.containsKey(envelope)) {
                fileName = this.fileNameMap.get(envelope);
            } else {
                fileName = SentryUUID.generateSentryId() + ".envelope";
                this.fileNameMap.put((SentryEnvelope)((Object)file), fileName);
            }
            file = new File(this.directory.getAbsolutePath(), (String)var3_4);
            if (ignored != null) {
                ignored.close();
            }
            return file;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public static File getCurrentSessionFile(String cacheDirPath) {
        String string;
        return new File(string, "session.json");
    }

    public static File getPreviousSessionFile(String cacheDirPath) {
        String string;
        return new File(string, "previous_session.json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<SentryEnvelope> iterator() {
        void var2_2;
        void var1_1;
        File[] allCachedEnvelopes = this.allEnvelopeFiles();
        ArrayList<SentryEnvelope> ret = new ArrayList<SentryEnvelope>(allCachedEnvelopes.length);
        for (void file : var1_1) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((File)file));){
                ret.add(this.serializer.getValue().deserializeEnvelope(is));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Envelope file '%s' disappeared while converting all cached files to envelopes.", file.getAbsolutePath());
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, String.format("Error while reading cached envelope from file %s", file.getAbsolutePath()), e);
            }
        }
        return var2_2.iterator();
    }

    /*
     * WARNING - void declaration
     */
    private File[] allEnvelopeFiles() {
        File[] files;
        if (this.isDirectoryValid() && (files = this.directory.listFiles((__, fileName) -> fileName.endsWith(".envelope"))) != null) {
            void var1_1;
            return var1_1;
        }
        return new File[0];
    }

    public boolean waitPreviousSessionFlush() {
        try {
            return this.previousSessionLatch.await(this.options.getSessionFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.options.getLogger().log(SentryLevel.DEBUG, "Timed out waiting for previous session to flush.", new Object[0]);
            return false;
        }
    }

    public void flushPreviousSession() {
        this.previousSessionLatch.countDown();
    }
}

