/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

final class CacheUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    /*
     * WARNING - void declaration
     */
    static <T> void store(SentryOptions options, T entity, String dirName, String fileName) {
        File cacheDir = CacheUtils.ensureCacheDir(options, dirName);
        if (cacheDir == null) {
            options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, cannot store in scope cache", new Object[0]);
            return;
        }
        File file = new File(cacheDir, fileName);
        try (FileOutputStream outputStream = new FileOutputStream(file);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));){
            void var1_1;
            options.getSerializer().serialize(var1_1, writer);
        }
        catch (Throwable e) {
            void var3_6;
            void var2_5;
            SentryOptions sentryOptions;
            sentryOptions.getLogger().log(SentryLevel.ERROR, (Throwable)var2_5, "Error persisting entity: %s", var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void delete(SentryOptions options, String dirName, String fileName) {
        void var2_2;
        File cacheDir = CacheUtils.ensureCacheDir(options, dirName);
        if (cacheDir == null) {
            options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, cannot delete from scope cache", new Object[0]);
            return;
        }
        File file = new File(cacheDir, fileName);
        options.getLogger().log(SentryLevel.DEBUG, "Deleting %s from scope cache", var2_2);
        if (!file.delete()) {
            void var1_1;
            SentryOptions sentryOptions;
            sentryOptions.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    static File ensureCacheDir(SentryOptions options, String cacheDirName) {
        String string;
        void var1_1;
        String cacheDir = options.getCacheDirPath();
        if (cacheDir == null) {
            return null;
        }
        String dir = new File(cacheDir, (String)var1_1);
        ((File)((Object)dir)).mkdirs();
        return string;
    }
}

