/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.ISerializer;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.clientreport.DiscardReason;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

abstract class CacheStrategy {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected SentryOptions options;
    protected final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> this.options.getSerializer());
    protected final File directory;
    private final int maxSize;

    /*
     * WARNING - void declaration
     */
    CacheStrategy(SentryOptions options, String directoryPath, int maxSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(directoryPath, "Directory is required.");
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "SentryOptions is required.");
        this.directory = new File((String)var2_2);
        this.maxSize = var3_3;
    }

    protected boolean isDirectoryValid() {
        if (!(this.directory.isDirectory() && this.directory.canWrite() && this.directory.canRead())) {
            this.options.getLogger().log(SentryLevel.ERROR, "The directory for caching files is inaccessible.: %s", this.directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void sortFilesOldestToNewest(File[] files) {
        if (files.length > 1) {
            void var1_1;
            Arrays.sort(var1_1, (f1, f2) -> {
                void var1_1;
                return Long.compare(f1.lastModified(), var1_1.lastModified());
            });
        }
    }

    protected void rotateCacheIfNeeded(File[] files) {
        int length = files.length;
        if (length >= this.maxSize) {
            this.options.getLogger().log(SentryLevel.WARNING, "Cache folder if full (respecting maxSize). Rotating files", new Object[0]);
            int totalToBeDeleted = length - this.maxSize + 1;
            this.sortFilesOldestToNewest(files);
            File[] notDeletedFiles = Arrays.copyOfRange(files, totalToBeDeleted, length);
            for (int i = 0; i < totalToBeDeleted; ++i) {
                File file = files[i];
                this.moveInitFlagIfNecessary(file, notDeletedFiles);
                if (file.delete()) continue;
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void moveInitFlagIfNecessary(File currentFile, File[] notDeletedFiles) {
        void var2_2;
        void var3_3;
        SentryEnvelope currentEnvelope = this.readEnvelope(currentFile);
        if (currentEnvelope == null || !this.isValidEnvelope(currentEnvelope)) {
            return;
        }
        this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.CACHE_OVERFLOW, currentEnvelope);
        Session currentSession = this.getFirstSession(currentEnvelope);
        if (currentSession == null || !this.isValidSession(currentSession)) {
            return;
        }
        Boolean currentSessionInit = currentSession.getInit();
        if (currentSessionInit == null || !var3_3.booleanValue()) {
            return;
        }
        for (void notDeletedFile : var2_2) {
            SentryEnvelope envelope = this.readEnvelope((File)notDeletedFile);
            if (envelope == null || !this.isValidEnvelope(envelope)) continue;
            SentryEnvelopeItem newSessionItem = null;
            Iterator<SentryEnvelopeItem> itemsIterator = envelope.getItems().iterator();
            while (itemsIterator.hasNext()) {
                Session session;
                SentryEnvelopeItem envelopeItem = itemsIterator.next();
                if (!this.isSessionType(envelopeItem) || (session = this.readSession(envelopeItem)) == null || !this.isValidSession(session)) continue;
                Boolean init = session.getInit();
                if (init != null && init.booleanValue()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Session %s has 2 times the init flag.", currentSession.getSessionId());
                    return;
                }
                if (currentSession.getSessionId() == null || !currentSession.getSessionId().equals(session.getSessionId())) continue;
                session.setInitAsTrue();
                try {
                    newSessionItem = SentryEnvelopeItem.fromSession(this.serializer.getValue(), session);
                    itemsIterator.remove();
                }
                catch (IOException e) {
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to create new envelope item for the session %s", currentSession.getSessionId());
                }
                break;
            }
            if (newSessionItem == null) continue;
            SentryEnvelope newEnvelope = this.buildNewEnvelope(envelope, newSessionItem);
            long notDeletedFileTimestamp = notDeletedFile.lastModified();
            if (!notDeletedFile.delete()) {
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", notDeletedFile.getAbsolutePath());
            }
            this.saveNewEnvelope(newEnvelope, (File)notDeletedFile, notDeletedFileTimestamp);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelope readEnvelope(File file) {
        SentryEnvelope sentryEnvelope;
        BufferedInputStream inputStream2 = new BufferedInputStream(new FileInputStream(file));
        try {
            sentryEnvelope = this.serializer.getValue().deserializeEnvelope(inputStream2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable inputStream2) {
                    throwable.addSuppressed(inputStream2);
                }
                throw throwable;
            }
            catch (IOException e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the envelope.", (Throwable)var1_3);
                return null;
            }
        }
        ((InputStream)inputStream2).close();
        return sentryEnvelope;
    }

    /*
     * WARNING - void declaration
     */
    private Session getFirstSession(SentryEnvelope envelope) {
        for (SentryEnvelopeItem item : envelope.getItems()) {
            void var2_2;
            if (!this.isSessionType(item)) continue;
            return this.readSession((SentryEnvelopeItem)var2_2);
        }
        return null;
    }

    private boolean isValidSession(Session session) {
        String string;
        if (!session.getStatus().equals((Object)Session.State.Ok)) {
            return false;
        }
        return (string = ((Session)((Object)string)).getSessionId()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSessionType(SentryEnvelopeItem item) {
        void var1_1;
        if (item == null) {
            return false;
        }
        return var1_1.getHeader().getType().equals(SentryItemType.Session);
    }

    /*
     * WARNING - void declaration
     */
    private Session readSession(SentryEnvelopeItem item) {
        Session session;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
        try {
            session = this.serializer.getValue().deserialize(reader2, Session.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader2).close();
                }
                catch (Throwable reader2) {
                    throwable.addSuppressed(reader2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the session.", (Throwable)var1_3);
                return null;
            }
        }
        ((Reader)reader2).close();
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private void saveNewEnvelope(SentryEnvelope envelope, File file, long timestamp) {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            void var3_5;
            void var2_3;
            void var1_1;
            this.serializer.getValue().serialize((SentryEnvelope)var1_1, outputStream);
            var2_3.setLastModified((long)var3_5);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to serialize the new envelope to the disk.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelope buildNewEnvelope(SentryEnvelope envelope, SentryEnvelopeItem sessionItem) {
        void var3_3;
        void var1_1;
        void var2_2;
        ArrayList<Object> newEnvelopeItems = new ArrayList<Object>();
        for (SentryEnvelopeItem newEnvelopeItem : envelope.getItems()) {
            newEnvelopeItems.add(newEnvelopeItem);
        }
        newEnvelopeItems.add(var2_2);
        return new SentryEnvelope(var1_1.getHeader(), (Iterable<SentryEnvelopeItem>)var3_3);
    }

    private boolean isValidEnvelope(SentryEnvelope envelope) {
        return envelope.getItems().iterator().hasNext();
    }
}

