/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.backpressure;

import io.sentry.IScopes;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.backpressure.IBackpressureMonitor;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.concurrent.Future;

public final class BackpressureMonitor
implements IBackpressureMonitor,
Runnable {
    private final SentryOptions sentryOptions;
    private final IScopes scopes;
    private int downsampleFactor = 0;
    private volatile Future<?> latestScheduledRun = null;
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public BackpressureMonitor(SentryOptions sentryOptions, IScopes scopes) {
        void var2_2;
        void var1_1;
        this.sentryOptions = var1_1;
        this.scopes = var2_2;
    }

    @Override
    public final void start() {
        this.reschedule(500);
    }

    @Override
    public final void run() {
        this.checkHealth();
        this.reschedule(10000);
    }

    @Override
    public final int getDownsampleFactor() {
        return this.downsampleFactor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        Future<?> currentRun = this.latestScheduledRun;
        if (currentRun != null) {
            ISentryLifecycleToken ignored = this.lock.acquire();
            try {
                void var1_1;
                var1_1.cancel(true);
                if (ignored != null) {
                    ignored.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    final void checkHealth() {
        if (this.isHealthy()) {
            if (this.downsampleFactor > 0) {
                this.sentryOptions.getLogger().log(SentryLevel.DEBUG, "Health check positive, reverting to normal sampling.", new Object[0]);
            }
            this.downsampleFactor = 0;
            return;
        }
        if (this.downsampleFactor < 10) {
            ++this.downsampleFactor;
            this.sentryOptions.getLogger().log(SentryLevel.DEBUG, "Health check negative, downsampling with a factor of %d", this.downsampleFactor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reschedule(int delay) {
        ISentryExecutorService executorService = this.sentryOptions.getExecutorService();
        if (!executorService.isClosed()) {
            ISentryLifecycleToken ignored = this.lock.acquire();
            try {
                void var1_1;
                void var2_3;
                this.latestScheduledRun = var2_3.schedule(this, (long)var1_1);
                if (ignored != null) {
                    ignored.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var3_5;
                        var3_5.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private boolean isHealthy() {
        return this.scopes.isHealthy();
    }
}

