/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandler;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.hints.EventDropReason;
import io.sentry.hints.SessionEnd;
import io.sentry.hints.TransactionEnd;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.SentryId;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;

public final class UncaughtExceptionHandlerIntegration
implements Integration,
Closeable,
Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private IScopes scopes;
    private SentryOptions options;
    private boolean registered = false;
    private final UncaughtExceptionHandler threadAdapter;

    public UncaughtExceptionHandlerIntegration() {
        this(UncaughtExceptionHandler.Adapter.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    UncaughtExceptionHandlerIntegration(UncaughtExceptionHandler threadAdapter) {
        void var1_1;
        this.threadAdapter = (UncaughtExceptionHandler)Objects.requireNonNull(var1_1, "threadAdapter is required.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register(IScopes scopes, SentryOptions options) {
        void var2_2;
        if (this.registered) {
            options.getLogger().log(SentryLevel.ERROR, "Attempt to register a UncaughtExceptionHandlerIntegration twice.", new Object[0]);
            return;
        }
        this.registered = true;
        this.scopes = Objects.requireNonNull(scopes, "Scopes are required");
        this.options = (SentryOptions)Objects.requireNonNull(var2_2, "SentryOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration enabled: %s", this.options.isEnableUncaughtExceptionHandler());
        if (this.options.isEnableUncaughtExceptionHandler()) {
            Thread.UncaughtExceptionHandler currentHandler = this.threadAdapter.getDefaultUncaughtExceptionHandler();
            if (currentHandler != null) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.DEBUG, "default UncaughtExceptionHandler class='" + currentHandler.getClass().getName() + "'", new Object[0]);
                if (currentHandler instanceof UncaughtExceptionHandlerIntegration) {
                    UncaughtExceptionHandlerIntegration currentHandlerIntegration = (UncaughtExceptionHandlerIntegration)currentHandler;
                    this.defaultExceptionHandler = var1_1.defaultExceptionHandler;
                } else {
                    this.defaultExceptionHandler = var1_1;
                }
            }
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this);
            this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion("UncaughtExceptionHandler");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void uncaughtException(Thread thread, Throwable thrown) {
        if (this.options != null && this.scopes != null) {
            this.options.getLogger().log(SentryLevel.INFO, "Uncaught exception received.", new Object[0]);
            try {
                UncaughtExceptionHint exceptionHint = new UncaughtExceptionHint(this.options.getFlushTimeoutMillis(), this.options.getLogger());
                Throwable throwable = UncaughtExceptionHandlerIntegration.getUnhandledThrowable(thread, thrown);
                SentryEvent event = new SentryEvent(throwable);
                event.setLevel(SentryLevel.FATAL);
                ITransaction iTransaction = this.scopes.getTransaction();
                if (iTransaction == null && event.getEventId() != null) {
                    exceptionHint.setFlushable(event.getEventId());
                }
                Hint hint = HintUtils.createWithTypeCheckHint(exceptionHint);
                SentryId sentryId = this.scopes.captureEvent(event, hint);
                boolean isEventDropped = sentryId.equals(SentryId.EMPTY_ID);
                EventDropReason eventDropReason = HintUtils.getEventDropReason(hint);
                if (!(isEventDropped && !EventDropReason.MULTITHREADED_DEDUPLICATION.equals((Object)eventDropReason) || exceptionHint.waitFlush())) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush event to disk before crashing. Event: %s", event.getEventId());
                }
            }
            catch (Throwable e) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, "Error sending uncaught exception to Sentry.", (Throwable)var3_4);
            }
            if (this.defaultExceptionHandler != null) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.INFO, "Invoking inner uncaught exception handler.", new Object[0]);
                this.defaultExceptionHandler.uncaughtException((Thread)var1_1, thrown);
                return;
            }
            if (this.options.isPrintUncaughtStackTrace()) {
                void var2_2;
                var2_2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static Throwable getUnhandledThrowable(Thread thread, Throwable thrown) {
        Thread thread2;
        void var1_1;
        void var2_2;
        Mechanism mechanism = new Mechanism();
        mechanism.setHandled(Boolean.FALSE);
        mechanism.setType("UncaughtExceptionHandler");
        return new ExceptionMechanismException((Mechanism)var2_2, (Throwable)var1_1, thread2);
    }

    @Override
    public final void close() {
        UncaughtExceptionHandlerIntegration uncaughtExceptionHandlerIntegration = this;
        if (uncaughtExceptionHandlerIntegration == uncaughtExceptionHandlerIntegration.threadAdapter.getDefaultUncaughtExceptionHandler()) {
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration removed.", new Object[0]);
            }
        }
    }

    public static class UncaughtExceptionHint
    extends BlockingFlushHint
    implements SessionEnd,
    TransactionEnd {
        private final AtomicReference<SentryId> flushableEventId = new AtomicReference();

        /*
         * WARNING - void declaration
         */
        public UncaughtExceptionHint(long flushTimeoutMillis, ILogger logger) {
            super((long)var1_1, (ILogger)var3_2);
            void var3_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isFlushable(SentryId eventId) {
            void var1_1;
            void var2_2;
            SentryId unwrapped = this.flushableEventId.get();
            return unwrapped != null && var2_2.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setFlushable(SentryId eventId) {
            void var1_1;
            this.flushableEventId.set((SentryId)var1_1);
        }
    }
}

