/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SamplingContext;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.util.Objects;
import io.sentry.util.SampleRateUtils;

public final class TracesSampler {
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public TracesSampler(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "options are required");
    }

    /*
     * WARNING - void declaration
     */
    public final TracesSamplingDecision sample(SamplingContext samplingContext) {
        void var2_2;
        TracesSamplingDecision parentSamplingDecision;
        Double sampleRand = samplingContext.getSampleRand();
        TracesSamplingDecision samplingContextSamplingDecision = samplingContext.getTransactionContext().getSamplingDecision();
        if (samplingContextSamplingDecision != null) {
            return SampleRateUtils.backfilledSampleRand(samplingContextSamplingDecision);
        }
        Double profilesSampleRate = null;
        if (this.options.getProfilesSampler() != null) {
            try {
                profilesSampleRate = this.options.getProfilesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ProfilesSamplerCallback' callback.", t);
            }
        }
        if (profilesSampleRate == null) {
            profilesSampleRate = this.options.getProfilesSampleRate();
        }
        Boolean profilesSampled = profilesSampleRate != null && this.sample(profilesSampleRate, sampleRand);
        if (this.options.getTracesSampler() != null) {
            Double samplerResult = null;
            try {
                samplerResult = this.options.getTracesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'TracesSamplerCallback' callback.", t);
            }
            if (samplerResult != null) {
                return new TracesSamplingDecision(this.sample(samplerResult, sampleRand), samplerResult, sampleRand, profilesSampled, profilesSampleRate);
            }
        }
        if ((parentSamplingDecision = samplingContext.getTransactionContext().getParentSamplingDecision()) != null) {
            return SampleRateUtils.backfilledSampleRand(parentSamplingDecision);
        }
        Double tracesSampleRateFromOptions = this.options.getTracesSampleRate();
        Double downsampleFactor = Math.pow(2.0, this.options.getBackpressureMonitor().getDownsampleFactor());
        Double downsampledTracesSampleRate = tracesSampleRateFromOptions == null ? null : Double.valueOf(tracesSampleRateFromOptions / downsampleFactor);
        if (downsampledTracesSampleRate != null) {
            void var3_3;
            void var1_1;
            return new TracesSamplingDecision(this.sample(downsampledTracesSampleRate, sampleRand), (Double)var1_1, sampleRand, profilesSampled, (Double)var3_3);
        }
        return new TracesSamplingDecision(Boolean.FALSE, null, (Double)var2_2, Boolean.FALSE, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean sampleSessionProfile(double sampleRand) {
        void var1_1;
        void var3_2;
        Double sampling = this.options.getProfileSessionSampleRate();
        return sampling != null && this.sample((Double)var3_2, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean sample(Double sampleRate, Double sampleRand) {
        void var2_2;
        return !(sampleRate < var2_2.doubleValue());
    }
}

