/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TraceContext
implements JsonSerializable {
    private final SentryId traceId;
    private final String publicKey;
    private final String release;
    private final String environment;
    private final String userId;
    private final String transaction;
    private final String sampleRate;
    private final String sampleRand;
    private final String sampled;
    private final SentryId replayId;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    TraceContext(SentryId traceId, String publicKey) {
        this((SentryId)var1_1, (String)var2_2, null, null, null, null, null, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    TraceContext(SentryId traceId, String publicKey, String release, String environment, String userId, String transaction, String sampleRate, String sampled, SentryId replayId) {
        this((SentryId)var1_1, (String)var2_2, (String)var3_3, environment, userId, transaction, sampleRate, sampled, replayId, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    TraceContext(SentryId traceId, String publicKey, String release, String environment, String userId, String transaction, String sampleRate, String sampled, SentryId replayId, String sampleRand) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.traceId = var1_1;
        this.publicKey = var2_2;
        this.release = var3_3;
        this.environment = environment;
        this.userId = userId;
        this.transaction = transaction;
        this.sampleRate = sampleRate;
        this.sampled = sampled;
        this.replayId = replayId;
        this.sampleRand = sampleRand;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("trace_id").value(logger, this.traceId);
        writer.name("public_key").value(this.publicKey);
        if (this.release != null) {
            writer.name("release").value(this.release);
        }
        if (this.environment != null) {
            writer.name("environment").value(this.environment);
        }
        if (this.userId != null) {
            writer.name("user_id").value(this.userId);
        }
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        if (this.sampleRate != null) {
            writer.name("sample_rate").value(this.sampleRate);
        }
        if (this.sampleRand != null) {
            writer.name("sample_rand").value(this.sampleRand);
        }
        if (this.sampled != null) {
            writer.name("sampled").value(this.sampled);
        }
        if (this.replayId != null) {
            writer.name("replay_id").value(logger, this.replayId);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<TraceContext> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final TraceContext deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            SentryId traceId = null;
            String publicKey = null;
            String release = null;
            String environment = null;
            String userId = null;
            String transaction = null;
            String sampleRate = null;
            String sampleRand = null;
            String sampled = null;
            SentryId replayId = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block24: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader, logger);
                        continue block24;
                    }
                    case "public_key": {
                        publicKey = reader.nextString();
                        continue block24;
                    }
                    case "release": {
                        release = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "environment": {
                        environment = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "user_id": {
                        userId = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "transaction": {
                        transaction = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "sample_rate": {
                        sampleRate = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "sample_rand": {
                        sampleRand = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "sampled": {
                        sampled = reader.nextStringOrNull();
                        continue block24;
                    }
                    case "replay_id": {
                        replayId = new SentryId.Deserializer().deserialize(reader, logger);
                        continue block24;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                throw this.missingRequiredFieldException("trace_id", logger);
            }
            if (publicKey == null) {
                void var2_2;
                throw this.missingRequiredFieldException("public_key", (ILogger)var2_2);
            }
            TraceContext traceContext = new TraceContext((SentryId)var3_3, publicKey, release, environment, userId, transaction, sampleRate, sampled, replayId, sampleRand);
            traceContext.setUnknown(unknown);
            var1_1.endObject();
            return traceContext;
        }

        /*
         * WARNING - void declaration
         */
        private Exception missingRequiredFieldException(String field, ILogger logger) {
            void var3_3;
            void var1_1;
            void var2_2;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var2_2.log(SentryLevel.ERROR, (String)var1_1, exception);
            return var3_3;
        }
    }
}

