/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISentryExecutorService;
import io.sentry.Integration;
import io.sentry.NoOpLogger;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.SentryEnvelope;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Platform;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPOutputStream;

public final class SpotlightIntegration
implements Integration,
SentryOptions.BeforeEnvelopeCallback,
Closeable {
    private SentryOptions options;
    private ILogger logger = NoOpLogger.getInstance();
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register(IScopes scopes, SentryOptions options) {
        this.options = options;
        this.logger = options.getLogger();
        if (options.getBeforeEnvelopeCallback() == null && options.isEnableSpotlight()) {
            void var2_2;
            this.executorService = new SentryExecutorService();
            var2_2.setBeforeEnvelopeCallback(this);
            this.logger.log(SentryLevel.DEBUG, "SpotlightIntegration enabled.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion("Spotlight");
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "SpotlightIntegration is not enabled. BeforeEnvelopeCallback is already set or spotlight is not enabled.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(SentryEnvelope envelope, Hint hint) {
        try {
            this.executorService.submit(() -> {
                void var1_1;
                this.sendEnvelope((SentryEnvelope)var1_1);
            });
            return;
        }
        catch (RejectedExecutionException e) {
            void var1_2;
            this.logger.log(SentryLevel.WARNING, "Spotlight envelope submission rejected.", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendEnvelope(SentryEnvelope envelope) {
        block19: {
            try {
                if (this.options == null) {
                    throw new IllegalArgumentException("SentryOptions are required to send envelopes.");
                }
                String spotlightConnectionUrl = this.getSpotlightConnectionUrl();
                HttpURLConnection connection = this.createConnection(spotlightConnectionUrl);
                try (OutputStream outputStream = connection.getOutputStream();
                     GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                    void var1_1;
                    this.options.getSerializer().serialize((SentryEnvelope)var1_1, gzip);
                }
                catch (Throwable e) {
                    try {
                        this.logger.log(SentryLevel.ERROR, "An exception occurred while submitting the envelope to the Sentry server.", e);
                    }
                    catch (Throwable throwable) {
                        void var3_11;
                        int responseCode = connection.getResponseCode();
                        this.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", (int)var3_11);
                        this.closeAndDisconnect(connection);
                        throw throwable;
                    }
                    int responseCode = connection.getResponseCode();
                    this.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", responseCode);
                    this.closeAndDisconnect(connection);
                    break block19;
                }
                int responseCode = connection.getResponseCode();
                this.logger.log(SentryLevel.DEBUG, "Envelope sent to spotlight: %d", responseCode);
                this.closeAndDisconnect(connection);
            }
            catch (Exception e) {
                void var2_6;
                this.logger.log(SentryLevel.ERROR, "An exception occurred while creating the connection to spotlight.", (Throwable)var2_6);
            }
        }
    }

    public final String getSpotlightConnectionUrl() {
        if (this.options != null && this.options.getSpotlightConnectionUrl() != null) {
            return this.options.getSpotlightConnectionUrl();
        }
        if (Platform.isAndroid()) {
            return "http://10.0.2.2:8969/stream";
        }
        return "http://localhost:8969/stream";
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection createConnection(String url) throws Exception {
        void var1_1;
        HttpURLConnection connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
        connection.setReadTimeout(1000);
        connection.setConnectTimeout(1000);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "gzip");
        connection.setRequestProperty("Content-Type", "application/x-sentry-envelope");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Connection", "close");
        connection.connect();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void closeAndDisconnect(HttpURLConnection connection) {
        try {
            connection.getInputStream().close();
            connection.disconnect();
            return;
        }
        catch (IOException iOException) {
            connection.disconnect();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.disconnect();
            throw throwable;
        }
    }

    @Override
    public final void close() throws IOException {
        this.executorService.close(0L);
        if (this.options != null && this.options.getBeforeEnvelopeCallback() == this) {
            this.options.setBeforeEnvelopeCallback(null);
        }
    }
}

