/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Baggage;
import io.sentry.ILogger;
import io.sentry.Instrumenter;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.ScopesAdapter;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.util.thread.IThreadChecker;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpanContext
implements JsonSerializable {
    private final SentryId traceId;
    private final SpanId spanId;
    private SpanId parentSpanId;
    private transient TracesSamplingDecision samplingDecision;
    protected String op;
    protected String description;
    protected SpanStatus status;
    protected Map<String, String> tags = new ConcurrentHashMap<String, String>();
    protected String origin = "manual";
    protected Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> unknown;
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    protected Baggage baggage;

    /*
     * WARNING - void declaration
     */
    public SpanContext(String operation) {
        this(new SentryId(), new SpanId(), (String)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, String operation, SpanId parentSpanId, TracesSamplingDecision samplingDecision) {
        this((SentryId)var1_1, (SpanId)var2_2, parentSpanId, (String)var3_3, null, samplingDecision, null, "manual");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, SpanId parentSpanId, String operation, String description, TracesSamplingDecision samplingDecision, SpanStatus status, String origin) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.traceId = Objects.requireNonNull(traceId, "traceId is required");
        this.spanId = (SpanId)Objects.requireNonNull(var2_2, "spanId is required");
        this.op = Objects.requireNonNull(operation, "operation is required");
        this.parentSpanId = var3_3;
        this.description = description;
        this.status = status;
        this.origin = origin;
        this.setSamplingDecision(samplingDecision);
        IThreadChecker threadChecker = ScopesAdapter.getInstance().getOptions().getThreadChecker();
        this.data.put("thread.id", String.valueOf(threadChecker.currentThreadSystemId()));
        this.data.put("thread.name", var1_1.getCurrentThreadName());
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SpanContext spanContext) {
        Map<String, Object> copiedUnknown;
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.setSamplingDecision(spanContext.samplingDecision);
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            this.tags = copiedTags;
        }
        if ((copiedUnknown = CollectionUtils.newConcurrentHashMap(spanContext.unknown)) != null) {
            void var2_2;
            this.unknown = var2_2;
        }
        this.baggage = spanContext.baggage;
        Map<String, Object> copiedData = CollectionUtils.newConcurrentHashMap(spanContext.data);
        if (copiedData != null) {
            void var1_1;
            this.data = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDescription(String description) {
        void var1_1;
        this.description = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStatus(SpanStatus status) {
        void var1_1;
        this.status = var1_1;
    }

    public SentryId getTraceId() {
        return this.traceId;
    }

    public SpanStatus getStatus() {
        return this.status;
    }

    public TracesSamplingDecision getSamplingDecision() {
        return this.samplingDecision;
    }

    /*
     * WARNING - void declaration
     */
    public void setSamplingDecision(TracesSamplingDecision samplingDecision) {
        void var1_1;
        this.samplingDecision = var1_1;
        if (this.baggage != null) {
            this.baggage.setValuesFromSamplingDecision(this.samplingDecision);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOrigin(String origin) {
        void var1_1;
        this.origin = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)o;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && Objects.equals(this.parentSpanId, that.parentSpanId) && this.op.equals(that.op) && Objects.equals(this.description, that.description) && this.getStatus() == var1_1.getStatus();
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.spanId, this.parentSpanId, this.op, this.description, this.getStatus());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("trace_id");
        this.traceId.serialize(writer, logger);
        writer.name("span_id");
        this.spanId.serialize(writer, logger);
        if (this.parentSpanId != null) {
            writer.name("parent_span_id");
            this.parentSpanId.serialize(writer, logger);
        }
        writer.name("op").value(this.op);
        if (this.description != null) {
            writer.name("description").value(this.description);
        }
        if (this.getStatus() != null) {
            writer.name("status").value(logger, this.getStatus());
        }
        if (this.origin != null) {
            writer.name("origin").value(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer.name("tags").value(logger, this.tags);
        }
        if (!this.data.isEmpty()) {
            writer.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanContext> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SpanContext deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            IllegalStateException exception;
            String message;
            reader.beginObject();
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            String origin = null;
            Map tags = null;
            Map data = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block22: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader, logger);
                        continue block22;
                    }
                    case "span_id": {
                        spanId = new SpanId.Deserializer().deserialize(reader, logger);
                        continue block22;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block22;
                    }
                    case "op": {
                        op = reader.nextString();
                        continue block22;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block22;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block22;
                    }
                    case "origin": {
                        origin = reader.nextString();
                        continue block22;
                    }
                    case "tags": {
                        tags = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block22;
                    }
                    case "data": {
                        data = (Map)reader.nextObjectOrNull();
                        continue block22;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                message = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (spanId == null) {
                void var2_2;
                message = "Missing required field \"span_id\"";
                exception = new IllegalStateException(message);
                var2_2.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (op == null) {
                op = "";
            }
            SpanContext spanContext = new SpanContext((SentryId)var3_3, spanId, op, parentSpanId, null);
            spanContext.setDescription(description);
            spanContext.setStatus(status);
            spanContext.setOrigin(origin);
            if (tags != null) {
                spanContext.tags = tags;
            }
            if (data != null) {
                spanContext.data = data;
            }
            spanContext.setUnknown(unknown);
            var1_1.endObject();
            return spanContext;
        }
    }
}

