/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    private final Runtime runtime;
    private Thread thread;

    /*
     * WARNING - void declaration
     */
    public ShutdownHookIntegration(Runtime runtime) {
        void var1_1;
        this.runtime = (Runtime)Objects.requireNonNull(var1_1, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register(IScopes scopes, SentryOptions options) {
        void var2_2;
        Objects.requireNonNull(scopes, "Scopes are required");
        Objects.requireNonNull(options, "SentryOptions is required");
        if (options.isEnableShutdownHook()) {
            void var1_1;
            this.thread = new Thread(() -> ShutdownHookIntegration.lambda$register$0((IScopes)var1_1, options));
            ShutdownHookIntegration shutdownHookIntegration = this;
            shutdownHookIntegration.handleShutdownInProgress(() -> {
                void var1_1;
                this.runtime.addShutdownHook(this.thread);
                var1_1.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
                IntegrationUtils.addIntegrationToSdkVersion("ShutdownHook");
            });
            return;
        }
        var2_2.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
    }

    @Override
    public final void close() throws IOException {
        if (this.thread != null) {
            ShutdownHookIntegration shutdownHookIntegration = this;
            shutdownHookIntegration.handleShutdownInProgress(() -> this.runtime.removeShutdownHook(this.thread));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleShutdownInProgress(Runnable runnable) {
        try {
            runnable.run();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            void var2_2;
            IllegalStateException e = illegalStateException;
            String message = illegalStateException.getMessage();
            if (message == null || !message.equals("Shutdown in progress") && !var2_2.equals("VM already shutting down")) {
                void var1_1;
                throw var1_1;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$register$0(IScopes scopes, SentryOptions options) {
        void var1_1;
        scopes.flush(var1_1.getFlushTimeoutMillis());
    }
}

