/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.StringUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class Session
implements JsonSerializable {
    private final Date started;
    private Date timestamp;
    private final AtomicInteger errorCount;
    private final String distinctId;
    private final String sessionId;
    private Boolean init;
    private State status;
    private Long sequence;
    private Double duration;
    private final String ipAddress;
    private String userAgent;
    private final String environment;
    private final String release;
    private String abnormalMechanism;
    private final AutoClosableReentrantLock sessionLock = new AutoClosableReentrantLock();
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public Session(State status, Date started, Date timestamp, int errorCount, String distinctId, String sessionId, Boolean init, Long sequence, Double duration, String ipAddress, String userAgent, String environment, String release, String abnormalMechanism) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.status = var1_1;
        this.started = var2_2;
        this.timestamp = var3_3;
        this.errorCount = new AtomicInteger(errorCount);
        this.distinctId = distinctId;
        this.sessionId = sessionId;
        this.init = init;
        this.sequence = sequence;
        this.duration = duration;
        this.ipAddress = ipAddress;
        this.userAgent = userAgent;
        this.environment = environment;
        this.release = release;
        this.abnormalMechanism = abnormalMechanism;
    }

    public final boolean isTerminated() {
        return this.status != State.Ok;
    }

    public final Date getStarted() {
        if (this.started == null) {
            return null;
        }
        return (Date)this.started.clone();
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final Boolean getInit() {
        return this.init;
    }

    public final void setInitAsTrue() {
        this.init = Boolean.TRUE;
    }

    public final int errorCount() {
        return this.errorCount.get();
    }

    public final State getStatus() {
        return this.status;
    }

    public final String getAbnormalMechanism() {
        return this.abnormalMechanism;
    }

    public final void end() {
        this.end(DateUtils.getCurrentDateTime());
    }

    /*
     * WARNING - void declaration
     */
    public final void end(Date timestamp) {
        ISentryLifecycleToken ignored = this.sessionLock.acquire();
        try {
            void var1_1;
            this.init = null;
            if (this.status == State.Ok) {
                this.status = State.Exited;
            }
            this.timestamp = timestamp != null ? var1_1 : DateUtils.getCurrentDateTime();
            if (this.timestamp != null) {
                this.duration = this.calculateDurationTime(this.timestamp);
                this.sequence = this.getSequenceTimestamp(this.timestamp);
            }
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private double calculateDurationTime(Date timestamp) {
        long l = Math.abs(timestamp.getTime() - this.started.getTime());
        return (double)l / 1000.0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean update(State status, String userAgent, boolean addErrorsCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.update((State)var1_1, (String)var2_2, (boolean)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean update(State status, String userAgent, boolean addErrorsCount, String abnormalMechanism) {
        try (ISentryLifecycleToken ignored = this.sessionLock.acquire();){
            void var3_5;
            boolean sessionHasBeenUpdated = false;
            if (status != null) {
                void var1_1;
                this.status = var1_1;
                sessionHasBeenUpdated = true;
            }
            if (userAgent != null) {
                void var2_4;
                this.userAgent = var2_4;
                sessionHasBeenUpdated = true;
            }
            if (var3_5 != false) {
                this.errorCount.addAndGet(1);
                sessionHasBeenUpdated = true;
            }
            if (abnormalMechanism != null) {
                this.abnormalMechanism = abnormalMechanism;
                sessionHasBeenUpdated = true;
            }
            if (sessionHasBeenUpdated) {
                this.init = null;
                this.timestamp = DateUtils.getCurrentDateTime();
                if (this.timestamp != null) {
                    this.sequence = this.getSequenceTimestamp(this.timestamp);
                }
            }
            boolean bl = sessionHasBeenUpdated;
            return bl;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long getSequenceTimestamp(Date timestamp) {
        void var2_2;
        long sequence = timestamp.getTime();
        if (sequence < 0L) {
            sequence = Math.abs(sequence);
        }
        return (long)var2_2;
    }

    public final Session clone() {
        return new Session(this.status, this.started, this.timestamp, this.errorCount.get(), this.distinctId, this.sessionId, this.init, this.sequence, this.duration, this.ipAddress, this.userAgent, this.environment, this.release, this.abnormalMechanism);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.sessionId != null) {
            writer.name("sid").value(this.sessionId);
        }
        if (this.distinctId != null) {
            writer.name("did").value(this.distinctId);
        }
        if (this.init != null) {
            writer.name("init").value(this.init);
        }
        writer.name("started").value(logger, this.started);
        writer.name("status").value(logger, this.status.name().toLowerCase(Locale.ROOT));
        if (this.sequence != null) {
            writer.name("seq").value(this.sequence);
        }
        writer.name("errors").value(this.errorCount.intValue());
        if (this.duration != null) {
            writer.name("duration").value(this.duration);
        }
        if (this.timestamp != null) {
            writer.name("timestamp").value(logger, this.timestamp);
        }
        if (this.abnormalMechanism != null) {
            writer.name("abnormal_mechanism").value(logger, this.abnormalMechanism);
        }
        writer.name("attrs");
        writer.beginObject();
        writer.name("release").value(logger, this.release);
        if (this.environment != null) {
            writer.name("environment").value(logger, this.environment);
        }
        if (this.ipAddress != null) {
            writer.name("ip_address").value(logger, this.ipAddress);
        }
        if (this.userAgent != null) {
            writer.name("user_agent").value(logger, this.userAgent);
        }
        writer.endObject();
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Ok = new State();
        public static final /* enum */ State Exited = new State();
        public static final /* enum */ State Crashed = new State();
        public static final /* enum */ State Abnormal = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State valueOf(String name) {
            String string;
            return Enum.valueOf(State.class, string);
        }

        private static /* synthetic */ State[] $values() {
            return new State[]{Ok, Exited, Crashed, Abnormal};
        }

        static {
            $VALUES = State.$values();
        }
    }

    public static final class Deserializer
    implements JsonDeserializer<Session> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final Session deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            Date started = null;
            Date timestamp = null;
            Integer errorCount = null;
            String distinctId = null;
            String sessionId = null;
            Boolean init = null;
            State status = null;
            Long sequence = null;
            Double duration = null;
            String ipAddress = null;
            String userAgent = null;
            String environment = null;
            String release = null;
            String abnormalMechanism = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block38: while (reader.peek() == JsonToken.NAME) {
                String statusValue;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "sid": {
                        String sid = reader.nextStringOrNull();
                        if (sid != null && (sid.length() == 36 || sid.length() == 32)) {
                            sessionId = sid;
                            continue block38;
                        }
                        logger.log(SentryLevel.ERROR, "%s sid is not valid.", sid);
                        continue block38;
                    }
                    case "did": {
                        distinctId = reader.nextStringOrNull();
                        continue block38;
                    }
                    case "init": {
                        init = reader.nextBooleanOrNull();
                        continue block38;
                    }
                    case "started": {
                        started = reader.nextDateOrNull(logger);
                        continue block38;
                    }
                    case "status": {
                        statusValue = StringUtils.capitalize(reader.nextStringOrNull());
                        if (statusValue == null) continue block38;
                        status = State.valueOf(statusValue);
                        continue block38;
                    }
                    case "seq": {
                        sequence = reader.nextLongOrNull();
                        continue block38;
                    }
                    case "errors": {
                        errorCount = reader.nextIntegerOrNull();
                        continue block38;
                    }
                    case "duration": {
                        duration = reader.nextDoubleOrNull();
                        continue block38;
                    }
                    case "timestamp": {
                        timestamp = reader.nextDateOrNull(logger);
                        continue block38;
                    }
                    case "abnormal_mechanism": {
                        abnormalMechanism = reader.nextStringOrNull();
                        continue block38;
                    }
                    case "attrs": {
                        reader.beginObject();
                        block39: while (reader.peek() == JsonToken.NAME) {
                            switch (reader.nextName()) {
                                case "release": {
                                    release = reader.nextStringOrNull();
                                    continue block39;
                                }
                                case "environment": {
                                    environment = reader.nextStringOrNull();
                                    continue block39;
                                }
                                case "ip_address": {
                                    ipAddress = reader.nextStringOrNull();
                                    continue block39;
                                }
                                case "user_agent": {
                                    userAgent = reader.nextStringOrNull();
                                    continue block39;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block38;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, statusValue);
            }
            if (status == null) {
                throw this.missingRequiredFieldException("status", logger);
            }
            if (started == null) {
                throw this.missingRequiredFieldException("started", logger);
            }
            if (errorCount == null) {
                throw this.missingRequiredFieldException("errors", logger);
            }
            if (release == null) {
                void var2_2;
                throw this.missingRequiredFieldException("release", (ILogger)var2_2);
            }
            Session session = new Session(status, (Date)var3_3, timestamp, errorCount, distinctId, sessionId, init, sequence, duration, ipAddress, userAgent, environment, release, abnormalMechanism);
            session.setUnknown(unknown);
            var1_1.endObject();
            return session;
        }

        /*
         * WARNING - void declaration
         */
        private Exception missingRequiredFieldException(String field, ILogger logger) {
            void var3_3;
            void var1_1;
            void var2_2;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var2_2.log(SentryLevel.ERROR, (String)var1_1, exception);
            return var3_3;
        }
    }
}

