/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SentryThreadFactory {
    private final SentryStackTraceFactory sentryStackTraceFactory;
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public SentryThreadFactory(SentryStackTraceFactory sentryStackTraceFactory, SentryOptions options) {
        void var2_2;
        void var1_1;
        this.sentryStackTraceFactory = (SentryStackTraceFactory)Objects.requireNonNull(var1_1, "The SentryStackTraceFactory is required.");
        this.options = (SentryOptions)Objects.requireNonNull(var2_2, "The SentryOptions is required");
    }

    /*
     * WARNING - void declaration
     */
    final List<SentryThread> getCurrentThread() {
        void var1_1;
        void var2_2;
        HashMap<void, StackTraceElement[]> threads = new HashMap<void, StackTraceElement[]>();
        Thread currentThread = Thread.currentThread();
        void v0 = var2_2;
        threads.put(v0, v0.getStackTrace());
        return this.getCurrentThreads((Map<Thread, StackTraceElement[]>)var1_1, null, false);
    }

    /*
     * WARNING - void declaration
     */
    final List<SentryThread> getCurrentThreads(List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        void var2_2;
        void var1_1;
        return this.getCurrentThreads(Thread.getAllStackTraces(), (List<Long>)var1_1, (boolean)var2_2);
    }

    final List<SentryThread> getCurrentThreads(Map<Thread, StackTraceElement[]> threads, List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        ArrayList<SentryThread> result = null;
        Thread currentThread = Thread.currentThread();
        if (!threads.isEmpty()) {
            Iterator iterator;
            result = new ArrayList<SentryThread>();
            if (!threads.containsKey(currentThread)) {
                Thread thread = currentThread;
                threads.put(thread, thread.getStackTrace());
            }
            for (Map.Entry item : iterator.entrySet()) {
                Thread thread = (Thread)item.getKey();
                boolean crashed = thread == currentThread && !ignoreCurrentThread || mechanismThreadIds != null && mechanismThreadIds.contains(thread.getId()) && !ignoreCurrentThread;
                result.add(this.getSentryThread(crashed, (StackTraceElement[])item.getValue(), (Thread)item.getKey()));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private SentryThread getSentryThread(boolean crashed, StackTraceElement[] stackFramesElements, Thread thread) {
        void var2_3;
        void var3_4;
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(var3_4.getState().name());
        sentryThread.setCrashed(crashed);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames((StackTraceElement[])var2_3, false);
        if (this.options.isAttachStacktrace() && frames != null && !frames.isEmpty()) {
            void var1_2;
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            sentryStackTrace.setSnapshot(Boolean.TRUE);
            sentryThread.setStacktrace((SentryStackTrace)var1_2);
        }
        return sentryThread;
    }
}

