/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.protocol.SdkVersion;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SentryReplayOptions {
    private Double onErrorSampleRate;
    private Set<String> maskViewClasses = new CopyOnWriteArraySet<String>();
    private Set<String> unmaskViewClasses = new CopyOnWriteArraySet<String>();
    private String maskViewContainerClass = null;
    private String unmaskViewContainerClass = null;
    private SentryReplayQuality quality = SentryReplayQuality.MEDIUM;
    private int frameRate = 1;
    private long errorReplayDuration = 30000L;
    private long sessionSegmentDuration = 5000L;
    private long sessionDuration = 3600000L;
    private boolean trackOrientationChange = true;
    private SdkVersion sdkVersion;

    /*
     * WARNING - void declaration
     */
    public SentryReplayOptions(boolean empty, SdkVersion sdkVersion) {
        void var1_1;
        if (var1_1 == false) {
            void var2_2;
            this.setMaskAllText(true);
            this.setMaskAllImages(true);
            this.maskViewClasses.add("android.webkit.WebView");
            this.maskViewClasses.add("android.widget.VideoView");
            this.maskViewClasses.add("androidx.media3.ui.PlayerView");
            this.maskViewClasses.add("com.google.android.exoplayer2.ui.PlayerView");
            this.maskViewClasses.add("com.google.android.exoplayer2.ui.StyledPlayerView");
            this.sdkVersion = var2_2;
        }
    }

    public final Double getOnErrorSampleRate() {
        return this.onErrorSampleRate;
    }

    public final void setMaskAllText(boolean maskAllText) {
        if (maskAllText) {
            this.addMaskViewClass("android.widget.TextView");
            this.unmaskViewClasses.remove("android.widget.TextView");
            return;
        }
        this.addUnmaskViewClass("android.widget.TextView");
        this.maskViewClasses.remove("android.widget.TextView");
    }

    public final void setMaskAllImages(boolean maskAllImages) {
        if (maskAllImages) {
            this.addMaskViewClass("android.widget.ImageView");
            this.unmaskViewClasses.remove("android.widget.ImageView");
            return;
        }
        this.addUnmaskViewClass("android.widget.ImageView");
        this.maskViewClasses.remove("android.widget.ImageView");
    }

    /*
     * WARNING - void declaration
     */
    public final void addMaskViewClass(String className) {
        void var1_1;
        this.maskViewClasses.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addUnmaskViewClass(String className) {
        void var1_1;
        this.unmaskViewClasses.add((String)var1_1);
    }

    public final SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSdkVersion(SdkVersion sdkVersion) {
        void var1_1;
        this.sdkVersion = var1_1;
    }

    public static final class SentryReplayQuality
    extends Enum<SentryReplayQuality> {
        public static final /* enum */ SentryReplayQuality LOW = new SentryReplayQuality(0.8f, 50000, 10);
        public static final /* enum */ SentryReplayQuality MEDIUM = new SentryReplayQuality(1.0f, 75000, 30);
        public static final /* enum */ SentryReplayQuality HIGH = new SentryReplayQuality(1.0f, 100000, 50);
        public final float sizeScale;
        public final int bitRate;
        public final int screenshotQuality;
        private static final /* synthetic */ SentryReplayQuality[] $VALUES;

        /*
         * WARNING - void declaration
         */
        private SentryReplayQuality(float sizeScale, int bitRate, int screenshotQuality) {
            void var3_3;
            this.sizeScale = var3_3;
            this.bitRate = bitRate;
            this.screenshotQuality = screenshotQuality;
        }

        private static /* synthetic */ SentryReplayQuality[] $values() {
            return new SentryReplayQuality[]{LOW, MEDIUM, HIGH};
        }

        static {
            $VALUES = SentryReplayQuality.$values();
        }
    }
}

