/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SentryReplayEvent
extends SentryBaseEvent
implements JsonSerializable {
    private String type = "replay_event";
    private ReplayType replayType;
    private SentryId replayId = new SentryId();
    private int segmentId;
    private Date timestamp;
    private Date replayStartTimestamp;
    private List<String> urls;
    private List<String> errorIds;
    private List<String> traceIds;
    private Map<String, Object> unknown;

    public SentryReplayEvent() {
        this.replayType = ReplayType.SESSION;
        this.errorIds = new ArrayList<String>();
        this.traceIds = new ArrayList<String>();
        this.urls = new ArrayList<String>();
        this.timestamp = DateUtils.getCurrentDateTime();
    }

    /*
     * WARNING - void declaration
     */
    public final void setType(String type) {
        void var1_1;
        this.type = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayId(SentryId replayId) {
        void var1_1;
        this.replayId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSegmentId(int segmentId) {
        void var1_1;
        this.segmentId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimestamp(Date timestamp) {
        void var1_1;
        this.timestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayStartTimestamp(Date replayStartTimestamp) {
        void var1_1;
        this.replayStartTimestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUrls(List<String> urls) {
        void var1_1;
        this.urls = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setErrorIds(List<String> errorIds) {
        void var1_1;
        this.errorIds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTraceIds(List<String> traceIds) {
        void var1_1;
        this.traceIds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayType(ReplayType replayType) {
        void var1_1;
        this.replayType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryReplayEvent that = (SentryReplayEvent)o;
        return this.segmentId == that.segmentId && Objects.equals(this.type, that.type) && this.replayType == that.replayType && Objects.equals(this.replayId, that.replayId) && Objects.equals(this.urls, that.urls) && Objects.equals(this.errorIds, that.errorIds) && Objects.equals(this.traceIds, var1_1.traceIds);
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.replayType, this.replayId, this.segmentId, this.urls, this.errorIds, this.traceIds);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("type").value(this.type);
        writer.name("replay_type").value(logger, this.replayType);
        writer.name("segment_id").value(this.segmentId);
        writer.name("timestamp").value(logger, this.timestamp);
        if (this.replayId != null) {
            writer.name("replay_id").value(logger, this.replayId);
        }
        if (this.replayStartTimestamp != null) {
            writer.name("replay_start_timestamp").value(logger, this.replayStartTimestamp);
        }
        if (this.urls != null) {
            writer.name("urls").value(logger, this.urls);
        }
        if (this.errorIds != null) {
            writer.name("error_ids").value(logger, this.errorIds);
        }
        if (this.traceIds != null) {
            writer.name("trace_ids").value(logger, this.traceIds);
        }
        new SentryBaseEvent.Serializer().serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class ReplayType
    extends Enum<ReplayType>
    implements JsonSerializable {
        public static final /* enum */ ReplayType SESSION = new ReplayType();
        public static final /* enum */ ReplayType BUFFER = new ReplayType();
        private static final /* synthetic */ ReplayType[] $VALUES;

        public static ReplayType valueOf(String name) {
            String string;
            return Enum.valueOf(ReplayType.class, string);
        }

        @Override
        public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
            writer.value(this.name().toLowerCase(Locale.ROOT));
        }

        private static /* synthetic */ ReplayType[] $values() {
            return new ReplayType[]{SESSION, BUFFER};
        }

        static {
            $VALUES = ReplayType.$values();
        }

        public static final class Deserializer
        implements JsonDeserializer<ReplayType> {
            @Override
            public final ReplayType deserialize(ObjectReader reader, ILogger logger) throws Exception {
                return ReplayType.valueOf(reader.nextString().toUpperCase(Locale.ROOT));
            }
        }
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryReplayEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryReplayEvent deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            SentryReplayEvent replay = new SentryReplayEvent();
            HashMap<String, Object> unknown = null;
            String type = null;
            ReplayType replayType = null;
            SentryId replayId = null;
            Integer segmentId = null;
            Date timestamp = null;
            Date replayStartTimestamp = null;
            List urls = null;
            List errorIds = null;
            List traceIds = null;
            reader.beginObject();
            block22: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "type": {
                        type = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "replay_type": {
                        replayType = reader.nextOrNull(logger, new ReplayType.Deserializer());
                        continue block22;
                    }
                    case "replay_id": {
                        replayId = reader.nextOrNull(logger, new SentryId.Deserializer());
                        continue block22;
                    }
                    case "segment_id": {
                        segmentId = reader.nextIntegerOrNull();
                        continue block22;
                    }
                    case "timestamp": {
                        timestamp = reader.nextDateOrNull(logger);
                        continue block22;
                    }
                    case "replay_start_timestamp": {
                        replayStartTimestamp = reader.nextDateOrNull(logger);
                        continue block22;
                    }
                    case "urls": {
                        urls = (List)reader.nextObjectOrNull();
                        continue block22;
                    }
                    case "error_ids": {
                        errorIds = (List)reader.nextObjectOrNull();
                        continue block22;
                    }
                    case "trace_ids": {
                        traceIds = (List)reader.nextObjectOrNull();
                        continue block22;
                    }
                }
                if (baseEventDeserializer.deserializeValue(replay, nextName, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            var1_1.endObject();
            if (type != null) {
                replay.setType(type);
            }
            if (replayType != null) {
                replay.setReplayType(replayType);
            }
            if (segmentId != null) {
                replay.setSegmentId(segmentId);
            }
            if (timestamp != null) {
                replay.setTimestamp(timestamp);
            }
            replay.setReplayId(replayId);
            replay.setReplayStartTimestamp(replayStartTimestamp);
            replay.setUrls(urls);
            replay.setErrorIds(errorIds);
            replay.setTraceIds(traceIds);
            replay.setUnknown(unknown);
            return replay;
        }
    }
}

