/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.CompositePerformanceCollector;
import io.sentry.DiagnosticLogger;
import io.sentry.Dsn;
import io.sentry.DuplicateEventDetectionEventProcessor;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.ExperimentalOptions;
import io.sentry.ExternalOptions;
import io.sentry.FilterString;
import io.sentry.FullyDisplayedReporter;
import io.sentry.Hint;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IContinuousProfiler;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.IPerformanceCollector;
import io.sentry.IScopeObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISerializer;
import io.sentry.ISpanFactory;
import io.sentry.ITransactionProfiler;
import io.sentry.ITransportFactory;
import io.sentry.IVersionDetector;
import io.sentry.InitPriority;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.JsonSerializer;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpCompositePerformanceCollector;
import io.sentry.NoOpConnectionStatusProvider;
import io.sentry.NoOpContinuousProfiler;
import io.sentry.NoOpLogger;
import io.sentry.NoOpReplayController;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpSpanFactory;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoOpTransportFactory;
import io.sentry.NoopVersionDetector;
import io.sentry.ProfileLifecycle;
import io.sentry.ReplayController;
import io.sentry.SamplingContext;
import io.sentry.ScopeType;
import io.sentry.SentryAutoDateProvider;
import io.sentry.SentryDateProvider;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOpenTelemetryMode;
import io.sentry.SentryReplayOptions;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.SpanFactoryFactory;
import io.sentry.SpotlightIntegration;
import io.sentry.TracesSampler;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.backpressure.IBackpressureMonitor;
import io.sentry.backpressure.NoOpBackpressureMonitor;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.clientreport.ClientReportRecorder;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.NoOpClientReportRecorder;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.protocol.SdkVersion;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.LoadClass;
import io.sentry.util.Platform;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import io.sentry.util.thread.IThreadChecker;
import io.sentry.util.thread.NoOpThreadChecker;
import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.SSLSocketFactory;

public class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    private List<FilterString> ignoredErrors = null;
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    private final Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    private String dsn;
    private final LazyEvaluator<Dsn> parsedDsn = new LazyEvaluator<Dsn>(() -> new Dsn(this.dsn));
    private String dsnHash;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private long sessionFlushTimeoutMillis = 15000L;
    private boolean debug;
    private ILogger logger = NoOpLogger.getInstance();
    private ILogger fatalLogger = NoOpLogger.getInstance();
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    private final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> new JsonSerializer(this));
    private final LazyEvaluator<IEnvelopeReader> envelopeReader = new LazyEvaluator<IEnvelopeReader>(() -> new EnvelopeReader(this.serializer.getValue()));
    private int maxDepth = 100;
    private String sentryClientName;
    private BeforeSendCallback beforeSend;
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    private String release;
    private String environment;
    private Proxy proxy;
    private Double sampleRate;
    private Double tracesSampleRate;
    private TracesSamplerCallback tracesSampler;
    private volatile TracesSampler internalTracesSampler;
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    private String dist;
    private boolean attachThreads;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private long sessionTrackingIntervalMillis = 30000L;
    private String serverName;
    private boolean attachServerName = true;
    private boolean enableUncaughtExceptionHandler = true;
    private boolean printUncaughtStackTrace = false;
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();
    private int connectionTimeoutMillis = 30000;
    private int readTimeoutMillis = 30000;
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    private SSLSocketFactory sslSocketFactory;
    private final List<IScopeObserver> observers = new CopyOnWriteArrayList<IScopeObserver>();
    private final List<IOptionsObserver> optionsObservers = new CopyOnWriteArrayList<IOptionsObserver>();
    private boolean enableExternalConfiguration;
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    private boolean enableDeduplication = true;
    private int maxSpans = 1000;
    private boolean enableShutdownHook = true;
    private RequestSize maxRequestBodySize = RequestSize.NONE;
    private boolean traceSampling = true;
    private Double profilesSampleRate;
    private ProfilesSamplerCallback profilesSampler;
    private long maxTraceFileSize = 0x500000L;
    private ITransactionProfiler transactionProfiler = NoOpTransactionProfiler.getInstance();
    private IContinuousProfiler continuousProfiler = NoOpContinuousProfiler.getInstance();
    private List<String> tracePropagationTargets = null;
    private final List<String> defaultTracePropagationTargets = Collections.singletonList(".*");
    private String proguardUuid;
    private Long idleTimeout = 3000L;
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private boolean sendClientReports = true;
    IClientReportRecorder clientReportRecorder = new ClientReportRecorder(this);
    private IModulesLoader modulesLoader = NoOpModulesLoader.getInstance();
    private IDebugMetaLoader debugMetaLoader = NoOpDebugMetaLoader.getInstance();
    private boolean enableUserInteractionTracing = false;
    private boolean enableUserInteractionBreadcrumbs = true;
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    private final List<Object> gestureTargetLocators = new ArrayList<Object>();
    private final List<Object> viewHierarchyExporters = new ArrayList<Object>();
    private IThreadChecker threadChecker = NoOpThreadChecker.getInstance();
    private boolean traceOptionsRequests = true;
    private final LazyEvaluator<SentryDateProvider> dateProvider = new LazyEvaluator<SentryDateProvider>(() -> new SentryAutoDateProvider());
    private final List<IPerformanceCollector> performanceCollectors = new ArrayList<IPerformanceCollector>();
    private CompositePerformanceCollector compositePerformanceCollector = NoOpCompositePerformanceCollector.getInstance();
    private boolean enableTimeToFullDisplayTracing = false;
    private FullyDisplayedReporter fullyDisplayedReporter = FullyDisplayedReporter.getInstance();
    private IConnectionStatusProvider connectionStatusProvider = new NoOpConnectionStatusProvider();
    private boolean enabled = true;
    private boolean enablePrettySerializationOutput = true;
    private boolean sendModules = true;
    private BeforeEnvelopeCallback beforeEnvelopeCallback;
    private boolean enableSpotlight = false;
    private String spotlightConnectionUrl;
    private boolean enableScopePersistence = true;
    private List<FilterString> ignoredCheckIns = null;
    private List<FilterString> ignoredSpanOrigins = null;
    private List<FilterString> ignoredTransactions = null;
    private IBackpressureMonitor backpressureMonitor = NoOpBackpressureMonitor.getInstance();
    private boolean enableBackpressureHandling = true;
    private boolean enableAppStartProfiling = false;
    private ISpanFactory spanFactory = NoOpSpanFactory.getInstance();
    private int profilingTracesHz = 101;
    private Cron cron = null;
    private final ExperimentalOptions experimental;
    private ReplayController replayController = NoOpReplayController.getInstance();
    private boolean enableScreenTracking = true;
    private ScopeType defaultScopeType = ScopeType.ISOLATION;
    private InitPriority initPriority = InitPriority.MEDIUM;
    private boolean forceInit = false;
    private Boolean globalHubMode = null;
    protected final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    private SentryOpenTelemetryMode openTelemetryMode = SentryOpenTelemetryMode.AUTO;
    private SentryReplayOptions sessionReplay;
    private boolean captureOpenTelemetryEvents = false;
    private IVersionDetector versionDetector = NoopVersionDetector.getInstance();
    private Double profileSessionSampleRate;
    private ProfileLifecycle profileLifecycle = ProfileLifecycle.MANUAL;
    private boolean startProfilerOnAppStart = false;

    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    public String getDsn() {
        return this.dsn;
    }

    Dsn retrieveParsedDsn() throws IllegalArgumentException {
        return this.parsedDsn.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setDsn(String dsn) {
        void var1_1;
        this.dsn = var1_1;
        this.parsedDsn.resetValue();
        this.dsnHash = StringUtils.calculateStringHash(this.dsn, this.logger);
    }

    public boolean isDebug() {
        return this.debug;
    }

    /*
     * WARNING - void declaration
     */
    public void setDebug(boolean debug) {
        void var1_1;
        this.debug = var1_1;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogger(ILogger logger) {
        void var1_1;
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, (ILogger)var1_1);
    }

    public ILogger getFatalLogger() {
        return this.fatalLogger;
    }

    /*
     * WARNING - void declaration
     */
    public void setFatalLogger(ILogger logger) {
        void var1_1;
        this.fatalLogger = logger == null ? NoOpLogger.getInstance() : var1_1;
    }

    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiagnosticLevel(SentryLevel diagnosticLevel) {
        void var1_1;
        this.diagnosticLevel = diagnosticLevel != null ? var1_1 : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    public ISerializer getSerializer() {
        return this.serializer.getValue();
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader.getValue();
    }

    public long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public String getSentryClientName() {
        return this.sentryClientName;
    }

    /*
     * WARNING - void declaration
     */
    public void setSentryClientName(String sentryClientName) {
        void var1_1;
        this.sentryClientName = var1_1;
    }

    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    /*
     * WARNING - void declaration
     */
    public void setBeforeSend(BeforeSendCallback beforeSend) {
        void var1_1;
        this.beforeSend = var1_1;
    }

    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    /*
     * WARNING - void declaration
     */
    public void setBeforeBreadcrumb(BeforeBreadcrumbCallback beforeBreadcrumb) {
        void var1_1;
        this.beforeBreadcrumb = var1_1;
    }

    public String getCacheDirPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        if (this.dsnHash != null) {
            return new File(this.cacheDirPath, this.dsnHash).getAbsolutePath();
        }
        return this.cacheDirPath;
    }

    String getCacheDirPathWithoutDsn() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath;
    }

    /*
     * WARNING - void declaration
     */
    public String getOutboxPath() {
        void var1_1;
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File((String)var1_1, "outbox").getAbsolutePath();
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        void var1_1;
        this.maxBreadcrumbs = var1_1;
    }

    public String getRelease() {
        return this.release;
    }

    /*
     * WARNING - void declaration
     */
    public void setRelease(String release) {
        void var1_1;
        this.release = var1_1;
    }

    public String getEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        return "production";
    }

    /*
     * WARNING - void declaration
     */
    public void setEnvironment(String environment) {
        void var1_1;
        this.environment = var1_1;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - void declaration
     */
    public void setProxy(Proxy proxy) {
        void var1_1;
        this.proxy = var1_1;
    }

    public Double getSampleRate() {
        return this.sampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleRate(Double sampleRate) {
        void var1_1;
        if (!SampleRateUtils.isValidSampleRate(sampleRate)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.sampleRate = var1_1;
    }

    public Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setTracesSampleRate(Double tracesSampleRate) {
        void var1_1;
        if (!SampleRateUtils.isValidTracesSampleRate(tracesSampleRate)) {
            throw new IllegalArgumentException("The value " + tracesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.tracesSampleRate = var1_1;
    }

    public TracesSamplerCallback getTracesSampler() {
        return this.tracesSampler;
    }

    /*
     * WARNING - void declaration
     */
    public TracesSampler getInternalTracesSampler() {
        if (this.internalTracesSampler == null) {
            ISentryLifecycleToken ignored = this.lock.acquire();
            try {
                if (this.internalTracesSampler == null) {
                    this.internalTracesSampler = new TracesSampler(this);
                }
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return this.internalTracesSampler;
    }

    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    /*
     * WARNING - void declaration
     */
    public void addInAppExclude(String exclude) {
        void var1_1;
        this.inAppExcludes.add((String)var1_1);
    }

    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    /*
     * WARNING - void declaration
     */
    public void addInAppInclude(String include) {
        void var1_1;
        this.inAppIncludes.add((String)var1_1);
    }

    public ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransportFactory(ITransportFactory transportFactory) {
        void var1_1;
        this.transportFactory = transportFactory != null ? var1_1 : NoOpTransportFactory.getInstance();
    }

    public String getDist() {
        return this.dist;
    }

    /*
     * WARNING - void declaration
     */
    public void setDist(String dist) {
        void var1_1;
        this.dist = var1_1;
    }

    public ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttachStacktrace(boolean attachStacktrace) {
        void var1_1;
        this.attachStacktrace = var1_1;
    }

    public boolean isAttachThreads() {
        return this.attachThreads;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttachThreads(boolean attachThreads) {
        void var1_1;
        this.attachThreads = var1_1;
    }

    public boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableAutoSessionTracking(boolean enableAutoSessionTracking) {
        void var1_1;
        this.enableAutoSessionTracking = var1_1;
    }

    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - void declaration
     */
    public void setServerName(String serverName) {
        void var1_1;
        this.serverName = var1_1;
    }

    public boolean isAttachServerName() {
        return this.attachServerName;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        void var1_1;
        this.sessionTrackingIntervalMillis = var1_1;
    }

    public long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableUncaughtExceptionHandler(boolean enableUncaughtExceptionHandler) {
        void var1_1;
        this.enableUncaughtExceptionHandler = var1_1;
    }

    public boolean isPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrintUncaughtStackTrace(boolean printUncaughtStackTrace) {
        void var1_1;
        this.printUncaughtStackTrace = var1_1;
    }

    public ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - void declaration
     */
    public void setExecutorService(ISentryExecutorService executorService) {
        if (executorService != null) {
            void var1_1;
            this.executorService = var1_1;
        }
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnvelopeDiskCache(IEnvelopeCache envelopeDiskCache) {
        void var1_1;
        this.envelopeDiskCache = envelopeDiskCache != null ? var1_1 : NoOpEnvelopeCache.getInstance();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSdkVersion(SdkVersion sdkVersion) {
        void var1_1;
        void var2_2;
        SdkVersion replaySdkVersion = this.getSessionReplay().getSdkVersion();
        if (this.sdkVersion != null && replaySdkVersion != null && this.sdkVersion.equals(var2_2)) {
            this.getSessionReplay().setSdkVersion(sdkVersion);
        }
        this.sdkVersion = var1_1;
    }

    public boolean isSendDefaultPii() {
        return this.sendDefaultPii;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendDefaultPii(boolean sendDefaultPii) {
        void var1_1;
        this.sendDefaultPii = var1_1;
    }

    public List<IScopeObserver> getScopeObservers() {
        return this.observers;
    }

    /*
     * WARNING - void declaration
     */
    public PersistingScopeObserver findPersistingScopeObserver() {
        for (IScopeObserver observer : this.observers) {
            void var2_2;
            if (!(observer instanceof PersistingScopeObserver)) continue;
            return (PersistingScopeObserver)var2_2;
        }
        return null;
    }

    public List<IOptionsObserver> getOptionsObservers() {
        return this.optionsObservers;
    }

    public boolean isEnableExternalConfiguration() {
        return this.enableExternalConfiguration;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxAttachmentSize(long maxAttachmentSize) {
        void var1_1;
        this.maxAttachmentSize = var1_1;
    }

    public boolean isEnableDeduplication() {
        return this.enableDeduplication;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableDeduplication(boolean enableDeduplication) {
        void var1_1;
        this.enableDeduplication = var1_1;
    }

    public boolean isTracingEnabled() {
        return this.getTracesSampleRate() != null || this.getTracesSampler() != null;
    }

    public Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    /*
     * WARNING - void declaration
     */
    public void addIgnoredExceptionForType(Class<? extends Throwable> exceptionType) {
        void var1_1;
        this.ignoredExceptionsForType.add((Class<? extends Throwable>)var1_1);
    }

    public List<FilterString> getIgnoredErrors() {
        return this.ignoredErrors;
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoredErrors(List<String> ignoredErrors) {
        void var2_2;
        Iterator iterator;
        if (ignoredErrors == null) {
            this.ignoredErrors = null;
            return;
        }
        ArrayList<FilterString> patterns = new ArrayList<FilterString>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String pattern = (String)iterator.next();
            if (pattern == null || pattern.isEmpty()) continue;
            patterns.add(new FilterString((String)var3_3));
        }
        this.ignoredErrors = var2_2;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxRequestBodySize(RequestSize maxRequestBodySize) {
        void var1_1;
        this.maxRequestBodySize = var1_1;
    }

    public long getMaxTraceFileSize() {
        return this.maxTraceFileSize;
    }

    public ITransactionProfiler getTransactionProfiler() {
        return this.transactionProfiler;
    }

    public IContinuousProfiler getContinuousProfiler() {
        return this.continuousProfiler;
    }

    public boolean isProfilingEnabled() {
        return this.profilesSampleRate != null && this.profilesSampleRate > 0.0 || this.profilesSampler != null;
    }

    public boolean isContinuousProfilingEnabled() {
        return this.profilesSampleRate == null && this.profilesSampler == null && this.profileSessionSampleRate != null && this.profileSessionSampleRate > 0.0;
    }

    public ProfilesSamplerCallback getProfilesSampler() {
        return this.profilesSampler;
    }

    public Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setProfilesSampleRate(Double profilesSampleRate) {
        void var1_1;
        if (!SampleRateUtils.isValidProfilesSampleRate(profilesSampleRate)) {
            throw new IllegalArgumentException("The value " + profilesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.profilesSampleRate = var1_1;
    }

    public Double getProfileSessionSampleRate() {
        return this.profileSessionSampleRate;
    }

    public ProfileLifecycle getProfileLifecycle() {
        return this.profileLifecycle;
    }

    public boolean isStartProfilerOnAppStart() {
        return this.startProfilerOnAppStart;
    }

    /*
     * WARNING - void declaration
     */
    public String getProfilingTracesDirPath() {
        void var1_1;
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File((String)var1_1, "profiling_traces").getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public void setTracePropagationTargets(List<String> tracePropagationTargets) {
        void var2_2;
        Iterator iterator;
        if (tracePropagationTargets == null) {
            this.tracePropagationTargets = null;
            return;
        }
        ArrayList<void> filteredTracePropagationTargets = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String target = (String)iterator.next();
            if (target.isEmpty()) continue;
            filteredTracePropagationTargets.add(var3_3);
        }
        this.tracePropagationTargets = var2_2;
    }

    public String getProguardUuid() {
        return this.proguardUuid;
    }

    /*
     * WARNING - void declaration
     */
    public void setProguardUuid(String proguardUuid) {
        void var1_1;
        this.proguardUuid = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addBundleId(String bundleId) {
        String trimmedBundleId;
        if (bundleId != null && !(trimmedBundleId = bundleId.trim()).isEmpty()) {
            void var1_1;
            this.bundleIds.add((String)var1_1);
        }
    }

    public Set<String> getBundleIds() {
        return this.bundleIds;
    }

    /*
     * WARNING - void declaration
     */
    public void addContextTag(String contextTag) {
        void var1_1;
        this.contextTags.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(Long idleTimeout) {
        void var1_1;
        this.idleTimeout = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendClientReports(boolean sendClientReports) {
        void var1_1;
        this.sendClientReports = sendClientReports;
        if (var1_1 != false) {
            this.clientReportRecorder = new ClientReportRecorder(this);
            return;
        }
        this.clientReportRecorder = new NoOpClientReportRecorder();
    }

    public IClientReportRecorder getClientReportRecorder() {
        return this.clientReportRecorder;
    }

    public IModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    /*
     * WARNING - void declaration
     */
    public void setModulesLoader(IModulesLoader modulesLoader) {
        void var1_1;
        this.modulesLoader = modulesLoader != null ? var1_1 : NoOpModulesLoader.getInstance();
    }

    public IDebugMetaLoader getDebugMetaLoader() {
        return this.debugMetaLoader;
    }

    /*
     * WARNING - void declaration
     */
    public void setDebugMetaLoader(IDebugMetaLoader debugMetaLoader) {
        void var1_1;
        this.debugMetaLoader = debugMetaLoader != null ? var1_1 : NoOpDebugMetaLoader.getInstance();
    }

    public IThreadChecker getThreadChecker() {
        return this.threadChecker;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadChecker(IThreadChecker threadChecker) {
        void var1_1;
        this.threadChecker = var1_1;
    }

    public CompositePerformanceCollector getCompositePerformanceCollector() {
        return this.compositePerformanceCollector;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.enabled = var1_1;
    }

    public boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    public boolean isSendModules() {
        return this.sendModules;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnablePrettySerializationOutput(boolean enablePrettySerializationOutput) {
        void var1_1;
        this.enablePrettySerializationOutput = var1_1;
    }

    public boolean isEnableAppStartProfiling() {
        return (this.isProfilingEnabled() || this.isContinuousProfilingEnabled()) && this.enableAppStartProfiling;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendModules(boolean sendModules) {
        void var1_1;
        this.sendModules = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addIgnoredSpanOrigin(String ignoredSpanOrigin) {
        void var1_1;
        if (this.ignoredSpanOrigins == null) {
            this.ignoredSpanOrigins = new ArrayList<FilterString>();
        }
        this.ignoredSpanOrigins.add(new FilterString((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoredCheckIns(List<String> ignoredCheckIns) {
        void var2_2;
        Iterator iterator;
        if (ignoredCheckIns == null) {
            this.ignoredCheckIns = null;
            return;
        }
        ArrayList<FilterString> filteredIgnoredCheckIns = new ArrayList<FilterString>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String slug = (String)iterator.next();
            if (slug.isEmpty()) continue;
            filteredIgnoredCheckIns.add(new FilterString((String)var3_3));
        }
        this.ignoredCheckIns = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoredTransactions(List<String> ignoredTransactions) {
        void var2_2;
        Iterator iterator;
        if (ignoredTransactions == null) {
            this.ignoredTransactions = null;
            return;
        }
        ArrayList<FilterString> filtered = new ArrayList<FilterString>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String transactionName = (String)iterator.next();
            if (transactionName == null || transactionName.isEmpty()) continue;
            filtered.add(new FilterString((String)var3_3));
        }
        this.ignoredTransactions = var2_2;
    }

    public SentryDateProvider getDateProvider() {
        return this.dateProvider.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void addPerformanceCollector(IPerformanceCollector collector) {
        void var1_1;
        this.performanceCollectors.add((IPerformanceCollector)var1_1);
    }

    public List<IPerformanceCollector> getPerformanceCollectors() {
        return this.performanceCollectors;
    }

    public IBackpressureMonitor getBackpressureMonitor() {
        return this.backpressureMonitor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackpressureMonitor(IBackpressureMonitor backpressureMonitor) {
        void var1_1;
        this.backpressureMonitor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableBackpressureHandling(boolean enableBackpressureHandling) {
        void var1_1;
        this.enableBackpressureHandling = var1_1;
    }

    public IVersionDetector getVersionDetector() {
        return this.versionDetector;
    }

    /*
     * WARNING - void declaration
     */
    public void setVersionDetector(IVersionDetector versionDetector) {
        void var1_1;
        this.versionDetector = var1_1;
    }

    public int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    public boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    public long getSessionFlushTimeoutMillis() {
        return this.sessionFlushTimeoutMillis;
    }

    public BeforeEnvelopeCallback getBeforeEnvelopeCallback() {
        return this.beforeEnvelopeCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void setBeforeEnvelopeCallback(BeforeEnvelopeCallback beforeEnvelopeCallback) {
        void var1_1;
        this.beforeEnvelopeCallback = var1_1;
    }

    public String getSpotlightConnectionUrl() {
        return this.spotlightConnectionUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void setSpotlightConnectionUrl(String spotlightConnectionUrl) {
        void var1_1;
        this.spotlightConnectionUrl = var1_1;
    }

    public boolean isEnableSpotlight() {
        return this.enableSpotlight;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableSpotlight(boolean enableSpotlight) {
        void var1_1;
        this.enableSpotlight = var1_1;
    }

    public boolean isEnableScopePersistence() {
        return this.enableScopePersistence;
    }

    public Cron getCron() {
        return this.cron;
    }

    /*
     * WARNING - void declaration
     */
    public void setCron(Cron cron) {
        void var1_1;
        this.cron = var1_1;
    }

    public ReplayController getReplayController() {
        return this.replayController;
    }

    public ScopeType getDefaultScopeType() {
        return this.defaultScopeType;
    }

    public InitPriority getInitPriority() {
        return this.initPriority;
    }

    /*
     * WARNING - void declaration
     */
    public void setForceInit(boolean forceInit) {
        void var1_1;
        this.forceInit = var1_1;
    }

    public boolean isForceInit() {
        return this.forceInit;
    }

    /*
     * WARNING - void declaration
     */
    public void setGlobalHubMode(Boolean globalHubMode) {
        void var1_1;
        this.globalHubMode = var1_1;
    }

    public Boolean isGlobalHubMode() {
        return this.globalHubMode;
    }

    /*
     * WARNING - void declaration
     */
    public void setOpenTelemetryMode(SentryOpenTelemetryMode openTelemetryMode) {
        void var1_1;
        this.openTelemetryMode = var1_1;
    }

    public SentryOpenTelemetryMode getOpenTelemetryMode() {
        return this.openTelemetryMode;
    }

    public SentryReplayOptions getSessionReplay() {
        return this.sessionReplay;
    }

    /*
     * WARNING - void declaration
     */
    public void setCaptureOpenTelemetryEvents(boolean captureOpenTelemetryEvents) {
        void var1_1;
        this.captureOpenTelemetryEvents = var1_1;
    }

    void loadLazyFields() {
        this.getSerializer();
        this.retrieveParsedDsn();
        this.getEnvelopeReader();
        this.getDateProvider();
    }

    public static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private SentryOptions(boolean empty) {
        void var1_1;
        SdkVersion sdkVersion = this.createSdkVersion();
        this.experimental = new ExperimentalOptions(empty, sdkVersion);
        this.sessionReplay = new SentryReplayOptions(empty, sdkVersion);
        if (var1_1 == false) {
            void var2_2;
            this.setSpanFactory(SpanFactoryFactory.create(new LoadClass(), NoOpLogger.getInstance()));
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.integrations.add(new SpotlightIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add(new DuplicateEventDetectionEventProcessor(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            this.setSentryClientName("sentry.java/8.8.0");
            this.setSdkVersion((SdkVersion)var2_2);
            this.addPackageInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void merge(ExternalOptions options) {
        if (options.getDsn() != null) {
            this.setDsn(options.getDsn());
        }
        if (options.getEnvironment() != null) {
            this.setEnvironment(options.getEnvironment());
        }
        if (options.getRelease() != null) {
            this.setRelease(options.getRelease());
        }
        if (options.getDist() != null) {
            this.setDist(options.getDist());
        }
        if (options.getServerName() != null) {
            this.setServerName(options.getServerName());
        }
        if (options.getProxy() != null) {
            this.setProxy(options.getProxy());
        }
        if (options.getEnableUncaughtExceptionHandler() != null) {
            this.setEnableUncaughtExceptionHandler(options.getEnableUncaughtExceptionHandler());
        }
        if (options.getPrintUncaughtStackTrace() != null) {
            this.setPrintUncaughtStackTrace(options.getPrintUncaughtStackTrace());
        }
        if (options.getTracesSampleRate() != null) {
            this.setTracesSampleRate(options.getTracesSampleRate());
        }
        if (options.getProfilesSampleRate() != null) {
            this.setProfilesSampleRate(options.getProfilesSampleRate());
        }
        if (options.getDebug() != null) {
            this.setDebug(options.getDebug());
        }
        if (options.getEnableDeduplication() != null) {
            this.setEnableDeduplication(options.getEnableDeduplication());
        }
        if (options.getSendClientReports() != null) {
            this.setSendClientReports(options.getSendClientReports());
        }
        if (options.isForceInit() != null) {
            this.setForceInit(options.isForceInit());
        }
        HashMap<String, String> arrayList = new HashMap<String, String>(options.getTags());
        for (Map.Entry entry : arrayList.entrySet()) {
            this.tags.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(options.getInAppIncludes());
        for (String string : arrayList2) {
            this.addInAppInclude(string);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(options.getInAppExcludes());
        for (String string : arrayList3) {
            this.addInAppExclude(string);
        }
        for (Class<? extends Throwable> clazz : new HashSet<Class<? extends Throwable>>(options.getIgnoredExceptionsForType())) {
            this.addIgnoredExceptionForType(clazz);
        }
        if (options.getTracePropagationTargets() != null) {
            ArrayList<String> arrayList4 = new ArrayList<String>(options.getTracePropagationTargets());
            this.setTracePropagationTargets(arrayList4);
        }
        ArrayList<String> arrayList5 = new ArrayList<String>(options.getContextTags());
        for (String string : arrayList5) {
            this.addContextTag(string);
        }
        if (options.getProguardUuid() != null) {
            this.setProguardUuid(options.getProguardUuid());
        }
        if (options.getIdleTimeout() != null) {
            this.setIdleTimeout(options.getIdleTimeout());
        }
        for (String string : options.getBundleIds()) {
            this.addBundleId(string);
        }
        if (options.isEnabled() != null) {
            this.setEnabled(options.isEnabled());
        }
        if (options.isEnablePrettySerializationOutput() != null) {
            this.setEnablePrettySerializationOutput(options.isEnablePrettySerializationOutput());
        }
        if (options.isSendModules() != null) {
            this.setSendModules(options.isSendModules());
        }
        if (options.getIgnoredCheckIns() != null) {
            ArrayList<String> arrayList6 = new ArrayList<String>(options.getIgnoredCheckIns());
            this.setIgnoredCheckIns(arrayList6);
        }
        if (options.getIgnoredTransactions() != null) {
            ArrayList<String> arrayList7 = new ArrayList<String>(options.getIgnoredTransactions());
            this.setIgnoredTransactions(arrayList7);
        }
        if (options.getIgnoredErrors() != null) {
            ArrayList<String> arrayList8 = new ArrayList<String>(options.getIgnoredErrors());
            this.setIgnoredErrors(arrayList8);
        }
        if (options.isEnableBackpressureHandling() != null) {
            this.setEnableBackpressureHandling(options.isEnableBackpressureHandling());
        }
        if (options.getMaxRequestBodySize() != null) {
            this.setMaxRequestBodySize(options.getMaxRequestBodySize());
        }
        if (options.isSendDefaultPii() != null) {
            this.setSendDefaultPii(options.isSendDefaultPii());
        }
        if (options.isCaptureOpenTelemetryEvents() != null) {
            this.setCaptureOpenTelemetryEvents(options.isCaptureOpenTelemetryEvents());
        }
        if (options.isEnableSpotlight() != null) {
            this.setEnableSpotlight(options.isEnableSpotlight());
        }
        if (options.getSpotlightConnectionUrl() != null) {
            this.setSpotlightConnectionUrl(options.getSpotlightConnectionUrl());
        }
        if (options.isGlobalHubMode() != null) {
            this.setGlobalHubMode(options.isGlobalHubMode());
        }
        if (options.getCron() != null) {
            if (this.getCron() == null) {
                this.setCron(options.getCron());
                return;
            }
            if (options.getCron().getDefaultCheckinMargin() != null) {
                this.getCron().setDefaultCheckinMargin(options.getCron().getDefaultCheckinMargin());
            }
            if (options.getCron().getDefaultMaxRuntime() != null) {
                this.getCron().setDefaultMaxRuntime(options.getCron().getDefaultMaxRuntime());
            }
            if (options.getCron().getDefaultTimezone() != null) {
                this.getCron().setDefaultTimezone(options.getCron().getDefaultTimezone());
            }
            if (options.getCron().getDefaultFailureIssueThreshold() != null) {
                this.getCron().setDefaultFailureIssueThreshold(options.getCron().getDefaultFailureIssueThreshold());
            }
            if (options.getCron().getDefaultRecoveryThreshold() != null) {
                void var1_1;
                this.getCron().setDefaultRecoveryThreshold(var1_1.getCron().getDefaultRecoveryThreshold());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private SdkVersion createSdkVersion() {
        void var1_1;
        SdkVersion sdkVersion = new SdkVersion("sentry.java", "8.8.0");
        sdkVersion.setVersion("8.8.0");
        return var1_1;
    }

    private void addPackageInfo() {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry", "8.8.0");
    }

    public ISpanFactory getSpanFactory() {
        return this.spanFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSpanFactory(ISpanFactory spanFactory) {
        void var1_1;
        this.spanFactory = var1_1;
    }

    public static interface BeforeSendCallback {
        public SentryEvent execute(SentryEvent var1, Hint var2);
    }

    public static interface BeforeBreadcrumbCallback {
        public Breadcrumb execute(Breadcrumb var1, Hint var2);
    }

    public static final class Proxy {
        private String host;
        private String port;
        private String user;
        private String pass;
        private Proxy.Type type;

        public Proxy() {
            this(null, null, null, null, null);
        }

        /*
         * WARNING - void declaration
         */
        public Proxy(String host, String port, String user, String pass) {
            this((String)var1_1, (String)var2_2, null, (String)var3_3, pass);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Proxy(String host, String port, Proxy.Type type, String user, String pass) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.host = var1_1;
            this.port = var2_2;
            this.type = var3_3;
            this.user = user;
            this.pass = pass;
        }

        public final String getHost() {
            return this.host;
        }

        public final String getPort() {
            return this.port;
        }

        public final String getUser() {
            return this.user;
        }

        public final String getPass() {
            return this.pass;
        }

        public final Proxy.Type getType() {
            return this.type;
        }
    }

    public static interface TracesSamplerCallback {
        public Double sample(SamplingContext var1);
    }

    public static final class RequestSize
    extends Enum<RequestSize> {
        public static final /* enum */ RequestSize NONE = new RequestSize();
        public static final /* enum */ RequestSize SMALL = new RequestSize();
        public static final /* enum */ RequestSize MEDIUM = new RequestSize();
        public static final /* enum */ RequestSize ALWAYS = new RequestSize();
        private static final /* synthetic */ RequestSize[] $VALUES;

        public static RequestSize valueOf(String name) {
            String string;
            return Enum.valueOf(RequestSize.class, string);
        }

        private static /* synthetic */ RequestSize[] $values() {
            return new RequestSize[]{NONE, SMALL, MEDIUM, ALWAYS};
        }

        static {
            $VALUES = RequestSize.$values();
        }
    }

    public static interface ProfilesSamplerCallback {
        public Double sample(SamplingContext var1);
    }

    public static interface BeforeEnvelopeCallback {
        public void execute(SentryEnvelope var1, Hint var2);
    }

    public static final class Cron {
        private Long defaultCheckinMargin;
        private Long defaultMaxRuntime;
        private String defaultTimezone;
        private Long defaultFailureIssueThreshold;
        private Long defaultRecoveryThreshold;

        public final Long getDefaultCheckinMargin() {
            return this.defaultCheckinMargin;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultCheckinMargin(Long defaultCheckinMargin) {
            void var1_1;
            this.defaultCheckinMargin = var1_1;
        }

        public final Long getDefaultMaxRuntime() {
            return this.defaultMaxRuntime;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultMaxRuntime(Long defaultMaxRuntime) {
            void var1_1;
            this.defaultMaxRuntime = var1_1;
        }

        public final String getDefaultTimezone() {
            return this.defaultTimezone;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultTimezone(String defaultTimezone) {
            void var1_1;
            this.defaultTimezone = var1_1;
        }

        public final Long getDefaultFailureIssueThreshold() {
            return this.defaultFailureIssueThreshold;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultFailureIssueThreshold(Long defaultFailureIssueThreshold) {
            void var1_1;
            this.defaultFailureIssueThreshold = var1_1;
        }

        public final Long getDefaultRecoveryThreshold() {
            return this.defaultRecoveryThreshold;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultRecoveryThreshold(Long defaultRecoveryThreshold) {
            void var1_1;
            this.defaultRecoveryThreshold = var1_1;
        }
    }
}

