/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryPackage;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SentryIntegrationPackageStorage {
    private static volatile SentryIntegrationPackageStorage INSTANCE;
    private static final AutoClosableReentrantLock staticLock;
    private static volatile Boolean mixedVersionsDetected;
    private static final AutoClosableReentrantLock mixedVersionsLock;
    private final Set<String> integrations = new CopyOnWriteArraySet<String>();
    private final Set<SentryPackage> packages = new CopyOnWriteArraySet<SentryPackage>();

    /*
     * WARNING - void declaration
     */
    public static SentryIntegrationPackageStorage getInstance() {
        if (INSTANCE == null) {
            ISentryLifecycleToken ignored = staticLock.acquire();
            try {
                if (INSTANCE == null) {
                    INSTANCE = new SentryIntegrationPackageStorage();
                }
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var0;
                        var0.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return INSTANCE;
    }

    private SentryIntegrationPackageStorage() {
    }

    /*
     * WARNING - void declaration
     */
    public final void addIntegration(String integration) {
        void var1_1;
        Objects.requireNonNull(integration, "integration is required.");
        this.integrations.add((String)var1_1);
    }

    public final Set<String> getIntegrations() {
        return this.integrations;
    }

    /*
     * WARNING - void declaration
     */
    public final void addPackage(String name, String version) {
        void var2_3;
        Objects.requireNonNull(name, "name is required.");
        Objects.requireNonNull(version, "version is required.");
        SentryPackage newPackage = new SentryPackage(name, (String)var2_3);
        this.packages.add(newPackage);
        ISentryLifecycleToken ignored = mixedVersionsLock.acquire();
        try {
            mixedVersionsDetected = null;
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public final Set<SentryPackage> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkForMixedVersions(ILogger logger) {
        Boolean mixedVersionsDetectedBefore = mixedVersionsDetected;
        if (mixedVersionsDetectedBefore != null) {
            return mixedVersionsDetectedBefore;
        }
        ISentryLifecycleToken ignored = mixedVersionsLock.acquire();
        try {
            void var3_4;
            boolean mixedVersionsDetectedThisCheck = false;
            for (SentryPackage pkg : this.packages) {
                if (!pkg.getName().startsWith("maven:io.sentry:") || "8.8.0".equalsIgnoreCase(pkg.getVersion())) continue;
                logger.log(SentryLevel.ERROR, "The Sentry SDK has been configured with mixed versions. Expected %s to match core SDK version %s but was %s", pkg.getName(), "8.8.0", pkg.getVersion());
                mixedVersionsDetectedThisCheck = true;
            }
            if (mixedVersionsDetectedThisCheck) {
                void var1_1;
                logger.log(SentryLevel.ERROR, "^^^^^^^^^^^^^^^^^^^^^^^^^^^^", new Object[0]);
                logger.log(SentryLevel.ERROR, "^^^^^^^^^^^^^^^^^^^^^^^^^^^^", new Object[0]);
                logger.log(SentryLevel.ERROR, "^^^^^^^^^^^^^^^^^^^^^^^^^^^^", new Object[0]);
                var1_1.log(SentryLevel.ERROR, "^^^^^^^^^^^^^^^^^^^^^^^^^^^^", new Object[0]);
            }
            mixedVersionsDetected = mixedVersionsDetectedThisCheck;
            void var4_7 = var3_4;
            if (ignored != null) {
                ignored.close();
            }
            return (boolean)var4_7;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    static {
        staticLock = new AutoClosableReentrantLock();
        mixedVersionsDetected = null;
        mixedVersionsLock = new AutoClosableReentrantLock();
    }
}

