/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class SentryExecutorService
implements ISentryExecutorService {
    private final ScheduledExecutorService executorService;
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    SentryExecutorService(ScheduledExecutorService executorService) {
        void var1_1;
        this.executorService = var1_1;
    }

    public SentryExecutorService() {
        this(Executors.newSingleThreadScheduledExecutor(new SentryExecutorServiceThreadFactory()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable runnable) {
        void var1_1;
        return this.executorService.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> schedule(Runnable runnable, long delayMillis) {
        void var2_2;
        void var1_1;
        return this.executorService.schedule((Runnable)var1_1, (long)var2_2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(long timeoutMillis) {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
                try {
                    void var1_1;
                    if (!this.executorService.awaitTermination((long)var1_1, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var3_3;
                    var3_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isClosed() {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            boolean bl = this.executorService.isShutdown();
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private static final class SentryExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        private SentryExecutorServiceThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(Runnable r) {
            void var1_1;
            Thread ret = new Thread(r, "SentryExecutorServiceThreadFactory-" + this.cnt++);
            ret.setDaemon(true);
            return var1_1;
        }
    }
}

