/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryStackTraceFactory;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.util.Objects;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class SentryExceptionFactory {
    private final SentryStackTraceFactory sentryStackTraceFactory;

    /*
     * WARNING - void declaration
     */
    public SentryExceptionFactory(SentryStackTraceFactory sentryStackTraceFactory) {
        void var1_1;
        this.sentryStackTraceFactory = (SentryStackTraceFactory)Objects.requireNonNull(var1_1, "The SentryStackTraceFactory is required.");
    }

    /*
     * WARNING - void declaration
     */
    public final List<SentryException> getSentryExceptions(Throwable throwable) {
        void var1_1;
        SentryExceptionFactory sentryExceptionFactory = this;
        return sentryExceptionFactory.getSentryExceptions(sentryExceptionFactory.extractExceptionQueue((Throwable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private List<SentryException> getSentryExceptions(Deque<SentryException> exceptions) {
        void var1_1;
        return new ArrayList<SentryException>((Collection<SentryException>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SentryException getSentryException(Throwable throwable, Mechanism exceptionMechanism, Long threadId, List<SentryStackFrame> frames, boolean snapshot) {
        void var1_1;
        void var2_2;
        void var3_3;
        String exceptionPackageName;
        Package exceptionPackage = throwable.getClass().getPackage();
        String fullClassName = throwable.getClass().getName();
        SentryException exception = new SentryException();
        String exceptionMessage = throwable.getMessage();
        String exceptionClassName = exceptionPackage != null ? fullClassName.replace(exceptionPackage.getName() + ".", "") : fullClassName;
        String string = exceptionPackageName = exceptionPackage != null ? exceptionPackage.getName() : null;
        if (frames != null && !frames.isEmpty()) {
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            if (snapshot) {
                sentryStackTrace.setSnapshot(Boolean.TRUE);
            }
            exception.setStacktrace(sentryStackTrace);
        }
        exception.setThreadId((Long)var3_3);
        exception.setType(exceptionClassName);
        exception.setMechanism((Mechanism)var2_2);
        exception.setModule(exceptionPackageName);
        exception.setValue((String)var1_1);
        return exception;
    }

    /*
     * WARNING - void declaration
     */
    final Deque<SentryException> extractExceptionQueue(Throwable throwable) {
        void var1_1;
        return this.extractExceptionQueueInternal((Throwable)var1_1, new AtomicInteger(-1), new HashSet<Throwable>(), new ArrayDeque<SentryException>(), null);
    }

    /*
     * WARNING - void declaration
     */
    final Deque<SentryException> extractExceptionQueueInternal(Throwable throwable, AtomicInteger exceptionId, HashSet<Throwable> circularityDetector, Deque<SentryException> exceptions, String mechanismTypeOverride) {
        int parentId = exceptionId.get();
        for (Throwable currentThrowable = throwable; currentThrowable != null && circularityDetector.add(currentThrowable); currentThrowable = currentThrowable.getCause()) {
            Thread thread;
            Mechanism exceptionMechanism;
            String mechanismType;
            boolean snapshot = false;
            String string = mechanismType = mechanismTypeOverride == null ? "chained" : mechanismTypeOverride;
            if (currentThrowable instanceof ExceptionMechanismException) {
                ExceptionMechanismException exceptionMechanismThrowable = (ExceptionMechanismException)currentThrowable;
                exceptionMechanism = exceptionMechanismThrowable.getExceptionMechanism();
                currentThrowable = exceptionMechanismThrowable.getThrowable();
                thread = exceptionMechanismThrowable.getThread();
                snapshot = exceptionMechanismThrowable.isSnapshot();
            } else {
                exceptionMechanism = new Mechanism();
                thread = Thread.currentThread();
            }
            boolean includeSentryFrames = Boolean.FALSE.equals(exceptionMechanism.isHandled());
            List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(currentThrowable.getStackTrace(), includeSentryFrames);
            SentryException exception = this.getSentryException(currentThrowable, exceptionMechanism, thread.getId(), frames, snapshot);
            exceptions.addFirst(exception);
            if (exceptionMechanism.getType() == null) {
                exceptionMechanism.setType(mechanismType);
            }
            if (exceptionId.get() >= 0) {
                exceptionMechanism.setParentId(parentId);
            }
            int currentExceptionId = exceptionId.incrementAndGet();
            exceptionMechanism.setExceptionId(currentExceptionId);
            Throwable[] suppressed = currentThrowable.getSuppressed();
            if (suppressed != null && suppressed.length > 0) {
                void var1_1;
                for (void suppressedThrowable : var1_1) {
                    this.extractExceptionQueueInternal((Throwable)suppressedThrowable, exceptionId, circularityDetector, exceptions, "suppressed");
                }
            }
            parentId = currentExceptionId;
            Object var5_5 = null;
        }
        return exceptions;
    }
}

