/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryValues;
import io.sentry.protocol.Message;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryThread;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentryEvent
extends SentryBaseEvent
implements JsonSerializable {
    private Date timestamp;
    private Message message;
    private String logger;
    private SentryValues<SentryThread> threads;
    private SentryValues<SentryException> exception;
    private SentryLevel level;
    private String transaction;
    private List<String> fingerprint;
    private Map<String, Object> unknown;
    private Map<String, String> modules;

    /*
     * WARNING - void declaration
     */
    SentryEvent(SentryId eventId, Date timestamp) {
        super((SentryId)var1_1);
        void var2_2;
        void var1_1;
        this.timestamp = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEvent(Throwable throwable) {
        this();
        void var1_1;
        this.throwable = var1_1;
    }

    public SentryEvent() {
        this(new SentryId(), DateUtils.getCurrentDateTime());
    }

    public final Message getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMessage(Message message) {
        void var1_1;
        this.message = var1_1;
    }

    public final String getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLogger(String logger) {
        void var1_1;
        this.logger = var1_1;
    }

    public final List<SentryThread> getThreads() {
        if (this.threads != null) {
            return this.threads.getValues();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setThreads(List<SentryThread> threads) {
        void var1_1;
        this.threads = new SentryValues(var1_1);
    }

    public final List<SentryException> getExceptions() {
        if (this.exception == null) {
            return null;
        }
        return this.exception.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public final void setExceptions(List<SentryException> exception) {
        void var1_1;
        this.exception = new SentryValues(var1_1);
    }

    public final SentryLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(SentryLevel level) {
        void var1_1;
        this.level = var1_1;
    }

    public final String getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransaction(String transaction) {
        void var1_1;
        this.transaction = var1_1;
    }

    public final List<String> getFingerprints() {
        return this.fingerprint;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFingerprints(List<String> fingerprint) {
        void var1_1;
        this.fingerprint = fingerprint != null ? new ArrayList(var1_1) : null;
    }

    final Map<String, String> getModules() {
        return this.modules;
    }

    /*
     * WARNING - void declaration
     */
    public final void setModules(Map<String, String> modules) {
        void var1_1;
        this.modules = CollectionUtils.newHashMap(var1_1);
    }

    public final boolean isCrashed() {
        return this.getUnhandledException() != null;
    }

    /*
     * WARNING - void declaration
     */
    public final SentryException getUnhandledException() {
        if (this.exception != null) {
            for (SentryException e : this.exception.getValues()) {
                void var2_2;
                if (e.getMechanism() == null || e.getMechanism().isHandled() == null || e.getMechanism().isHandled().booleanValue()) continue;
                return var2_2;
            }
        }
        return null;
    }

    public final boolean isErrored() {
        return this.exception != null && !this.exception.getValues().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("timestamp").value(logger, this.timestamp);
        if (this.message != null) {
            writer.name("message").value(logger, this.message);
        }
        if (this.logger != null) {
            writer.name("logger").value(this.logger);
        }
        if (this.threads != null && !this.threads.getValues().isEmpty()) {
            writer.name("threads");
            writer.beginObject();
            writer.name("values").value(logger, this.threads.getValues());
            writer.endObject();
        }
        if (this.exception != null && !this.exception.getValues().isEmpty()) {
            writer.name("exception");
            writer.beginObject();
            writer.name("values").value(logger, this.exception.getValues());
            writer.endObject();
        }
        if (this.level != null) {
            writer.name("level").value(logger, this.level);
        }
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        if (this.fingerprint != null) {
            writer.name("fingerprint").value(logger, this.fingerprint);
        }
        if (this.modules != null) {
            writer.name("modules").value(logger, this.modules);
        }
        new SentryBaseEvent.Serializer().serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$002(SentryEvent x0, Date x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Message access$102(SentryEvent x0, Message x1) {
        void var1_1;
        x0.message = var1_1;
        return x0.message;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(SentryEvent x0, String x1) {
        void var1_1;
        x0.logger = var1_1;
        return x0.logger;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryValues access$302(SentryEvent x0, SentryValues x1) {
        void var1_1;
        x0.threads = var1_1;
        return x0.threads;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryValues access$402(SentryEvent x0, SentryValues x1) {
        void var1_1;
        x0.exception = var1_1;
        return x0.exception;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryLevel access$502(SentryEvent x0, SentryLevel x1) {
        void var1_1;
        x0.level = var1_1;
        return x0.level;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(SentryEvent x0, String x1) {
        void var1_1;
        x0.transaction = var1_1;
        return x0.transaction;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$702(SentryEvent x0, List x1) {
        void var1_1;
        x0.fingerprint = var1_1;
        return x0.fingerprint;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$802(SentryEvent x0, Map x1) {
        void var1_1;
        x0.modules = var1_1;
        return x0.modules;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryEvent deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            SentryEvent event = new SentryEvent();
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block22: while (reader.peek() == JsonToken.NAME) {
                void var6_6;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "timestamp": {
                        Date deserializedTimestamp = reader.nextDateOrNull(logger);
                        if (deserializedTimestamp == null) continue block22;
                        SentryEvent.access$002(event, deserializedTimestamp);
                        continue block22;
                    }
                    case "message": {
                        SentryEvent.access$102(event, reader.nextOrNull(logger, new Message.Deserializer()));
                        continue block22;
                    }
                    case "logger": {
                        SentryEvent.access$202(event, reader.nextStringOrNull());
                        continue block22;
                    }
                    case "threads": {
                        reader.beginObject();
                        reader.nextName();
                        SentryEvent.access$302(event, new SentryValues<SentryThread>(reader.nextListOrNull(logger, new SentryThread.Deserializer())));
                        reader.endObject();
                        continue block22;
                    }
                    case "exception": {
                        reader.beginObject();
                        reader.nextName();
                        SentryEvent.access$402(event, new SentryValues<SentryException>(reader.nextListOrNull(logger, new SentryException.Deserializer())));
                        reader.endObject();
                        continue block22;
                    }
                    case "level": {
                        SentryEvent.access$502(event, reader.nextOrNull(logger, new SentryLevel.Deserializer()));
                        continue block22;
                    }
                    case "transaction": {
                        SentryEvent.access$602(event, reader.nextStringOrNull());
                        continue block22;
                    }
                    case "fingerprint": {
                        List deserializedFingerprint = (List)reader.nextObjectOrNull();
                        if (deserializedFingerprint == null) continue block22;
                        SentryEvent.access$702(event, deserializedFingerprint);
                        continue block22;
                    }
                    case "modules": {
                        Map deserializedModules = (Map)reader.nextObjectOrNull();
                        SentryEvent.access$802(event, CollectionUtils.newConcurrentHashMap(deserializedModules));
                        continue block22;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event, (String)var6_6, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var6_6);
            }
            event.setUnknown(unknown);
            var1_1.endObject();
            return var3_3;
        }
    }
}

