/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public final class SentryEnvelopeItemHeader
implements JsonSerializable {
    private final String contentType;
    private final String fileName;
    private final String platform;
    private final SentryItemType type;
    private final int length;
    private final Callable<Integer> getLength;
    private final String attachmentType;
    private Map<String, Object> unknown;

    public final SentryItemType getType() {
        return this.type;
    }

    public final int getLength() {
        if (this.getLength != null) {
            try {
                return this.getLength.call();
            }
            catch (Throwable throwable) {
                return -1;
            }
        }
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeItemHeader(SentryItemType type, int length, String contentType, String fileName, String attachmentType, String platform) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.type = (SentryItemType)Objects.requireNonNull(var1_1, "type is required");
        this.contentType = var3_3;
        this.length = var2_2;
        this.fileName = fileName;
        this.getLength = null;
        this.attachmentType = attachmentType;
        this.platform = platform;
    }

    /*
     * WARNING - void declaration
     */
    SentryEnvelopeItemHeader(SentryItemType type, Callable<Integer> getLength, String contentType, String fileName, String attachmentType) {
        this((SentryItemType)var1_1, (Callable<Integer>)var2_2, (String)var3_3, fileName, attachmentType, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    SentryEnvelopeItemHeader(SentryItemType type, Callable<Integer> getLength, String contentType, String fileName, String attachmentType, String platform) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.type = (SentryItemType)Objects.requireNonNull(var1_1, "type is required");
        this.contentType = var3_3;
        this.length = -1;
        this.fileName = fileName;
        this.getLength = var2_2;
        this.attachmentType = attachmentType;
        this.platform = platform;
    }

    /*
     * WARNING - void declaration
     */
    SentryEnvelopeItemHeader(SentryItemType type, Callable<Integer> getLength, String contentType, String fileName) {
        this((SentryItemType)var1_1, (Callable<Integer>)var2_2, (String)var3_3, fileName, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.contentType != null) {
            writer.name("content_type").value(this.contentType);
        }
        if (this.fileName != null) {
            writer.name("filename").value(this.fileName);
        }
        writer.name("type").value(logger, this.type);
        if (this.attachmentType != null) {
            writer.name("attachment_type").value(this.attachmentType);
        }
        if (this.platform != null) {
            writer.name("platform").value(this.platform);
        }
        writer.name("length").value(this.getLength());
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeItemHeader> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryEnvelopeItemHeader deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            String contentType = null;
            String fileName = null;
            SentryItemType type = null;
            int length = 0;
            String attachmentType = null;
            String platform = null;
            HashMap<String, Object> unknown = null;
            block16: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "content_type": {
                        contentType = reader.nextStringOrNull();
                        continue block16;
                    }
                    case "filename": {
                        fileName = reader.nextStringOrNull();
                        continue block16;
                    }
                    case "type": {
                        type = reader.nextOrNull(logger, new SentryItemType.Deserializer());
                        continue block16;
                    }
                    case "length": {
                        length = reader.nextInt();
                        continue block16;
                    }
                    case "attachment_type": {
                        attachmentType = reader.nextStringOrNull();
                        continue block16;
                    }
                    case "platform": {
                        platform = reader.nextStringOrNull();
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (type == null) {
                void var2_2;
                throw this.missingRequiredFieldException("type", (ILogger)var2_2);
            }
            SentryEnvelopeItemHeader sentryEnvelopeItemHeader = new SentryEnvelopeItemHeader(type, length, (String)var3_3, fileName, attachmentType, platform);
            sentryEnvelopeItemHeader.setUnknown(unknown);
            var1_1.endObject();
            return sentryEnvelopeItemHeader;
        }

        /*
         * WARNING - void declaration
         */
        private Exception missingRequiredFieldException(String field, ILogger logger) {
            void var3_3;
            void var1_1;
            void var2_2;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var2_2.log(SentryLevel.ERROR, (String)var1_1, exception);
            return var3_3;
        }
    }
}

