/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.AsyncHttpTransportFactory;
import io.sentry.Attachment;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Baggage;
import io.sentry.Breadcrumb;
import io.sentry.DataCategory;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.IScope;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.ITransportFactory;
import io.sentry.NoOpTransportFactory;
import io.sentry.ProfilingTraceData;
import io.sentry.PropagationContext;
import io.sentry.RequestDetailsResolver;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.TransactionContext;
import io.sentry.clientreport.DiscardReason;
import io.sentry.exception.SentryEnvelopeException;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.TransactionEnd;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ITransport;
import io.sentry.util.ErrorUtils;
import io.sentry.util.ExceptionUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import io.sentry.util.Random;
import io.sentry.util.SentryRandom;
import io.sentry.util.TracingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SentryClient
implements ISentryClient {
    private boolean enabled;
    private final SentryOptions options;
    private final ITransport transport;
    private final SortBreadcrumbsByDate sortBreadcrumbsByDate = new SortBreadcrumbsByDate();

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public SentryClient(SentryOptions options) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.enabled = true;
        ITransportFactory transportFactory = options.getTransportFactory();
        if (transportFactory instanceof NoOpTransportFactory) {
            transportFactory = new AsyncHttpTransportFactory();
            options.setTransportFactory(transportFactory);
        }
        RequestDetailsResolver requestDetailsResolver = new RequestDetailsResolver(options);
        this.transport = var2_2.create((SentryOptions)var1_1, var3_3.resolve());
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", var1_1.getEventId());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, IScope scope, Hint hint) {
        Objects.requireNonNull(event, "SentryEvent is required.");
        if (hint == null) {
            hint = new Hint();
        }
        if (this.shouldApplyScopeData(event, hint)) {
            this.addScopeAttachmentsToHint(scope, hint);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (event != null) {
            Throwable eventThrowable = event.getThrowable();
            if (eventThrowable != null && ExceptionUtils.isIgnored(this.options.getIgnoredExceptionsForType(), eventThrowable)) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as the exception %s is ignored", eventThrowable.getClass());
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
                return SentryId.EMPTY_ID;
            }
            if (ErrorUtils.isIgnored(this.options.getIgnoredErrors(), event)) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as it matched a string/pattern in ignoredErrors", event.getMessage());
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
                return SentryId.EMPTY_ID;
            }
        }
        if (this.shouldApplyScopeData(event, hint) && (event = this.applyScope(event, scope, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by applyScope", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        if ((event = this.processEvent(event, hint, this.options.getEventProcessors())) != null && (event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.BEFORE_SEND, DataCategory.Error);
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        Session sessionBeforeUpdate = scope != null ? scope.withSession(session -> {}) : null;
        Session session2 = null;
        if (event != null) {
            if (sessionBeforeUpdate == null || !sessionBeforeUpdate.isTerminated()) {
                session2 = this.updateSessionData(event, hint, scope);
            }
            if (!this.sample()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.SAMPLE_RATE, DataCategory.Error);
                event = null;
            }
        }
        boolean shouldSendSessionUpdate = this.shouldSendSessionUpdateForDroppedEvent(sessionBeforeUpdate, session2);
        if (event == null && !shouldSendSessionUpdate) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Not sending session update for dropped event as it did not cause the session health to change.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        SentryId sentryId = SentryId.EMPTY_ID;
        if (event != null && event.getEventId() != null) {
            sentryId = event.getEventId();
        }
        boolean isBackfillable2 = HintUtils.hasType(hint, Backfillable.class);
        if (event != null && !isBackfillable2 && (event.isErrored() || event.isCrashed())) {
            this.options.getReplayController().captureReplay(event.isCrashed());
        }
        try {
            TraceContext traceContext = null;
            if (isBackfillable2) {
                if (event != null) {
                    Baggage isBackfillable2 = Baggage.fromEvent(event, this.options);
                    traceContext = isBackfillable2.toTraceContext();
                }
            } else if (scope != null) {
                Object transaction = scope.getTransaction();
                if (transaction != null) {
                    traceContext = transaction.traceContext();
                } else {
                    transaction = TracingUtils.maybeUpdateBaggage(scope, this.options);
                    traceContext = ((PropagationContext)transaction).traceContext();
                }
            }
            boolean transaction = event != null;
            List<Attachment> attachments = transaction ? this.getAttachments(hint) : null;
            SentryEnvelope envelope = this.buildEnvelope(event, attachments, session2, traceContext, null);
            hint.clear();
            if (envelope != null) {
                void var1_1;
                sentryId = this.sendEnvelope((SentryEnvelope)var1_1, hint);
            }
        }
        catch (SentryEnvelopeException | IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing event %s failed.", sentryId);
            sentryId = SentryId.EMPTY_ID;
        }
        if (scope != null) {
            void var3_3;
            void var2_2;
            this.finalizeTransaction((IScope)var2_2, (Hint)var3_3);
        }
        return sentryId;
    }

    /*
     * WARNING - void declaration
     */
    private void finalizeTransaction(IScope scope, Hint hint) {
        ITransaction transaction = scope.getTransaction();
        if (transaction != null && HintUtils.hasType(hint, TransactionEnd.class)) {
            void var1_1;
            Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
            if (sentrySdkHint instanceof DiskFlushNotification) {
                void var2_2;
                void var3_3;
                ((DiskFlushNotification)var3_3).setFlushable(transaction.getEventId());
                transaction.forceFinish(SpanStatus.ABORTED, false, (Hint)var2_2);
                return;
            }
            var1_1.forceFinish(SpanStatus.ABORTED, false, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addScopeAttachmentsToHint(IScope scope, Hint hint) {
        if (scope != null) {
            void var1_1;
            void var2_2;
            var2_2.addAttachments(var1_1.getAttachments());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldSendSessionUpdateForDroppedEvent(Session sessionBeforeUpdate, Session sessionAfterUpdate) {
        void var1_1;
        void var2_3;
        if (sessionAfterUpdate == null) {
            return false;
        }
        if (sessionBeforeUpdate == null) {
            return true;
        }
        boolean bl = sessionAfterUpdate.getStatus() == Session.State.Crashed && sessionBeforeUpdate.getStatus() != Session.State.Crashed;
        if (bl) {
            return true;
        }
        boolean bl2 = var2_3.errorCount() > 0 && var1_1.errorCount() <= 0;
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    private List<Attachment> getAttachments(Hint hint) {
        void var2_2;
        Attachment threadDump;
        Attachment viewHierarchy;
        List<Attachment> attachments = hint.getAttachments();
        Attachment screenshot = hint.getScreenshot();
        if (screenshot != null) {
            attachments.add(screenshot);
        }
        if ((viewHierarchy = hint.getViewHierarchy()) != null) {
            void var3_3;
            attachments.add((Attachment)var3_3);
        }
        if ((threadDump = hint.getThreadDump()) != null) {
            void var1_1;
            attachments.add((Attachment)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelope buildEnvelope(SentryBaseEvent event, List<Attachment> attachments, Session session, TraceContext traceContext, ProfilingTraceData profilingTraceData) throws IOException, SentryEnvelopeException {
        SentryId sentryId = null;
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        if (event != null) {
            SentryEnvelopeItem eventItem = SentryEnvelopeItem.fromEvent(this.options.getSerializer(), event);
            envelopeItems.add(eventItem);
            sentryId = event.getEventId();
        }
        if (session != null) {
            void var3_3;
            SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession(this.options.getSerializer(), (Session)var3_3);
            envelopeItems.add(sessionItem);
        }
        if (profilingTraceData != null) {
            SentryEnvelopeItem profilingTraceItem = SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, this.options.getMaxTraceFileSize(), this.options.getSerializer());
            envelopeItems.add(profilingTraceItem);
            if (sentryId == null) {
                sentryId = new SentryId(profilingTraceData.getProfileId());
            }
        }
        if (attachments != null) {
            void var2_2;
            for (Attachment attachment : var2_2) {
                void var1_1;
                SentryEnvelopeItem attachmentItem = SentryEnvelopeItem.fromAttachment(this.options.getSerializer(), this.options.getLogger(), attachment, this.options.getMaxAttachmentSize());
                envelopeItems.add((SentryEnvelopeItem)var1_1);
            }
        }
        if (!envelopeItems.isEmpty()) {
            SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(sentryId, this.options.getSdkVersion(), traceContext);
            return new SentryEnvelope(envelopeHeader, envelopeItems);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent processEvent(SentryEvent event, Hint hint, List<EventProcessor> eventProcessors) {
        void var1_1;
        for (EventProcessor processor : eventProcessors) {
            try {
                boolean isBackfillingProcessor = processor instanceof BackfillingEventProcessor;
                boolean isBackfillable = HintUtils.hasType(hint, Backfillable.class);
                if (isBackfillable && isBackfillingProcessor) {
                    event = processor.process(event, hint);
                } else if (!isBackfillable && !isBackfillingProcessor) {
                    event = processor.process(event, hint);
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing event by processor: %s", processor.getClass().getName());
            }
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by a processor: %s", processor.getClass().getName());
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            break;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Session updateSessionData(SentryEvent event, Hint hint, IScope scope) {
        Session clonedSession = null;
        if (HintUtils.shouldApplyScopeData(hint)) {
            if (scope != null) {
                void var2_2;
                void var1_1;
                void var3_3;
                clonedSession = var3_3.withSession(arg_0 -> this.lambda$updateSessionData$1((SentryEvent)var1_1, (Hint)var2_2, arg_0));
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
            }
        }
        return clonedSession;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope(SentryEnvelope envelope, Hint hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        if (hint == null) {
            hint = new Hint();
        }
        try {
            void var2_3;
            hint.clear();
            return this.sendEnvelope(envelope, (Hint)var2_3);
        }
        catch (IOException e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", (Throwable)var1_2);
            return SentryId.EMPTY_ID;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryId sendEnvelope(SentryEnvelope envelope, Hint hint) throws IOException {
        void var1_1;
        SentryOptions.BeforeEnvelopeCallback beforeEnvelopeCallback = this.options.getBeforeEnvelopeCallback();
        if (beforeEnvelopeCallback != null) {
            try {
                beforeEnvelopeCallback.execute(envelope, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeEnvelope callback threw an exception.", e);
            }
        }
        SentryIntegrationPackageStorage.getInstance().checkForMixedVersions(this.options.getLogger());
        if (hint == null) {
            this.transport.send(envelope);
        } else {
            void var2_2;
            this.transport.send(envelope, (Hint)var2_2);
        }
        SentryId id = var1_1.getHeader().getEventId();
        if (id != null) {
            void var3_3;
            return var3_3;
        }
        return SentryId.EMPTY_ID;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent applyScope(SentryEvent event, IScope scope, Hint hint) {
        void var1_1;
        if (scope != null) {
            void var2_2;
            void var3_3;
            this.applyScope(event, scope);
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransactionName());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
            ISpan span = scope.getSpan();
            if (event.getContexts().getTrace() == null) {
                if (span == null) {
                    event.getContexts().setTrace(TransactionContext.fromPropagationContext(scope.getPropagationContext()));
                } else {
                    event.getContexts().setTrace(span.getSpanContext());
                }
            }
            event = this.processEvent(event, (Hint)var3_3, var2_2.getEventProcessors());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends SentryBaseEvent> T applyScope(T sentryBaseEvent, IScope scope) {
        void var1_1;
        if (scope != null) {
            if (sentryBaseEvent.getRequest() == null) {
                sentryBaseEvent.setRequest(scope.getRequest());
            }
            if (sentryBaseEvent.getUser() == null) {
                sentryBaseEvent.setUser(scope.getUser());
            }
            if (sentryBaseEvent.getTags() == null) {
                sentryBaseEvent.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (sentryBaseEvent.getTags().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (sentryBaseEvent.getBreadcrumbs() == null) {
                sentryBaseEvent.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                this.sortBreadcrumbsByDate(sentryBaseEvent, scope.getBreadcrumbs());
            }
            if (sentryBaseEvent.getExtras() == null) {
                sentryBaseEvent.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (sentryBaseEvent.getExtras().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            Contexts contexts = sentryBaseEvent.getContexts();
            for (Map.Entry<String, Object> entry : new Contexts(scope.getContexts()).entrySet()) {
                void var2_2;
                if (contexts.containsKey(entry.getKey())) continue;
                contexts.put(entry.getKey(), var2_2.getValue());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void sortBreadcrumbsByDate(SentryBaseEvent event, Collection<Breadcrumb> breadcrumbs) {
        List<Breadcrumb> sortedBreadcrumbs = event.getBreadcrumbs();
        if (sortedBreadcrumbs != null && !breadcrumbs.isEmpty()) {
            void var1_1;
            void var2_2;
            sortedBreadcrumbs.addAll((Collection<Breadcrumb>)var2_2);
            Collections.sort(var1_1, this.sortBreadcrumbsByDate);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent executeBeforeSend(SentryEvent event, Hint hint) {
        Object var1_1;
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                void var2_3;
                void var3_4;
                event = var3_4.execute(event, (Hint)var2_3);
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", (Throwable)var1_2);
                var1_1 = null;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(boolean isRestarting) {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.flush(isRestarting ? 0L : this.options.getShutdownTimeoutMillis());
            this.transport.close(isRestarting);
        }
        catch (IOException e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", (Throwable)var1_2);
        }
        for (EventProcessor eventProcessor : this.options.getEventProcessors()) {
            if (!(eventProcessor instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)eventProcessor)).close();
            }
            catch (IOException e) {
                void var3_5;
                void var2_4;
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the event processor {}.", var2_4, var3_5);
            }
        }
        this.enabled = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        void var1_1;
        this.transport.flush((long)var1_1);
    }

    @Override
    public final boolean isHealthy() {
        return this.transport.isHealthy();
    }

    /*
     * WARNING - void declaration
     */
    private boolean sample() {
        Random random;
        Random random2 = random = this.options.getSampleRate() == null ? null : SentryRandom.current();
        if (this.options.getSampleRate() != null && random != null) {
            void var1_1;
            double d = this.options.getSampleRate();
            return !(d < var1_1.nextDouble());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$updateSessionData$1(SentryEvent event, Hint hint, Session session) {
        if (session != null) {
            void var2_2;
            Session.State status = null;
            if (event.isCrashed()) {
                status = Session.State.Crashed;
            }
            boolean crashedOrErrored = false;
            if (Session.State.Crashed == status || event.isErrored()) {
                crashedOrErrored = true;
            }
            String userAgent = null;
            if (event.getRequest() != null && event.getRequest().getHeaders() != null && event.getRequest().getHeaders().containsKey("user-agent")) {
                userAgent = event.getRequest().getHeaders().get("user-agent");
            }
            Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
            String abnormalMechanism = null;
            if (sentrySdkHint instanceof AbnormalExit) {
                void var1_1;
                abnormalMechanism = ((AbnormalExit)var1_1).mechanism();
                status = Session.State.Abnormal;
            }
            if (session.update(status, userAgent, crashedOrErrored, (String)var2_2) && session.isTerminated()) {
                void var3_3;
                var3_3.end();
            }
            return;
        }
        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
    }

    private static final class SortBreadcrumbsByDate
    implements Comparator<Breadcrumb> {
        private SortBreadcrumbsByDate() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Breadcrumb b1, Breadcrumb b2) {
            void var2_2;
            return b1.getTimestamp().compareTo(var2_2.getTimestamp());
        }
    }
}

