/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.ProfileLifecycle;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.util.SentryRandom;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentryAppStartProfilingOptions
implements JsonSerializable {
    boolean profileSampled;
    Double profileSampleRate;
    boolean traceSampled;
    Double traceSampleRate;
    String profilingTracesDirPath;
    boolean isProfilingEnabled;
    boolean isContinuousProfilingEnabled;
    int profilingTracesHz;
    boolean continuousProfileSampled;
    boolean isEnableAppStartProfiling;
    boolean isStartProfilerOnAppStart;
    ProfileLifecycle profileLifecycle;
    private Map<String, Object> unknown;

    public SentryAppStartProfilingOptions() {
        this.traceSampled = false;
        this.traceSampleRate = null;
        this.profileSampled = false;
        this.profileSampleRate = null;
        this.continuousProfileSampled = false;
        this.profilingTracesDirPath = null;
        this.isProfilingEnabled = false;
        this.isContinuousProfilingEnabled = false;
        this.profileLifecycle = ProfileLifecycle.MANUAL;
        this.profilingTracesHz = 0;
        this.isEnableAppStartProfiling = true;
        this.isStartProfilerOnAppStart = false;
    }

    /*
     * WARNING - void declaration
     */
    SentryAppStartProfilingOptions(SentryOptions options, TracesSamplingDecision samplingDecision) {
        void var1_1;
        void var2_2;
        this.traceSampled = samplingDecision.getSampled();
        this.traceSampleRate = samplingDecision.getSampleRate();
        this.profileSampled = samplingDecision.getProfileSampled();
        this.profileSampleRate = var2_2.getProfileSampleRate();
        this.continuousProfileSampled = options.getInternalTracesSampler().sampleSessionProfile(SentryRandom.current().nextDouble());
        this.profilingTracesDirPath = options.getProfilingTracesDirPath();
        this.isProfilingEnabled = options.isProfilingEnabled();
        this.isContinuousProfilingEnabled = options.isContinuousProfilingEnabled();
        this.profileLifecycle = options.getProfileLifecycle();
        this.profilingTracesHz = options.getProfilingTracesHz();
        this.isEnableAppStartProfiling = options.isEnableAppStartProfiling();
        this.isStartProfilerOnAppStart = var1_1.isStartProfilerOnAppStart();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("profile_sampled").value(logger, this.profileSampled);
        writer.name("profile_sample_rate").value(logger, this.profileSampleRate);
        writer.name("continuous_profile_sampled").value(logger, this.continuousProfileSampled);
        writer.name("trace_sampled").value(logger, this.traceSampled);
        writer.name("trace_sample_rate").value(logger, this.traceSampleRate);
        writer.name("profiling_traces_dir_path").value(logger, this.profilingTracesDirPath);
        writer.name("is_profiling_enabled").value(logger, this.isProfilingEnabled);
        writer.name("is_continuous_profiling_enabled").value(logger, this.isContinuousProfilingEnabled);
        writer.name("profile_lifecycle").value(logger, this.profileLifecycle.name());
        writer.name("profiling_traces_hz").value(logger, this.profilingTracesHz);
        writer.name("is_enable_app_start_profiling").value(logger, this.isEnableAppStartProfiling);
        writer.name("is_start_profiler_on_app_start").value(logger, this.isStartProfilerOnAppStart);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryAppStartProfilingOptions> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final SentryAppStartProfilingOptions deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            SentryAppStartProfilingOptions options = new SentryAppStartProfilingOptions();
            ConcurrentHashMap<String, Object> unknown = null;
            block30: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "profile_sampled": {
                        Boolean profileSampled = reader.nextBooleanOrNull();
                        if (profileSampled == null) continue block30;
                        options.profileSampled = profileSampled;
                        continue block30;
                    }
                    case "profile_sample_rate": {
                        Double profileSampleRate = reader.nextDoubleOrNull();
                        if (profileSampleRate == null) continue block30;
                        options.profileSampleRate = profileSampleRate;
                        continue block30;
                    }
                    case "continuous_profile_sampled": {
                        Boolean continuousProfileSampled = reader.nextBooleanOrNull();
                        if (continuousProfileSampled == null) continue block30;
                        options.continuousProfileSampled = continuousProfileSampled;
                        continue block30;
                    }
                    case "trace_sampled": {
                        Boolean traceSampled = reader.nextBooleanOrNull();
                        if (traceSampled == null) continue block30;
                        options.traceSampled = traceSampled;
                        continue block30;
                    }
                    case "trace_sample_rate": {
                        Double traceSampleRate = reader.nextDoubleOrNull();
                        if (traceSampleRate == null) continue block30;
                        options.traceSampleRate = traceSampleRate;
                        continue block30;
                    }
                    case "profiling_traces_dir_path": {
                        String profilingTracesDirPath = reader.nextStringOrNull();
                        if (profilingTracesDirPath == null) continue block30;
                        options.profilingTracesDirPath = profilingTracesDirPath;
                        continue block30;
                    }
                    case "is_profiling_enabled": {
                        Boolean isProfilingEnabled = reader.nextBooleanOrNull();
                        if (isProfilingEnabled == null) continue block30;
                        options.isProfilingEnabled = isProfilingEnabled;
                        continue block30;
                    }
                    case "is_continuous_profiling_enabled": {
                        Boolean isContinuousProfilingEnabled = reader.nextBooleanOrNull();
                        if (isContinuousProfilingEnabled == null) continue block30;
                        options.isContinuousProfilingEnabled = isContinuousProfilingEnabled;
                        continue block30;
                    }
                    case "profile_lifecycle": {
                        String profileLifecycle = reader.nextStringOrNull();
                        if (profileLifecycle == null) continue block30;
                        try {
                            options.profileLifecycle = ProfileLifecycle.valueOf(profileLifecycle);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            logger.log(SentryLevel.ERROR, "Error when deserializing ProfileLifecycle: " + profileLifecycle, new Object[0]);
                        }
                        continue block30;
                    }
                    case "profiling_traces_hz": {
                        Integer profilingTracesHz = reader.nextIntegerOrNull();
                        if (profilingTracesHz == null) continue block30;
                        options.profilingTracesHz = profilingTracesHz;
                        continue block30;
                    }
                    case "is_enable_app_start_profiling": {
                        Boolean isEnableAppStartProfiling = reader.nextBooleanOrNull();
                        if (isEnableAppStartProfiling == null) continue block30;
                        options.isEnableAppStartProfiling = isEnableAppStartProfiling;
                        continue block30;
                    }
                    case "is_start_profiler_on_app_start": {
                        Boolean isStartProfilerOnAppStart = reader.nextBooleanOrNull();
                        if (isStartProfilerOnAppStart == null) continue block30;
                        options.isStartProfilerOnAppStart = isStartProfilerOnAppStart;
                        continue block30;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var5_5);
            }
            options.setUnknown(unknown);
            var1_1.endObject();
            return var3_3;
        }
    }
}

