/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DefaultScopesStorage;
import io.sentry.DefaultSpanFactory;
import io.sentry.ExternalOptions;
import io.sentry.Hint;
import io.sentry.IOptionsObserver;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.IScopesStorage;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.JavaMemoryCollector;
import io.sentry.NoOpLogger;
import io.sentry.NoOpScopes;
import io.sentry.NoOpScopesStorage;
import io.sentry.PreviousSessionFinalizer;
import io.sentry.SamplingContext;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.ScopeType;
import io.sentry.Scopes;
import io.sentry.ScopesAdapter;
import io.sentry.ScopesStorageFactory;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryClient;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOpenTelemetryMode;
import io.sentry.SentryOptions;
import io.sentry.SystemOutLogger;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.backpressure.BackpressureMonitor;
import io.sentry.backpressure.NoOpBackpressureMonitor;
import io.sentry.cache.EnvelopeCache;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.config.PropertiesProviderFactory;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.sentry.internal.modules.CompositeModulesLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.ManifestModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.internal.modules.ResourcesModulesLoader;
import io.sentry.opentelemetry.OpenTelemetryUtil;
import io.sentry.protocol.SentryId;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.DebugMetaPropertiesApplier;
import io.sentry.util.FileUtils;
import io.sentry.util.InitUtil;
import io.sentry.util.LoadClass;
import io.sentry.util.Platform;
import io.sentry.util.SentryRandom;
import io.sentry.util.thread.IThreadChecker;
import io.sentry.util.thread.NoOpThreadChecker;
import io.sentry.util.thread.ThreadChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class Sentry {
    private static volatile IScopesStorage scopesStorage = NoOpScopesStorage.getInstance();
    private static volatile IScopes rootScopes = NoOpScopes.getInstance();
    private static final IScope globalScope = new Scope(SentryOptions.empty());
    private static volatile boolean globalHubMode = false;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long classCreationTimestamp = System.currentTimeMillis();
    private static final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public static IScopes getCurrentScopes() {
        void var0;
        if (globalHubMode) {
            return rootScopes;
        }
        IScopes scopes = Sentry.getScopesStorage().get();
        if (scopes == null || scopes.isNoOp()) {
            scopes = rootScopes.forkedScopes("getCurrentScopes");
            Sentry.getScopesStorage().set(scopes);
        }
        return var0;
    }

    private static IScopesStorage getScopesStorage() {
        return scopesStorage;
    }

    public static IScopes forkedScopes(String creator) {
        String string;
        return Sentry.getCurrentScopes().forkedScopes(string);
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentScopes().isEnabled();
    }

    public static void init(OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void init(OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        void var1_1;
        void var2_2;
        OptionsConfiguration<SentryOptions> optionsConfiguration2;
        SentryOptions options = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration2, options);
        Sentry.init((SentryOptions)var2_2, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options) {
        try {
            optionsConfiguration.configure(options);
            return;
        }
        catch (Throwable t) {
            void var0_1;
            void var1_2;
            var1_2.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", (Throwable)var0_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void init(SentryOptions options, boolean globalHubMode) {
        ISentryLifecycleToken ignored;
        block16: {
            ignored = lock.acquire();
            if (!options.getClass().getName().equals("io.sentry.android.core.SentryAndroidOptions") && Platform.isAndroid()) {
                throw new IllegalArgumentException("You are running Android. Please, use SentryAndroid.init. " + options.getClass().getName());
            }
            if (Sentry.preInitConfigurations(options)) break block16;
            if (ignored != null) {
                ignored.close();
            }
            return;
        }
        try {
            boolean globalHubModeToUse;
            Boolean globalHubModeFromOptions = options.isGlobalHubMode();
            globalHubModeToUse = globalHubModeFromOptions != null ? globalHubModeFromOptions : globalHubModeToUse;
            options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubModeToUse));
            Sentry.globalHubMode = globalHubModeToUse;
            Sentry.initFatalLogger(options);
            globalHubModeToUse = InitUtil.shouldInit(globalScope.getOptions(), options, Sentry.isEnabled());
            if (globalHubModeToUse) {
                Integration integration2;
                Iterator<Integration> iterator;
                if (Sentry.isEnabled()) {
                    options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
                }
                try {
                    options.getExecutorService().submit(() -> options.loadLazyFields());
                }
                catch (RejectedExecutionException e) {
                    options.getLogger().log(SentryLevel.DEBUG, "Failed to call the executor. Lazy fields will not be loaded. Did you call Sentry.close()?", e);
                }
                IScopes e = Sentry.getCurrentScopes();
                e.close(true);
                globalScope.replaceOptions(options);
                Scope rootScope = new Scope(options);
                Scope rootIsolationScope = new Scope(options);
                rootScopes = new Scopes((IScope)((Object)iterator), (IScope)((Object)integration2), globalScope, "Sentry.init");
                Sentry.initLogger(options);
                Sentry.initForOpenTelemetryMaybe(options);
                Sentry.getScopesStorage().set(rootScopes);
                Sentry.initConfigurations(options);
                globalScope.bindClient(new SentryClient(options));
                if (options.getExecutorService().isClosed()) {
                    options.setExecutorService(new SentryExecutorService());
                }
                for (Integration integration2 : options.getIntegrations()) {
                    integration2.register(ScopesAdapter.getInstance(), options);
                }
                Sentry.notifyOptionsObservers(options);
                Sentry.finalizePreviousSession(options, ScopesAdapter.getInstance());
                SentryOptions sentryOptions = options;
                Sentry.handleAppStartProfilingConfig(sentryOptions, sentryOptions.getExecutorService());
                options.getLogger().log(SentryLevel.DEBUG, "Using openTelemetryMode %s", new Object[]{options.getOpenTelemetryMode()});
                options.getLogger().log(SentryLevel.DEBUG, "Using span factory %s", options.getSpanFactory().getClass().getName());
                options.getLogger().log(SentryLevel.DEBUG, "Using scopes storage %s", scopesStorage.getClass().getName());
            } else {
                SentryOptions sentryOptions;
                sentryOptions.getLogger().log(SentryLevel.WARNING, "This init call has been ignored due to priority being too low.", new Object[0]);
            }
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_5;
                    var2_5.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private static void initForOpenTelemetryMaybe(SentryOptions options) {
        SentryOptions sentryOptions;
        OpenTelemetryUtil.updateOpenTelemetryModeIfAuto(options, new LoadClass());
        if (SentryOpenTelemetryMode.OFF == options.getOpenTelemetryMode()) {
            options.setSpanFactory(new DefaultSpanFactory());
        }
        Sentry.initScopesStorage(options);
        OpenTelemetryUtil.applyIgnoredSpanOrigins(sentryOptions);
    }

    private static void initLogger(SentryOptions options) {
        if (options.isDebug() && options.getLogger() instanceof NoOpLogger) {
            SentryOptions sentryOptions;
            sentryOptions.setLogger(new SystemOutLogger());
        }
    }

    private static void initFatalLogger(SentryOptions options) {
        if (options.getFatalLogger() instanceof NoOpLogger) {
            SentryOptions sentryOptions;
            sentryOptions.setFatalLogger(new SystemOutLogger());
        }
    }

    private static void initScopesStorage(SentryOptions options) {
        SentryOptions sentryOptions;
        Sentry.getScopesStorage().close();
        if (SentryOpenTelemetryMode.OFF == sentryOptions.getOpenTelemetryMode()) {
            scopesStorage = new DefaultScopesStorage();
            return;
        }
        scopesStorage = ScopesStorageFactory.create(new LoadClass(), NoOpLogger.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private static void handleAppStartProfilingConfig(SentryOptions options, ISentryExecutorService sentryExecutorService) {
        try {
            sentryExecutorService.submit(() -> {
                String cacheDirPath = options.getCacheDirPathWithoutDsn();
                if (cacheDirPath != null) {
                    File appStartProfilingConfigFile = new File(cacheDirPath, "app_start_profiling_config");
                    try {
                        FileOutputStream outputStream;
                        block14: {
                            FileUtils.deleteRecursively(appStartProfilingConfigFile);
                            if (!options.isEnableAppStartProfiling() && !options.isStartProfilerOnAppStart()) {
                                return;
                            }
                            if (!options.isStartProfilerOnAppStart() && !options.isTracingEnabled()) {
                                options.getLogger().log(SentryLevel.INFO, "Tracing is disabled and app start profiling will not start.", new Object[0]);
                                return;
                            }
                            if (appStartProfilingConfigFile.createNewFile()) {
                                TracesSamplingDecision appStartSamplingDecision = options.isEnableAppStartProfiling() ? Sentry.sampleAppStartProfiling(options) : new TracesSamplingDecision(Boolean.FALSE);
                                SentryAppStartProfilingOptions appStartProfilingOptions2 = new SentryAppStartProfilingOptions(options, appStartSamplingDecision);
                                outputStream = new FileOutputStream(appStartProfilingConfigFile);
                                try {
                                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));
                                    try {
                                        options.getSerializer().serialize(appStartProfilingOptions2, writer);
                                    }
                                    catch (Throwable appStartProfilingOptions2) {
                                        try {
                                            void var3_6;
                                            var3_6.close();
                                        }
                                        catch (Throwable throwable) {
                                            appStartProfilingOptions2.addSuppressed(throwable);
                                        }
                                        throw appStartProfilingOptions2;
                                    }
                                    ((Writer)writer).close();
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        void var1_1;
                                        var1_1.close();
                                    }
                                    catch (Throwable appStartProfilingOptions2) {
                                        throwable.addSuppressed(appStartProfilingOptions2);
                                    }
                                    throw throwable;
                                }
                            }
                            return;
                        }
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable e) {
                        void var2_5;
                        SentryOptions sentryOptions;
                        sentryOptions.getLogger().log(SentryLevel.ERROR, "Unable to create app start profiling config file. ", (Throwable)var2_5);
                    }
                }
            });
            return;
        }
        catch (Throwable e) {
            void var1_2;
            SentryOptions sentryOptions;
            sentryOptions.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. App start profiling config will not be changed. Did you call Sentry.close()?", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static TracesSamplingDecision sampleAppStartProfiling(SentryOptions options) {
        void var1_1;
        SentryOptions sentryOptions;
        TransactionContext appStartTransactionContext = new TransactionContext("app.launch", "profile");
        appStartTransactionContext.setForNextAppStart(true);
        SamplingContext appStartSamplingContext = new SamplingContext(appStartTransactionContext, null, SentryRandom.current().nextDouble(), null);
        return sentryOptions.getInternalTracesSampler().sample((SamplingContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void finalizePreviousSession(SentryOptions options, IScopes scopes) {
        try {
            options.getExecutorService().submit(new PreviousSessionFinalizer(options, scopes));
            return;
        }
        catch (Throwable e) {
            void var1_2;
            SentryOptions sentryOptions;
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void notifyOptionsObservers(SentryOptions options) {
        try {
            options.getExecutorService().submit(() -> {
                SentryOptions sentryOptions;
                Iterator<IOptionsObserver> iterator = options.getOptionsObservers().iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    IOptionsObserver observer = iterator.next();
                    observer.setRelease(options.getRelease());
                    observer.setProguardUuid(options.getProguardUuid());
                    observer.setSdkVersion(options.getSdkVersion());
                    observer.setDist(options.getDist());
                    observer.setEnvironment(options.getEnvironment());
                    observer.setTags(options.getTags());
                    var2_2.setReplayErrorSampleRate(options.getSessionReplay().getOnErrorSampleRate());
                }
                PersistingScopeObserver scopeCache = sentryOptions.findPersistingScopeObserver();
                if (scopeCache != null) {
                    ((PersistingScopeObserver)((Object)iterator)).resetCache();
                }
            });
            return;
        }
        catch (Throwable e) {
            void var1_1;
            SentryOptions sentryOptions;
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", (Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean preInitConfigurations(SentryOptions options) {
        SentryOptions sentryOptions;
        void var1_1;
        if (options.isEnableExternalConfiguration()) {
            options.merge(ExternalOptions.from(PropertiesProviderFactory.create(), options.getLogger()));
        }
        String dsn = options.getDsn();
        if (!options.isEnabled() || dsn != null && dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        if (var1_1 == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string or set enabled to false in SentryOptions to disable SDK.");
        }
        sentryOptions.retrieveParsedDsn();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void initConfigurations(SentryOptions options) {
        IThreadChecker iThreadChecker;
        Object logger = options.getLogger();
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        String outboxPath = options.getOutboxPath();
        if (outboxPath != null) {
            void var2_3;
            logger = new File((String)var2_3);
            ((File)logger).mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        Object cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath != null) {
            cacheDirPath = new File((String)cacheDirPath);
            ((File)cacheDirPath).mkdirs();
            cacheDirPath = options.getEnvelopeDiskCache();
            if (cacheDirPath instanceof NoOpEnvelopeCache) {
                SentryOptions sentryOptions = options;
                sentryOptions.setEnvelopeDiskCache(EnvelopeCache.create(sentryOptions));
            }
        }
        String profilingTracesDirPath = options.getProfilingTracesDirPath();
        if ((options.isProfilingEnabled() || options.isContinuousProfilingEnabled()) && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            try {
                options.getExecutorService().submit(() -> {
                    File[] fileArray;
                    File[] oldTracesDirContent = profilingTracesDir.listFiles();
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File f : fileArray) {
                        void var3_3;
                        if (f.lastModified() >= classCreationTimestamp - TimeUnit.MINUTES.toMillis(5L)) continue;
                        FileUtils.deleteRecursively((File)var3_3);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e);
            }
        }
        IModulesLoader modulesLoader = options.getModulesLoader();
        if (!options.isSendModules()) {
            options.setModulesLoader(NoOpModulesLoader.getInstance());
        } else if (modulesLoader instanceof NoOpModulesLoader) {
            options.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options.getLogger()), new ResourcesModulesLoader(options.getLogger())), options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader(new ResourcesDebugMetaLoader(options.getLogger()));
        }
        List<Properties> propertiesList = options.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options, (List<Properties>)((Object)iThreadChecker));
        iThreadChecker = options.getThreadChecker();
        if (iThreadChecker instanceof NoOpThreadChecker) {
            options.setThreadChecker(ThreadChecker.getInstance());
        }
        if (options.getPerformanceCollectors().isEmpty()) {
            options.addPerformanceCollector(new JavaMemoryCollector());
        }
        if (options.isEnableBackpressureHandling() && Platform.isJvm()) {
            SentryOptions sentryOptions;
            if (options.getBackpressureMonitor() instanceof NoOpBackpressureMonitor) {
                options.setBackpressureMonitor(new BackpressureMonitor(options, ScopesAdapter.getInstance()));
            }
            sentryOptions.getBackpressureMonitor().start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void close() {
        ISentryLifecycleToken ignored = lock.acquire();
        try {
            void var1_2;
            IScopes scopes = Sentry.getCurrentScopes();
            rootScopes = NoOpScopes.getInstance();
            Sentry.getScopesStorage().close();
            var1_2.close(false);
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var0;
                    var0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureEvent(SentryEvent event, Hint hint) {
        void var1_1;
        SentryEvent sentryEvent;
        return Sentry.getCurrentScopes().captureEvent(sentryEvent, (Hint)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureException(Throwable throwable, ScopeCallback callback) {
        void var1_1;
        Throwable throwable2;
        return Sentry.getCurrentScopes().captureException(throwable2, (ScopeCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureException(Throwable throwable, Hint hint, ScopeCallback callback) {
        void var2_2;
        void var1_1;
        Throwable throwable2;
        return Sentry.getCurrentScopes().captureException(throwable2, (Hint)var1_1, (ScopeCallback)var2_2);
    }

    public static void configureScope(ScopeCallback callback) {
        ScopeCallback scopeCallback;
        Sentry.configureScope(null, scopeCallback);
    }

    /*
     * WARNING - void declaration
     */
    public static void configureScope(ScopeType scopeType, ScopeCallback callback) {
        void var1_1;
        ScopeType scopeType2;
        Sentry.getCurrentScopes().configureScope(scopeType2, (ScopeCallback)var1_1);
    }

    public static boolean isHealthy() {
        return Sentry.getCurrentScopes().isHealthy();
    }

    public static void flush(long timeoutMillis) {
        long l;
        Sentry.getCurrentScopes().flush(l);
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(T var1);
    }
}

