/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.CombinedScopeView;
import io.sentry.CompositePerformanceCollector;
import io.sentry.Hint;
import io.sentry.HubScopesWrapper;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.ISentryClient;
import io.sentry.ISentryExecutorService;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.ScopeCallback;
import io.sentry.ScopeType;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.io.Closeable;

public final class Scopes
implements IScopes {
    private final IScope scope;
    private final IScope isolationScope;
    private final IScope globalScope;
    private final Scopes parentScopes;
    private final String creator;
    private final CompositePerformanceCollector compositePerformanceCollector;
    private final CombinedScopeView combinedScope;

    /*
     * WARNING - void declaration
     */
    public Scopes(IScope scope, IScope isolationScope, IScope globalScope, String creator) {
        this((IScope)var1_1, (IScope)var2_2, (IScope)var3_3, null, creator);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Scopes(IScope scope, IScope isolationScope, IScope globalScope, Scopes parentScopes, String creator) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.combinedScope = new CombinedScopeView(globalScope, isolationScope, scope);
        this.scope = scope;
        this.isolationScope = var2_2;
        this.globalScope = var3_3;
        this.parentScopes = parentScopes;
        this.creator = creator;
        SentryOptions options = this.getOptions();
        Scopes.validateOptions(options);
        this.compositePerformanceCollector = var1_1.getCompositePerformanceCollector();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final IScopes forkedScopes(String creator) {
        void var1_1;
        return new Scopes(this.scope.clone(), this.isolationScope.clone(), this.globalScope, this, (String)var1_1);
    }

    @Override
    public final boolean isEnabled() {
        return this.getClient().isEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, Hint hint) {
        void var2_2;
        void var1_1;
        return this.captureEventInternal((SentryEvent)var1_1, (Hint)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureEventInternal(SentryEvent event, Hint hint, ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                this.assignTraceContext(event);
                Scopes scopes = this;
                IScope localScope = scopes.buildLocalScope(scopes.getCombinedScopeView(), scopeCallback);
                sentryId = this.getClient().captureEvent(event, localScope, (Hint)var2_2);
                this.updateLastEventId(sentryId);
            }
            catch (Throwable e) {
                void var3_4;
                void var1_1;
                this.getOptions().getLogger().log(SentryLevel.ERROR, "Error while capturing event with id: " + var1_1.getEventId(), (Throwable)var3_4);
            }
        }
        return sentryId;
    }

    private ISentryClient getClient() {
        return this.getCombinedScopeView().getClient();
    }

    /*
     * WARNING - void declaration
     */
    private void assignTraceContext(SentryEvent event) {
        void var1_1;
        this.getCombinedScopeView().assignTraceContext((SentryEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private IScope buildLocalScope(IScope parentScope, ScopeCallback callback) {
        void var1_1;
        if (callback != null) {
            try {
                void var2_2;
                IScope localScope = parentScope.clone();
                var2_2.run(localScope);
                return localScope;
            }
            catch (Throwable t) {
                void var3_4;
                this.getOptions().getLogger().log(SentryLevel.ERROR, "Error in the 'ScopeCallback' callback.", (Throwable)var3_4);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope(SentryEnvelope envelope, Hint hint) {
        void var3_4;
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEnvelope' call is a no-op.", new Object[0]);
        } else {
            try {
                void var2_3;
                SentryId capturedEnvelopeId = this.getClient().captureEnvelope(envelope, (Hint)var2_3);
                if (capturedEnvelopeId != null) {
                    sentryId = capturedEnvelopeId;
                }
            }
            catch (Throwable e) {
                void var1_2;
                this.getOptions().getLogger().log(SentryLevel.ERROR, "Error while capturing envelope.", (Throwable)var1_2);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureException(Throwable throwable, Hint hint, ScopeCallback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.captureExceptionInternal((Throwable)var1_1, (Hint)var2_2, (ScopeCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureExceptionInternal(Throwable throwable, Hint hint, ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                void var3_3;
                SentryEvent event = new SentryEvent(throwable);
                this.assignTraceContext(event);
                Scopes scopes = this;
                IScope localScope = scopes.buildLocalScope(scopes.getCombinedScopeView(), scopeCallback);
                sentryId = this.getClient().captureEvent(event, (IScope)var3_3, (Hint)var2_2);
            }
            catch (Throwable e) {
                void var1_1;
                this.getOptions().getLogger().log(SentryLevel.ERROR, "Error while capturing exception: " + var1_1.getMessage(), e);
            }
        }
        this.updateLastEventId(sentryId);
        return sentryId;
    }

    private IScope getCombinedScopeView() {
        return this.combinedScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(boolean isRestarting) {
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
            return;
        }
        try {
            void var1_1;
            for (Integration integration : this.getOptions().getIntegrations()) {
                if (!(integration instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)integration)).close();
                }
                catch (Throwable e) {
                    void var3_4;
                    this.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to close the integration {}.", var3_4, e);
                }
            }
            this.configureScope(scope -> scope.clear());
            this.configureScope(ScopeType.ISOLATION, scope -> scope.clear());
            this.getOptions().getBackpressureMonitor().close();
            this.getOptions().getTransactionProfiler().close();
            this.getOptions().getContinuousProfiler().close(true);
            this.getOptions().getCompositePerformanceCollector().close();
            ISentryExecutorService executorService = this.getOptions().getExecutorService();
            if (isRestarting) {
                executorService.submit(() -> executorService.close(this.getOptions().getShutdownTimeoutMillis()));
            } else {
                executorService.close(this.getOptions().getShutdownTimeoutMillis());
            }
            this.configureScope(ScopeType.CURRENT, scope -> {
                boolean bl;
                scope.getClient().close(bl);
            });
            this.configureScope(ScopeType.ISOLATION, scope -> {
                boolean bl;
                scope.getClient().close(bl);
            });
            this.configureScope(ScopeType.GLOBAL, arg_0 -> Scopes.lambda$close$5((boolean)var1_1, arg_0));
            return;
        }
        catch (Throwable e) {
            void var2_3;
            this.getOptions().getLogger().log(SentryLevel.ERROR, "Error while closing the Scopes.", (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateLastEventId(SentryId lastEventId) {
        void var1_1;
        this.getCombinedScopeView().setLastEventId((SentryId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void configureScope(ScopeType scopeType, ScopeCallback callback) {
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'configureScope' call is a no-op.", new Object[0]);
            return;
        }
        try {
            void var2_3;
            var2_3.run(this.combinedScope.getSpecificScope(scopeType));
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.getOptions().getLogger().log(SentryLevel.ERROR, "Error in the 'configureScope' callback.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public final boolean isHealthy() {
        return this.getClient().isHealthy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
            return;
        }
        try {
            this.getClient().flush(timeoutMillis);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.getOptions().getLogger().log(SentryLevel.ERROR, "Error in the 'client.flush'.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    @Deprecated
    public final IHub clone() {
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Disabled Scopes cloned.", new Object[0]);
        }
        return new HubScopesWrapper(this.forkedScopes("scopes clone"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ITransaction getTransaction() {
        void var1_1;
        ITransaction span = null;
        if (!this.isEnabled()) {
            this.getOptions().getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getTransaction' call is a no-op.", new Object[0]);
        } else {
            span = this.getCombinedScopeView().getTransaction();
        }
        return var1_1;
    }

    @Override
    public final SentryOptions getOptions() {
        return this.combinedScope.getOptions();
    }

    private static void validateOptions(SentryOptions options) {
        SentryOptions sentryOptions;
        Objects.requireNonNull(options, "SentryOptions is required.");
        if (options.getDsn() == null || sentryOptions.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Scopes requires a DSN to be instantiated. Considering using the NoOpScopes if no DSN is available.");
        }
    }

    private static /* synthetic */ void lambda$close$5(boolean isRestarting, IScope scope) {
        boolean bl;
        scope.getClient().close(bl);
    }
}

