/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Attachment;
import io.sentry.Breadcrumb;
import io.sentry.CircularFifoQueue;
import io.sentry.DisabledQueue;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.IScope;
import io.sentry.IScopeObserver;
import io.sentry.ISentryClient;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSentryClient;
import io.sentry.PropagationContext;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SynchronizedQueue;
import io.sentry.internal.eventprocessor.EventProcessorAndOrder;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.CollectionUtils;
import io.sentry.util.EventProcessorUtils;
import io.sentry.util.ExceptionUtils;
import io.sentry.util.Objects;
import io.sentry.util.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Scope
implements IScope {
    private volatile SentryId lastEventId;
    private SentryLevel level;
    private ITransaction transaction;
    private WeakReference<ISpan> activeSpan = new WeakReference<Object>(null);
    private String transactionName;
    private User user;
    private String screen;
    private Request request;
    private List<String> fingerprint = new ArrayList<String>();
    private volatile Queue<Breadcrumb> breadcrumbs;
    private Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Map<String, Object> extra = new ConcurrentHashMap<String, Object>();
    private List<EventProcessorAndOrder> eventProcessors = new CopyOnWriteArrayList<EventProcessorAndOrder>();
    private volatile SentryOptions options;
    private volatile Session session;
    private final AutoClosableReentrantLock sessionLock = new AutoClosableReentrantLock();
    private final AutoClosableReentrantLock transactionLock = new AutoClosableReentrantLock();
    private final AutoClosableReentrantLock propagationContextLock = new AutoClosableReentrantLock();
    private Contexts contexts = new Contexts();
    private List<Attachment> attachments = new CopyOnWriteArrayList<Attachment>();
    private PropagationContext propagationContext;
    private SentryId replayId = SentryId.EMPTY_ID;
    private ISentryClient client = NoOpSentryClient.getInstance();
    private final Map<Throwable, Pair<WeakReference<ISpan>, String>> throwableToSpan = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - void declaration
     */
    public Scope(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "SentryOptions is required.");
        this.breadcrumbs = Scope.createBreadcrumbsList(this.options.getMaxBreadcrumbs());
        this.propagationContext = new PropagationContext();
        this.lastEventId = SentryId.EMPTY_ID;
    }

    /*
     * WARNING - void declaration
     */
    private Scope(Scope scope) {
        void var1_1;
        void var3_3;
        this.transaction = scope.transaction;
        this.transactionName = scope.transactionName;
        this.session = scope.session;
        this.options = scope.options;
        this.level = scope.level;
        this.client = scope.client;
        this.lastEventId = scope.getLastEventId();
        User userRef = scope.user;
        this.user = userRef != null ? new User(userRef) : null;
        this.screen = scope.screen;
        this.replayId = scope.replayId;
        Request requestRef = scope.request;
        this.request = requestRef != null ? new Request(requestRef) : null;
        this.fingerprint = new ArrayList<String>(scope.fingerprint);
        this.eventProcessors = new CopyOnWriteArrayList<EventProcessorAndOrder>(scope.eventProcessors);
        Breadcrumb[] breadcrumbsRef = scope.breadcrumbs.toArray(new Breadcrumb[0]);
        Queue<Breadcrumb> breadcrumbsClone = Scope.createBreadcrumbsList(scope.options.getMaxBreadcrumbs());
        for (Breadcrumb breadcrumb : breadcrumbsRef) {
            Breadcrumb breadcrumbClone = new Breadcrumb(breadcrumb);
            breadcrumbsClone.add(breadcrumbClone);
        }
        this.breadcrumbs = var3_3;
        Map<String, String> tagsRef = scope.tags;
        ConcurrentHashMap<String, String> tagsClone = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : tagsRef.entrySet()) {
            if (entry == null) continue;
            tagsClone.put(entry.getKey(), entry.getValue());
        }
        this.tags = tagsClone;
        Map<String, Object> extraRef = scope.extra;
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> item : extraRef.entrySet()) {
            void var2_2;
            if (item == null) continue;
            concurrentHashMap.put(item.getKey(), var2_2.getValue());
        }
        this.extra = concurrentHashMap;
        this.contexts = new Contexts(scope.contexts);
        this.attachments = new CopyOnWriteArrayList<Attachment>(scope.attachments);
        this.propagationContext = new PropagationContext(var1_1.propagationContext);
    }

    @Override
    public final SentryLevel getLevel() {
        return this.level;
    }

    @Override
    public final void setLevel(SentryLevel level) {
        this.level = level;
        for (IScopeObserver iScopeObserver : this.options.getScopeObservers()) {
            iScopeObserver.setLevel(level);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getTransactionName() {
        ITransaction tx = this.transaction;
        if (tx != null) {
            void var1_1;
            return var1_1.getName();
        }
        return this.transactionName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ISpan getSpan() {
        void var1_1;
        ISpan span;
        ISpan activeSpan = (ISpan)this.activeSpan.get();
        if (activeSpan != null) {
            return activeSpan;
        }
        ITransaction tx = this.transaction;
        if (tx != null && (span = tx.getLatestActiveSpan()) != null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    @Override
    public final User getUser() {
        return this.user;
    }

    @Override
    public final void setUser(User user) {
        this.user = user;
        for (IScopeObserver iScopeObserver : this.options.getScopeObservers()) {
            iScopeObserver.setUser(user);
        }
    }

    @Override
    public final SentryId getReplayId() {
        return this.replayId;
    }

    @Override
    public final Request getRequest() {
        return this.request;
    }

    @Override
    public final List<String> getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public final Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    /*
     * WARNING - void declaration
     */
    private Breadcrumb executeBeforeBreadcrumb(SentryOptions.BeforeBreadcrumbCallback callback, Breadcrumb breadcrumb, Hint hint) {
        void var2_3;
        block2: {
            try {
                void var3_4;
                breadcrumb = callback.execute(breadcrumb, (Hint)var3_4);
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeBreadcrumbCallback callback threw an exception. Exception details will be added to the breadcrumb.", e);
                if (e.getMessage() == null) break block2;
                breadcrumb.setData("sentry:message", var1_2.getMessage());
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void addBreadcrumb(Breadcrumb breadcrumb, Hint hint) {
        SentryOptions.BeforeBreadcrumbCallback callback;
        if (breadcrumb == null) {
            return;
        }
        if (hint == null) {
            hint = new Hint();
        }
        if ((callback = this.options.getBeforeBreadcrumb()) != null) {
            Iterator<IScopeObserver> iterator;
            breadcrumb = this.executeBeforeBreadcrumb(callback, breadcrumb, (Hint)((Object)iterator));
        }
        if (breadcrumb != null) {
            this.breadcrumbs.add(breadcrumb);
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                void var3_3;
                observer.addBreadcrumb(breadcrumb);
                var3_3.setBreadcrumbs(this.breadcrumbs);
            }
            return;
        }
        this.options.getLogger().log(SentryLevel.INFO, "Breadcrumb was dropped by beforeBreadcrumb", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBreadcrumb(Breadcrumb breadcrumb) {
        void var1_1;
        this.addBreadcrumb((Breadcrumb)var1_1, null);
    }

    public final void clearBreadcrumbs() {
        this.breadcrumbs.clear();
        for (IScopeObserver iScopeObserver : this.options.getScopeObservers()) {
            iScopeObserver.setBreadcrumbs(this.breadcrumbs);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearTransaction() {
        ISentryLifecycleToken ignored = this.transactionLock.acquire();
        try {
            this.transaction = null;
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    Iterator<IScopeObserver> iterator;
                    iterator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        this.transactionName = null;
        for (IScopeObserver observer : this.options.getScopeObservers()) {
            void var2_4;
            observer.setTransaction(null);
            var2_4.setTrace(null, this);
        }
    }

    @Override
    public final ITransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public final void clear() {
        this.level = null;
        this.user = null;
        this.request = null;
        this.screen = null;
        this.fingerprint.clear();
        this.clearBreadcrumbs();
        this.tags.clear();
        this.extra.clear();
        this.eventProcessors.clear();
        this.clearTransaction();
        this.clearAttachments();
    }

    @Override
    public final Map<String, String> getTags() {
        return CollectionUtils.newConcurrentHashMap(this.tags);
    }

    @Override
    public final Map<String, Object> getExtras() {
        return this.extra;
    }

    @Override
    public final Contexts getContexts() {
        return this.contexts;
    }

    public final void setContexts(String key, Object value) {
        IScopeObserver iScopeObserver2;
        Iterator<IScopeObserver> iterator;
        if (key == null) {
            return;
        }
        this.contexts.put((String)((Object)iterator), iScopeObserver2);
        for (IScopeObserver iScopeObserver2 : this.options.getScopeObservers()) {
            iScopeObserver2.setContexts(this.contexts);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setContexts(String key, String value) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (key == null) {
            return;
        }
        if (value == null) {
            this.setContexts(key, (Object)null);
            return;
        }
        HashMap<String, void> map = new HashMap<String, void>();
        map.put("value", var2_2);
        this.setContexts((String)var1_1, var3_3);
    }

    @Override
    public final List<Attachment> getAttachments() {
        return new CopyOnWriteArrayList<Attachment>(this.attachments);
    }

    public final void clearAttachments() {
        this.attachments.clear();
    }

    static Queue<Breadcrumb> createBreadcrumbsList(int maxBreadcrumb) {
        if (maxBreadcrumb > 0) {
            int n;
            return SynchronizedQueue.synchronizedQueue(new CircularFifoQueue(n));
        }
        return SynchronizedQueue.synchronizedQueue(new DisabledQueue());
    }

    @Override
    public final List<EventProcessor> getEventProcessors() {
        return EventProcessorUtils.unwrap(this.eventProcessors);
    }

    @Override
    public final List<EventProcessorAndOrder> getEventProcessorsWithOrder() {
        return this.eventProcessors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Session withSession(IWithSession sessionCallback) {
        void var2_3;
        Session cloneSession2 = null;
        ISentryLifecycleToken ignored = this.sessionLock.acquire();
        try {
            void var1_1;
            var1_1.accept(this.session);
            if (this.session != null) {
                cloneSession2 = this.session.clone();
            }
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var3_5;
                    var3_5.close();
                }
                catch (Throwable cloneSession2) {
                    throwable.addSuppressed(cloneSession2);
                }
            }
            throw throwable;
        }
        return var2_3;
    }

    @Override
    public final SentryOptions getOptions() {
        return this.options;
    }

    @Override
    public final PropagationContext getPropagationContext() {
        return this.propagationContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PropagationContext withPropagationContext(IWithPropagationContext callback) {
        ISentryLifecycleToken ignored = this.propagationContextLock.acquire();
        try {
            PropagationContext propagationContext;
            propagationContext.accept(this.propagationContext);
            propagationContext = new PropagationContext(this.propagationContext);
            if (ignored != null) {
                ignored.close();
            }
            return propagationContext;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public final IScope clone() {
        return new Scope(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLastEventId(SentryId lastEventId) {
        void var1_1;
        this.lastEventId = var1_1;
    }

    public final SentryId getLastEventId() {
        return this.lastEventId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void bindClient(ISentryClient client) {
        void var1_1;
        this.client = var1_1;
    }

    @Override
    public final ISentryClient getClient() {
        return this.client;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void assignTraceContext(SentryEvent event) {
        Pair<WeakReference<ISpan>, String> pair;
        if (this.options.isTracingEnabled() && event.getThrowable() != null && (pair = this.throwableToSpan.get(ExceptionUtils.findRootCause(event.getThrowable()))) != null) {
            void var2_2;
            ISpan span;
            WeakReference<ISpan> spanWeakRef = pair.getFirst();
            if (event.getContexts().getTrace() == null && spanWeakRef != null && (span = (ISpan)spanWeakRef.get()) != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            String transactionName = (String)var2_2.getSecond();
            if (event.getTransaction() == null && transactionName != null) {
                void var3_3;
                void var1_1;
                var1_1.setTransaction((String)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void replaceOptions(SentryOptions options) {
        Iterator iterator;
        this.options = options;
        Queue<Breadcrumb> oldBreadcrumbs = this.breadcrumbs;
        this.breadcrumbs = Scope.createBreadcrumbsList(((SentryOptions)((Object)iterator)).getMaxBreadcrumbs());
        for (Breadcrumb breadcrumb : oldBreadcrumbs) {
            void var2_2;
            this.addBreadcrumb((Breadcrumb)var2_2);
        }
    }

    static interface IWithSession {
        public void accept(Session var1);
    }

    public static interface IWithPropagationContext {
        public void accept(PropagationContext var1);
    }
}

