/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebEventType;
import io.sentry.rrweb.RRWebIncrementalSnapshotEvent;
import io.sentry.rrweb.RRWebInteractionEvent;
import io.sentry.rrweb.RRWebInteractionMoveEvent;
import io.sentry.rrweb.RRWebMetaEvent;
import io.sentry.rrweb.RRWebSpanEvent;
import io.sentry.rrweb.RRWebVideoEvent;
import io.sentry.util.MapObjectReader;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReplayRecording
implements JsonSerializable {
    private Integer segmentId;
    private List<? extends RRWebEvent> payload;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public final void setSegmentId(Integer segmentId) {
        void var1_1;
        this.segmentId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPayload(List<? extends RRWebEvent> payload) {
        void var1_1;
        this.payload = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayRecording that = (ReplayRecording)o;
        return Objects.equals(this.segmentId, that.segmentId) && Objects.equals(this.payload, var1_1.payload);
    }

    public final int hashCode() {
        return Objects.hash(this.segmentId, this.payload);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.segmentId != null) {
            writer.name("segment_id").value(this.segmentId);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        writer.endObject();
        writer.setLenient(true);
        if (this.segmentId != null) {
            writer.jsonValue("\n");
        }
        if (this.payload != null) {
            void var2_2;
            writer.value((ILogger)var2_2, this.payload);
        }
        var1_1.setLenient(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<ReplayRecording> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final ReplayRecording deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            ReplayRecording replay = new ReplayRecording();
            HashMap<String, Object> unknown = null;
            Integer segmentId = null;
            ArrayList<RRWebEvent> payload = null;
            reader.beginObject();
            block25: while (reader.peek() == JsonToken.NAME) {
                String nextName = reader.nextName();
                switch (nextName) {
                    case "segment_id": {
                        segmentId = reader.nextIntegerOrNull();
                        continue block25;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            reader.endObject();
            reader.setLenient(true);
            List events = (List)reader.nextObjectOrNull();
            reader.setLenient(false);
            if (events != null) {
                payload = new ArrayList<RRWebEvent>(events.size());
                for (Object event : events) {
                    if (!(event instanceof Map)) continue;
                    Map eventMap = (Map)event;
                    MapObjectReader mapReader = new MapObjectReader(eventMap);
                    block27: for (Map.Entry entry : eventMap.entrySet()) {
                        void var10_12;
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (!key.equals("type")) continue;
                        RRWebEventType type = RRWebEventType.values()[(Integer)value];
                        switch (type) {
                            case IncrementalSnapshot: {
                                Integer sourceInt;
                                Map incrementalData = (Map)eventMap.get("data");
                                if (incrementalData == null) {
                                    incrementalData = Collections.emptyMap();
                                }
                                if ((sourceInt = (Integer)incrementalData.get("source")) == null) continue block27;
                                RRWebIncrementalSnapshotEvent.IncrementalSource source = RRWebIncrementalSnapshotEvent.IncrementalSource.values()[sourceInt];
                                switch (source) {
                                    case MouseInteraction: {
                                        RRWebInteractionEvent interactionEvent = new RRWebInteractionEvent.Deserializer().deserialize(mapReader, logger);
                                        payload.add(interactionEvent);
                                        continue block27;
                                    }
                                    case TouchMove: {
                                        RRWebInteractionMoveEvent interactionMoveEvent = new RRWebInteractionMoveEvent.Deserializer().deserialize(mapReader, logger);
                                        payload.add(interactionMoveEvent);
                                        continue block27;
                                    }
                                }
                                logger.log(SentryLevel.DEBUG, "Unsupported rrweb incremental snapshot type %s", source);
                                continue block27;
                            }
                            case Meta: {
                                RRWebMetaEvent metaEvent = new RRWebMetaEvent.Deserializer().deserialize(mapReader, logger);
                                payload.add(metaEvent);
                                continue block27;
                            }
                            case Custom: {
                                String tag;
                                Map customData = (Map)eventMap.get("data");
                                if (customData == null) {
                                    customData = Collections.emptyMap();
                                }
                                if ((tag = (String)customData.get("tag")) == null) continue block27;
                                switch (tag) {
                                    case "video": {
                                        RRWebVideoEvent videoEvent = new RRWebVideoEvent.Deserializer().deserialize(mapReader, logger);
                                        payload.add(videoEvent);
                                        continue block27;
                                    }
                                    case "breadcrumb": {
                                        RRWebBreadcrumbEvent breadcrumbEvent = new RRWebBreadcrumbEvent.Deserializer().deserialize(mapReader, logger);
                                        payload.add(breadcrumbEvent);
                                        continue block27;
                                    }
                                    case "performanceSpan": {
                                        RRWebSpanEvent spanEvent = new RRWebSpanEvent.Deserializer().deserialize(mapReader, logger);
                                        payload.add(spanEvent);
                                        continue block27;
                                    }
                                }
                                logger.log(SentryLevel.DEBUG, "Unsupported rrweb event type %s", var10_12);
                                continue block27;
                            }
                        }
                        logger.log(SentryLevel.DEBUG, "Unsupported rrweb event type %s", var10_12);
                    }
                }
            }
            replay.setSegmentId(segmentId);
            replay.setPayload(payload);
            replay.setUnknown(unknown);
            return var3_3;
        }
    }
}

