/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryOptions;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class ProfileChunk
implements JsonSerializable {
    private DebugMeta debugMeta;
    private SentryId profilerId;
    private SentryId chunkId;
    private SdkVersion clientSdk;
    private final Map<String, ProfileMeasurement> measurements;
    private String platform;
    private String release;
    private String environment;
    private String version;
    private double timestamp;
    private final File traceFile;
    private String sampledProfile;
    private Map<String, Object> unknown;

    public ProfileChunk() {
        SentryId sentryId = SentryId.EMPTY_ID;
        this(sentryId, sentryId, new File("dummy"), new HashMap<String, ProfileMeasurement>(), 0.0, SentryOptions.empty());
    }

    /*
     * WARNING - void declaration
     */
    public ProfileChunk(SentryId profilerId, SentryId chunkId, File traceFile, Map<String, ProfileMeasurement> measurements, Double timestamp, SentryOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sampledProfile = null;
        this.profilerId = var1_1;
        this.chunkId = var2_2;
        this.traceFile = var3_3;
        this.measurements = measurements;
        this.debugMeta = null;
        this.clientSdk = options.getSdkVersion();
        this.release = options.getRelease() != null ? options.getRelease() : "";
        this.environment = options.getEnvironment();
        this.platform = "android";
        this.version = "2";
        this.timestamp = timestamp;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileChunk)) {
            return false;
        }
        ProfileChunk that = (ProfileChunk)o;
        return Objects.equals(this.debugMeta, that.debugMeta) && Objects.equals(this.profilerId, that.profilerId) && Objects.equals(this.chunkId, that.chunkId) && Objects.equals(this.clientSdk, that.clientSdk) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.platform, that.platform) && Objects.equals(this.release, that.release) && Objects.equals(this.environment, that.environment) && Objects.equals(this.version, that.version) && Objects.equals(this.sampledProfile, that.sampledProfile) && Objects.equals(this.unknown, var1_1.unknown);
    }

    public final int hashCode() {
        return Objects.hash(this.debugMeta, this.profilerId, this.chunkId, this.clientSdk, this.measurements, this.platform, this.release, this.environment, this.version, this.sampledProfile, this.unknown);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.debugMeta != null) {
            writer.name("debug_meta").value(logger, this.debugMeta);
        }
        writer.name("profiler_id").value(logger, this.profilerId);
        writer.name("chunk_id").value(logger, this.chunkId);
        if (this.clientSdk != null) {
            writer.name("client_sdk").value(logger, this.clientSdk);
        }
        if (!this.measurements.isEmpty()) {
            writer.name("measurements").value(logger, this.measurements);
        }
        writer.name("platform").value(logger, this.platform);
        writer.name("release").value(logger, this.release);
        if (this.environment != null) {
            writer.name("environment").value(logger, this.environment);
        }
        writer.name("version").value(logger, this.version);
        if (this.sampledProfile != null) {
            writer.name("sampled_profile").value(logger, this.sampledProfile);
        }
        writer.name("timestamp").value(logger, this.timestamp);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ DebugMeta access$002(ProfileChunk x0, DebugMeta x1) {
        void var1_1;
        x0.debugMeta = var1_1;
        return x0.debugMeta;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryId access$102(ProfileChunk x0, SentryId x1) {
        void var1_1;
        x0.profilerId = var1_1;
        return x0.profilerId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryId access$202(ProfileChunk x0, SentryId x1) {
        void var1_1;
        x0.chunkId = var1_1;
        return x0.chunkId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SdkVersion access$302(ProfileChunk x0, SdkVersion x1) {
        void var1_1;
        x0.clientSdk = var1_1;
        return x0.clientSdk;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(ProfileChunk x0, String x1) {
        void var1_1;
        x0.platform = var1_1;
        return x0.platform;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(ProfileChunk x0, String x1) {
        void var1_1;
        x0.release = var1_1;
        return x0.release;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$702(ProfileChunk x0, String x1) {
        void var1_1;
        x0.environment = var1_1;
        return x0.environment;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$802(ProfileChunk x0, String x1) {
        void var1_1;
        x0.version = var1_1;
        return x0.version;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$902(ProfileChunk x0, String x1) {
        void var1_1;
        x0.sampledProfile = var1_1;
        return x0.sampledProfile;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$1002(ProfileChunk x0, double x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileChunk> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final ProfileChunk deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            reader.beginObject();
            ProfileChunk data = new ProfileChunk();
            ConcurrentHashMap<String, Object> unknown = null;
            block26: while (reader.peek() == JsonToken.NAME) {
                void var5_5;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "debug_meta": {
                        DebugMeta debugMeta = reader.nextOrNull(logger, new DebugMeta.Deserializer());
                        if (debugMeta == null) continue block26;
                        ProfileChunk.access$002(data, debugMeta);
                        continue block26;
                    }
                    case "profiler_id": {
                        SentryId profilerId = reader.nextOrNull(logger, new SentryId.Deserializer());
                        if (profilerId == null) continue block26;
                        ProfileChunk.access$102(data, profilerId);
                        continue block26;
                    }
                    case "chunk_id": {
                        SentryId chunkId = reader.nextOrNull(logger, new SentryId.Deserializer());
                        if (chunkId == null) continue block26;
                        ProfileChunk.access$202(data, chunkId);
                        continue block26;
                    }
                    case "client_sdk": {
                        SdkVersion clientSdk = reader.nextOrNull(logger, new SdkVersion.Deserializer());
                        if (clientSdk == null) continue block26;
                        ProfileChunk.access$302(data, clientSdk);
                        continue block26;
                    }
                    case "measurements": {
                        Map<String, ProfileMeasurement> measurements = reader.nextMapOrNull(logger, new ProfileMeasurement.Deserializer());
                        if (measurements == null) continue block26;
                        data.measurements.putAll(measurements);
                        continue block26;
                    }
                    case "platform": {
                        String platform = reader.nextStringOrNull();
                        if (platform == null) continue block26;
                        ProfileChunk.access$502(data, platform);
                        continue block26;
                    }
                    case "release": {
                        String release = reader.nextStringOrNull();
                        if (release == null) continue block26;
                        ProfileChunk.access$602(data, release);
                        continue block26;
                    }
                    case "environment": {
                        String environment = reader.nextStringOrNull();
                        if (environment == null) continue block26;
                        ProfileChunk.access$702(data, environment);
                        continue block26;
                    }
                    case "version": {
                        String version = reader.nextStringOrNull();
                        if (version == null) continue block26;
                        ProfileChunk.access$802(data, version);
                        continue block26;
                    }
                    case "sampled_profile": {
                        String sampledProfile = reader.nextStringOrNull();
                        if (sampledProfile == null) continue block26;
                        ProfileChunk.access$902(data, sampledProfile);
                        continue block26;
                    }
                    case "timestamp": {
                        Double timestamp = reader.nextDoubleOrNull();
                        if (timestamp == null) continue block26;
                        ProfileChunk.access$1002(data, timestamp);
                        continue block26;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var5_5);
            }
            data.setUnknown(unknown);
            var1_1.endObject();
            return var3_3;
        }
    }
}

