/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HostnameCache;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SentryThreadFactory;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Cached;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.User;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MainEventProcessor
implements EventProcessor,
Closeable {
    private final SentryOptions options;
    private final SentryThreadFactory sentryThreadFactory;
    private final SentryExceptionFactory sentryExceptionFactory;
    private volatile HostnameCache hostnameCache = null;
    private final AutoClosableReentrantLock hostnameCacheLock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public MainEventProcessor(SentryOptions options) {
        void var1_1;
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory((SentryStackTraceFactory)var1_1, this.options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEvent process(SentryEvent event, Hint hint) {
        void var1_1;
        this.setCommons(event);
        this.setExceptions(event);
        this.setDebugMeta(event);
        this.setModules(event);
        if (this.shouldApplyScopeData(event, hint)) {
            void var2_2;
            this.processNonCachedEvent(event);
            this.setThreads(event, (Hint)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setDebugMeta(SentryBaseEvent event) {
        DebugMeta debugMeta = DebugMeta.buildDebugMeta(event.getDebugMeta(), this.options);
        if (debugMeta != null) {
            void var2_2;
            void var1_1;
            var1_1.setDebugMeta((DebugMeta)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setModules(SentryEvent event) {
        void var2_2;
        void var3_3;
        Map<String, String> modules = this.options.getModulesLoader().getOrLoadModules();
        if (modules == null) {
            return;
        }
        Map<String, String> eventModules = event.getModules();
        if (eventModules == null) {
            void var1_1;
            var1_1.setModules(modules);
            return;
        }
        var3_3.putAll(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", var1_1.getEventId());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void processNonCachedEvent(SentryBaseEvent event) {
        void var1_1;
        this.setRelease(event);
        this.setEnvironment(event);
        this.setServerName(event);
        this.setDist(event);
        this.setSdk(event);
        this.setTags(event);
        this.mergeUser((SentryBaseEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setCommons(SentryBaseEvent event) {
        void var1_1;
        this.setPlatform((SentryBaseEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setPlatform(SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            void var1_1;
            var1_1.setPlatform("java");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setRelease(SentryBaseEvent event) {
        if (event.getRelease() == null) {
            void var1_1;
            var1_1.setRelease(this.options.getRelease());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnvironment(SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            void var1_1;
            var1_1.setEnvironment(this.options.getEnvironment());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setServerName(SentryBaseEvent event) {
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && event.getServerName() == null) {
            this.ensureHostnameCache();
            if (this.hostnameCache != null) {
                void var1_1;
                var1_1.setServerName(this.hostnameCache.getHostname());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureHostnameCache() {
        if (this.hostnameCache == null) {
            ISentryLifecycleToken ignored = this.hostnameCacheLock.acquire();
            try {
                if (this.hostnameCache == null) {
                    this.hostnameCache = HostnameCache.getInstance();
                }
                if (ignored != null) {
                    ignored.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setDist(SentryBaseEvent event) {
        if (event.getDist() == null) {
            void var1_1;
            var1_1.setDist(this.options.getDist());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSdk(SentryBaseEvent event) {
        if (event.getSdk() == null) {
            void var1_1;
            var1_1.setSdk(this.options.getSdkVersion());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setTags(SentryBaseEvent event) {
        if (event.getTags() == null) {
            event.setTags(new HashMap<String, String>(this.options.getTags()));
            return;
        }
        for (Map.Entry<String, String> item : this.options.getTags().entrySet()) {
            void var3_3;
            if (event.getTags().containsKey(item.getKey())) continue;
            event.setTag(item.getKey(), (String)var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeUser(SentryBaseEvent event) {
        User user = event.getUser();
        if (user == null) {
            void var1_1;
            user = new User();
            var1_1.setUser(user);
        }
        if (user.getIpAddress() == null && this.options.isSendDefaultPii()) {
            void var2_2;
            var2_2.setIpAddress("{{auto}}");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setExceptions(SentryEvent event) {
        Throwable throwable = event.getThrowableMechanism();
        if (throwable != null) {
            void var2_2;
            void var1_1;
            var1_1.setExceptions(this.sentryExceptionFactory.getSentryExceptions((Throwable)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setThreads(SentryEvent event, Hint hint) {
        if (event.getThreads() == null) {
            void var2_2;
            ArrayList<Long> mechanismThreadIds = null;
            List<SentryException> eventExceptions = event.getExceptions();
            if (eventExceptions != null && !eventExceptions.isEmpty()) {
                for (SentryException item : eventExceptions) {
                    if (item.getMechanism() == null || item.getThreadId() == null) continue;
                    if (mechanismThreadIds == null) {
                        mechanismThreadIds = new ArrayList<Long>();
                    }
                    mechanismThreadIds.add(item.getThreadId());
                }
            }
            if (this.options.isAttachThreads() || HintUtils.hasType(hint, AbnormalExit.class)) {
                void var3_3;
                Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
                boolean ignoreCurrentThread = false;
                if (sentrySdkHint instanceof AbnormalExit) {
                    ignoreCurrentThread = ((AbnormalExit)sentrySdkHint).ignoreCurrentThread();
                }
                event.setThreads(this.sentryThreadFactory.getCurrentThreads((List<Long>)var3_3, ignoreCurrentThread));
                return;
            }
            if (this.options.isAttachStacktrace() && (eventExceptions == null || eventExceptions.isEmpty()) && !this.isCachedHint((Hint)var2_2)) {
                void var1_1;
                var1_1.setThreads(this.sentryThreadFactory.getCurrentThread());
            }
        }
    }

    private boolean isCachedHint(Hint hint) {
        return HintUtils.hasType(hint, Cached.class);
    }

    @Override
    public final void close() throws IOException {
        if (this.hostnameCache != null) {
            this.hostnameCache.close();
        }
    }
}

