/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonReflectionObjectSerializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.util.JsonSerializationUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class JsonObjectSerializer {
    public final JsonReflectionObjectSerializer jsonReflectionObjectSerializer;

    /*
     * WARNING - void declaration
     */
    public JsonObjectSerializer(int maxDepth) {
        void var1_1;
        this.jsonReflectionObjectSerializer = new JsonReflectionObjectSerializer((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(ObjectWriter writer, ILogger logger, Object object) throws IOException {
        if (object == null) {
            writer.nullValue();
            return;
        }
        if (object instanceof Character) {
            writer.value(Character.toString(((Character)object).charValue()));
            return;
        }
        if (object instanceof String) {
            writer.value((String)object);
            return;
        }
        if (object instanceof Boolean) {
            writer.value((boolean)((Boolean)object));
            return;
        }
        if (object instanceof Number) {
            writer.value((Number)object);
            return;
        }
        if (object instanceof Date) {
            this.serializeDate(writer, logger, (Date)object);
            return;
        }
        if (object instanceof TimeZone) {
            this.serializeTimeZone(writer, logger, (TimeZone)object);
            return;
        }
        if (object instanceof JsonSerializable) {
            ((JsonSerializable)object).serialize(writer, logger);
            return;
        }
        if (object instanceof Collection) {
            this.serializeCollection(writer, logger, (Collection)object);
            return;
        }
        if (object.getClass().isArray()) {
            this.serializeCollection(writer, logger, Arrays.asList((Object[])object));
            return;
        }
        if (object instanceof Map) {
            this.serializeMap(writer, logger, (Map)object);
            return;
        }
        if (object instanceof Locale) {
            writer.value(object.toString());
            return;
        }
        if (object instanceof AtomicIntegerArray) {
            this.serializeCollection(writer, logger, JsonSerializationUtils.atomicIntegerArrayToList((AtomicIntegerArray)object));
            return;
        }
        if (object instanceof AtomicBoolean) {
            writer.value(((AtomicBoolean)object).get());
            return;
        }
        if (object instanceof URI) {
            writer.value(object.toString());
            return;
        }
        if (object instanceof InetAddress) {
            writer.value(object.toString());
            return;
        }
        if (object instanceof UUID) {
            writer.value(object.toString());
            return;
        }
        if (object instanceof Currency) {
            writer.value(object.toString());
            return;
        }
        if (object instanceof Calendar) {
            this.serializeMap(writer, logger, JsonSerializationUtils.calendarToMap((Calendar)object));
            return;
        }
        if (object.getClass().isEnum()) {
            writer.value(object.toString());
            return;
        }
        try {
            Object serializableObject = this.jsonReflectionObjectSerializer.serialize(object, logger);
            this.serialize(writer, logger, serializableObject);
            return;
        }
        catch (Exception exception) {
            void var1_1;
            void var3_4;
            void var2_2;
            var2_2.log(SentryLevel.ERROR, "Failed serializing unknown object.", (Throwable)var3_4);
            var1_1.value("[OBJECT]");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void serializeDate(ObjectWriter writer, ILogger logger, Date date) throws IOException {
        try {
            writer.value(DateUtils.getTimestamp(date));
            return;
        }
        catch (Exception e) {
            void var1_1;
            void var3_4;
            void var2_2;
            var2_2.log(SentryLevel.ERROR, "Error when serializing Date", (Throwable)var3_4);
            var1_1.nullValue();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void serializeTimeZone(ObjectWriter writer, ILogger logger, TimeZone timeZone) throws IOException {
        try {
            writer.value(timeZone.getID());
            return;
        }
        catch (Exception e) {
            void var1_1;
            void var3_4;
            void var2_2;
            var2_2.log(SentryLevel.ERROR, "Error when serializing TimeZone", (Throwable)var3_4);
            var1_1.nullValue();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void serializeCollection(ObjectWriter writer, ILogger logger, Collection<?> collection) throws IOException {
        void var1_1;
        Iterator iterator;
        writer.beginArray();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.serialize(writer, logger, object);
        }
        var1_1.endArray();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeMap(ObjectWriter writer, ILogger logger, Map<?, ?> map) throws IOException {
        void var1_1;
        writer.beginObject();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) continue;
            writer.name((String)key);
            this.serialize(writer, logger, map.get(key));
        }
        var1_1.endObject();
    }
}

