/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectDeserializer;
import io.sentry.ObjectReader;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonReader;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class JsonObjectReader
implements ObjectReader {
    private final JsonReader jsonReader;

    /*
     * WARNING - void declaration
     */
    public JsonObjectReader(Reader in) {
        void var1_1;
        this.jsonReader = new JsonReader((Reader)var1_1);
    }

    @Override
    public final String nextStringOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextString();
    }

    @Override
    public final Double nextDoubleOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextDouble();
    }

    @Override
    public final Float nextFloatOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return Float.valueOf(this.nextFloat());
    }

    @Override
    public final float nextFloat() throws IOException {
        return (float)this.jsonReader.nextDouble();
    }

    @Override
    public final Long nextLongOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextLong();
    }

    @Override
    public final Integer nextIntegerOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextInt();
    }

    @Override
    public final Boolean nextBooleanOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextBoolean();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void nextUnknown(ILogger logger, Map<String, Object> unknown, String name) {
        try {
            unknown.put(name, this.nextObjectOrNull());
            return;
        }
        catch (Exception exception) {
            void var3_4;
            void var2_3;
            void var1_1;
            var1_1.log(SentryLevel.ERROR, (Throwable)var2_3, "Error deserializing unknown key: %s", var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<T> nextListOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        void var3_3;
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        this.jsonReader.beginArray();
        ArrayList<T> list = new ArrayList<T>();
        if (this.jsonReader.hasNext()) {
            do {
                try {
                    list.add(deserializer.deserialize(this, logger));
                }
                catch (Exception e) {
                    logger.log(SentryLevel.WARNING, "Failed to deserialize object in list.", e);
                }
            } while (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT);
        }
        this.jsonReader.endArray();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Map<String, T> nextMapOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        void var3_3;
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        this.jsonReader.beginObject();
        HashMap<String, T> map = new HashMap<String, T>();
        if (this.jsonReader.hasNext()) {
            do {
                try {
                    String key = this.jsonReader.nextName();
                    map.put(key, deserializer.deserialize(this, logger));
                }
                catch (Exception e) {
                    logger.log(SentryLevel.WARNING, "Failed to deserialize object in map.", e);
                }
            } while (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT || this.jsonReader.peek() == JsonToken.NAME);
        }
        this.jsonReader.endObject();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T nextOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws Exception {
        void var1_1;
        void var2_2;
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return var2_2.deserialize(this, (ILogger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date nextDateOrNull(ILogger logger) throws IOException {
        void var1_1;
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return ObjectReader.dateOrNull(this.jsonReader.nextString(), (ILogger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TimeZone nextTimeZoneOrNull(ILogger logger) throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        try {
            return TimeZone.getTimeZone(this.jsonReader.nextString());
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            var1_1.log(SentryLevel.ERROR, "Error when deserializing TimeZone", (Throwable)var2_2);
            return null;
        }
    }

    @Override
    public final Object nextObjectOrNull() throws IOException {
        return new JsonObjectDeserializer().deserialize(this);
    }

    @Override
    public final JsonToken peek() throws IOException {
        return this.jsonReader.peek();
    }

    @Override
    public final String nextName() throws IOException {
        return this.jsonReader.nextName();
    }

    @Override
    public final void beginObject() throws IOException {
        this.jsonReader.beginObject();
    }

    @Override
    public final void endObject() throws IOException {
        this.jsonReader.endObject();
    }

    public final void beginArray() throws IOException {
        this.jsonReader.beginArray();
    }

    public final void endArray() throws IOException {
        this.jsonReader.endArray();
    }

    @Override
    public final int nextInt() throws IOException {
        return this.jsonReader.nextInt();
    }

    @Override
    public final long nextLong() throws IOException {
        return this.jsonReader.nextLong();
    }

    @Override
    public final String nextString() throws IOException {
        return this.jsonReader.nextString();
    }

    public final boolean nextBoolean() throws IOException {
        return this.jsonReader.nextBoolean();
    }

    @Override
    public final double nextDouble() throws IOException {
        return this.jsonReader.nextDouble();
    }

    public final void nextNull() throws IOException {
        this.jsonReader.nextNull();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLenient(boolean lenient) {
        void var1_1;
        this.jsonReader.setLenient((boolean)var1_1);
    }

    @Override
    public final void skipValue() throws IOException {
        this.jsonReader.skipValue();
    }

    @Override
    public final void close() throws IOException {
        this.jsonReader.close();
    }
}

