/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.util.Objects;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

final class HostnameCache {
    private static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    private static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private static HostnameCache INSTANCE;
    private final long cacheDuration;
    private volatile String hostname;
    private volatile long expirationTimestamp;
    private final AtomicBoolean updateRunning = new AtomicBoolean(false);
    private final Callable<InetAddress> getLocalhost;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new HostnameCacheThreadFactory());

    static HostnameCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostnameCache();
        }
        return INSTANCE;
    }

    private HostnameCache() {
        this(HOSTNAME_CACHE_DURATION);
    }

    /*
     * WARNING - void declaration
     */
    HostnameCache(long cacheDuration) {
        this((long)var1_1, () -> InetAddress.getLocalHost());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    HostnameCache(long cacheDuration, Callable<InetAddress> getLocalhost) {
        void var3_2;
        void var1_1;
        this.cacheDuration = var1_1;
        this.getLocalhost = (Callable)Objects.requireNonNull(var3_2, "getLocalhost is required");
        this.updateCache();
    }

    final void close() {
        this.executorService.shutdown();
    }

    final String getHostname() {
        if (this.expirationTimestamp < System.currentTimeMillis() && this.updateRunning.compareAndSet(false, true)) {
            this.updateCache();
        }
        return this.hostname;
    }

    private void updateCache() {
        Callable<Void> hostRetriever = () -> {
            try {
                this.hostname = this.getLocalhost.call().getCanonicalHostName();
                this.expirationTimestamp = System.currentTimeMillis() + this.cacheDuration;
            }
            finally {
                this.updateRunning.set(false);
            }
            return null;
        };
        try {
            Future future;
            future = this.executorService.submit(future);
            future.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.handleCacheUpdateFailure();
            return;
        }
        catch (RuntimeException | ExecutionException | TimeoutException exception) {
            this.handleCacheUpdateFailure();
            return;
        }
    }

    private void handleCacheUpdateFailure() {
        this.expirationTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
    }

    private static final class HostnameCacheThreadFactory
    implements ThreadFactory {
        private int cnt;

        private HostnameCacheThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(Runnable r) {
            void var1_1;
            Thread ret = new Thread(r, "SentryHostnameCache-" + this.cnt++);
            ret.setDaemon(true);
            return var1_1;
        }
    }
}

