/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Attachment;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ReplayRecording;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Hint {
    private static final Map<String, Class<?>> PRIMITIVE_MAPPINGS = new HashMap();
    private final Map<String, Object> internalStorage = new HashMap<String, Object>();
    private final List<Attachment> attachments = new ArrayList<Attachment>();
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    private Attachment screenshot = null;
    private Attachment viewHierarchy = null;
    private Attachment threadDump = null;
    private ReplayRecording replayRecording = null;

    /*
     * WARNING - void declaration
     */
    public final void set(String name, Object hint) {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            void var2_3;
            void var1_1;
            this.internalStorage.put((String)var1_1, var2_3);
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var3_5;
                    var3_5.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Object get(String name) {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            Object object;
            object = this.internalStorage.get(object);
            if (ignored != null) {
                ignored.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T getAs(String name, Class<T> clazz) {
        ISentryLifecycleToken ignored;
        block9: {
            void var2_3;
            block10: {
                void var1_1;
                Object hintValue;
                block7: {
                    block8: {
                        ignored = this.lock.acquire();
                        try {
                            hintValue = this.internalStorage.get(name);
                            if (!((Class)clazz).isInstance(hintValue)) break block7;
                            clazz = hintValue;
                            if (ignored == null) break block8;
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            if (ignored != null) {
                                try {
                                    void var3_5;
                                    var3_5.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return (T)clazz;
                }
                if (!this.isCastablePrimitive(hintValue, (Class<?>)var2_3)) break block9;
                var2_3 = var1_1;
                if (ignored == null) break block10;
                ignored.close();
            }
            return var2_3;
        }
        if (ignored != null) {
            ignored.close();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void addAttachments(List<Attachment> attachments) {
        if (attachments != null) {
            void var1_1;
            this.attachments.addAll((Collection<Attachment>)var1_1);
        }
    }

    public final List<Attachment> getAttachments() {
        return new ArrayList<Attachment>(this.attachments);
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            Iterator<Map.Entry<String, Object>> iterator = this.internalStorage.entrySet().iterator();
            while (iterator.hasNext()) {
                void var3_4;
                Map.Entry<String, Object> entry = iterator.next();
                if (entry.getKey() != null && ((String)var3_4.getKey()).startsWith("sentry:")) continue;
                iterator.remove();
            }
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public final Attachment getScreenshot() {
        return this.screenshot;
    }

    public final Attachment getViewHierarchy() {
        return this.viewHierarchy;
    }

    public final Attachment getThreadDump() {
        return this.threadDump;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCastablePrimitive(Object hintValue, Class<?> clazz) {
        void var1_1;
        void var3_3;
        void var2_2;
        Class<?> nonPrimitiveClass = PRIMITIVE_MAPPINGS.get(clazz.getCanonicalName());
        return hintValue != null && var2_2.isPrimitive() && nonPrimitiveClass != null && var3_3.isInstance(var1_1);
    }

    static {
        PRIMITIVE_MAPPINGS.put("boolean", Boolean.class);
        PRIMITIVE_MAPPINGS.put("char", Character.class);
        PRIMITIVE_MAPPINGS.put("byte", Byte.class);
        PRIMITIVE_MAPPINGS.put("short", Short.class);
        PRIMITIVE_MAPPINGS.put("int", Integer.class);
        PRIMITIVE_MAPPINGS.put("long", Long.class);
        PRIMITIVE_MAPPINGS.put("float", Float.class);
        PRIMITIVE_MAPPINGS.put("double", Double.class);
    }
}

